/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import java.util.ArrayList;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.renderer.crs.WrappingProjectionHandler;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.WKTReader;

public class WrappingProjectionHandlerTest {
    final GeometryFactory gf = new GeometryFactory();
    final WKTReader wktReader = new WKTReader();

    @Test
    public void testAccumulateWithDifferentGeometryTypes() throws Exception {
        ArrayList resultGeoms = new ArrayList();
        Geometry point = this.wktReader.read("POINT(1 1)");
        Geometry line = this.wktReader.read("LINESTRING(1 1, 1 2, 2 2)");
        GeometryCollection collection = new GeometryCollection(new Geometry[]{point, line}, this.gf);
        ReferencedEnvelope envelope = new ReferencedEnvelope(0.0, 5.0, 0.0, 5.0, CRS.decode((String)"EPSG:4326"));
        Class resultClass = WrappingProjectionHandler.accumulate(resultGeoms, (Geometry)collection, null, (ReferencedEnvelope)envelope);
        Assert.assertEquals(Geometry.class, (Object)resultClass);
    }
}

