/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.text;

import org.geotools.geometry.iso.MockGeometryFactory;
import org.geotools.geometry.iso.MockPositionFactory;
import org.geotools.geometry.iso.text.WKTParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.PositionFactory;
import org.opengis.geometry.coordinate.GeometryFactory;
import org.opengis.geometry.primitive.Curve;
import org.opengis.geometry.primitive.Point;
import org.opengis.geometry.primitive.PrimitiveFactory;

public class WKTParserTest {
    WKTParser parser;

    @Before
    public void setUp() throws Exception {
        MockGeometryFactory mockFactory = new MockGeometryFactory();
        MockPositionFactory pf = new MockPositionFactory();
        this.parser = new WKTParser((GeometryFactory)mockFactory, (PrimitiveFactory)mockFactory, (PositionFactory)pf, null);
    }

    @Test
    public void testPoint1() throws Exception {
        String WKT = "POINT (80 340)";
        Geometry geometry = this.parser.parse(WKT);
        Assert.assertNotNull((Object)geometry);
        Assert.assertTrue((boolean)(geometry instanceof Point));
        Point point = (Point)geometry;
        Assert.assertNotNull((Object)point.getDirectPosition());
        Assert.assertEquals((double)80.0, (double)point.getDirectPosition().getOrdinate(0), (double)0.0);
        Assert.assertEquals((double)340.0, (double)point.getDirectPosition().getOrdinate(1), (double)0.0);
    }

    @Test
    public void testPoint2() throws Exception {
        String WKT = "POINT (320.324 180.234)";
        Geometry geometry = this.parser.parse(WKT);
        Assert.assertNotNull((Object)geometry);
        Assert.assertTrue((boolean)(geometry instanceof Point));
        Point point = (Point)geometry;
        Assert.assertEquals((double)320.324, (double)point.getDirectPosition().getOrdinate(0), (double)0.0);
        Assert.assertEquals((double)180.234, (double)point.getDirectPosition().getOrdinate(1), (double)0.0);
    }

    @Test
    public void testPoint3() throws Exception {
        String WKT = "POINT (260.01 -360.55)";
        Geometry geometry = this.parser.parse(WKT);
        Assert.assertNotNull((Object)geometry);
        Assert.assertTrue((boolean)(geometry instanceof Point));
        Point point = (Point)geometry;
        Assert.assertEquals((double)260.01, (double)point.getDirectPosition().getOrdinate(0), (double)0.0);
        Assert.assertEquals((double)-360.55, (double)point.getDirectPosition().getOrdinate(1), (double)0.0);
    }

    @Test
    public void testLine1() throws Exception {
        String WKT = "LINESTRING (60 380, 60 20, 200 400, 280 20, 360 400, 420 20, 500 400, 580 20, 620 400)";
        Geometry geometry = this.parser.parse(WKT);
        Assert.assertNotNull((Object)geometry);
        Assert.assertTrue((boolean)(geometry instanceof Curve));
    }

    @Test
    public void testLine2() throws Exception {
        String WKT = "LINESTRING (80 360, 520 360, 520 40, 120 40, 120 300, 460 300, 460 100, 200 100, 200 240, 400 240, 400 140, 560 0)";
        Geometry geometry = this.parser.parse(WKT);
        Assert.assertNotNull((Object)geometry);
        Assert.assertTrue((boolean)(geometry instanceof Curve));
    }
}

