/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.ArrayList;
import java.util.Arrays;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.visitor.LiteralDemultiplyingFilterVisitor;
import org.geotools.geometry.jts.GeometryBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Point;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.temporal.After;

public class LiteralDemultiplyingFilterVisitorTest {
    static final FilterFactory2 fac = CommonFactoryFinder.getFilterFactory2(null);

    @Test
    public void testBinaryComparisonFilter() throws IllegalFilterException {
        LiteralDemultiplyingFilterVisitor visitor = new LiteralDemultiplyingFilterVisitor();
        Integer object1 = 1;
        Integer object2 = 2;
        Integer object3 = 3;
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(object1);
        values.add(object2);
        values.add(object3);
        PropertyName property = fac.property("property");
        Literal literal = fac.literal(values);
        Literal literal1 = fac.literal((Object)object1);
        Literal literal2 = fac.literal((Object)object2);
        Literal literal3 = fac.literal((Object)object3);
        PropertyIsGreaterThan filter = fac.greater((Expression)property, (Expression)literal, true, MultiValuedFilter.MatchAction.ANY);
        Or expected = fac.or(new ArrayList<PropertyIsGreaterThan>(Arrays.asList(fac.greater((Expression)property, (Expression)literal1, true, MultiValuedFilter.MatchAction.ANY), fac.greater((Expression)property, (Expression)literal2, true, MultiValuedFilter.MatchAction.ANY), fac.greater((Expression)property, (Expression)literal3, true, MultiValuedFilter.MatchAction.ANY))));
        Filter demultiplied = (Filter)filter.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)demultiplied, (Object)expected);
        filter = fac.greater((Expression)property, (Expression)literal, true, MultiValuedFilter.MatchAction.ALL);
        expected = fac.and(new ArrayList<PropertyIsGreaterThan>(Arrays.asList(fac.greater((Expression)property, (Expression)literal1, true, MultiValuedFilter.MatchAction.ALL), fac.greater((Expression)property, (Expression)literal2, true, MultiValuedFilter.MatchAction.ALL), fac.greater((Expression)property, (Expression)literal3, true, MultiValuedFilter.MatchAction.ALL))));
        demultiplied = (Filter)filter.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)demultiplied, (Object)expected);
        filter = fac.greater((Expression)property, (Expression)literal, true, MultiValuedFilter.MatchAction.ONE);
        expected = fac.or(new ArrayList<And>(Arrays.asList(fac.and(new ArrayList<Filter>(Arrays.asList(fac.greater((Expression)property, (Expression)literal1, true, MultiValuedFilter.MatchAction.ONE), fac.not((Filter)fac.greater((Expression)property, (Expression)literal2, true, MultiValuedFilter.MatchAction.ONE)), fac.not((Filter)fac.greater((Expression)property, (Expression)literal3, true, MultiValuedFilter.MatchAction.ONE))))), fac.and(new ArrayList<Filter>(Arrays.asList(fac.not((Filter)fac.greater((Expression)property, (Expression)literal1, true, MultiValuedFilter.MatchAction.ONE)), fac.greater((Expression)property, (Expression)literal2, true, MultiValuedFilter.MatchAction.ONE), fac.not((Filter)fac.greater((Expression)property, (Expression)literal3, true, MultiValuedFilter.MatchAction.ONE))))), fac.and(new ArrayList<Filter>(Arrays.asList(fac.not((Filter)fac.greater((Expression)property, (Expression)literal1, true, MultiValuedFilter.MatchAction.ONE)), fac.not((Filter)fac.greater((Expression)property, (Expression)literal2, true, MultiValuedFilter.MatchAction.ONE)), fac.greater((Expression)property, (Expression)literal3, true, MultiValuedFilter.MatchAction.ONE)))))));
        demultiplied = (Filter)filter.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)demultiplied, (Object)expected);
    }

    @Test
    public void testBinarySpatialFilter() throws IllegalFilterException {
        GeometryBuilder builder = new GeometryBuilder();
        LiteralDemultiplyingFilterVisitor visitor = new LiteralDemultiplyingFilterVisitor();
        Point object1 = builder.point(1.0, 2.0);
        Point object2 = builder.point(3.0, 4.0);
        Point object3 = builder.point(5.0, 6.0);
        ArrayList<Point> values = new ArrayList<Point>();
        values.add(object1);
        values.add(object2);
        values.add(object3);
        PropertyName property = fac.property("property");
        Literal literal = fac.literal(values);
        Literal literal1 = fac.literal((Object)object1);
        Literal literal2 = fac.literal((Object)object2);
        Literal literal3 = fac.literal((Object)object3);
        Beyond filter = fac.beyond((Expression)property, (Expression)literal, 5.0, "x", MultiValuedFilter.MatchAction.ANY);
        Or expected = fac.or(new ArrayList<Beyond>(Arrays.asList(fac.beyond((Expression)property, (Expression)literal1, 5.0, "x", MultiValuedFilter.MatchAction.ANY), fac.beyond((Expression)property, (Expression)literal2, 5.0, "x", MultiValuedFilter.MatchAction.ANY), fac.beyond((Expression)property, (Expression)literal3, 5.0, "x", MultiValuedFilter.MatchAction.ANY))));
        Filter demultiplied = (Filter)filter.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)demultiplied, (Object)expected);
        filter = fac.beyond((Expression)property, (Expression)literal, 5.0, "x", MultiValuedFilter.MatchAction.ALL);
        expected = fac.and(new ArrayList<Beyond>(Arrays.asList(fac.beyond((Expression)property, (Expression)literal1, 5.0, "x", MultiValuedFilter.MatchAction.ANY), fac.beyond((Expression)property, (Expression)literal2, 5.0, "x", MultiValuedFilter.MatchAction.ANY), fac.beyond((Expression)property, (Expression)literal3, 5.0, "x", MultiValuedFilter.MatchAction.ANY))));
        demultiplied = (Filter)filter.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)demultiplied, (Object)expected);
        filter = fac.beyond((Expression)property, (Expression)literal, 5.0, "x", MultiValuedFilter.MatchAction.ONE);
        expected = fac.or(new ArrayList<And>(Arrays.asList(fac.and(new ArrayList<Filter>(Arrays.asList(fac.beyond((Expression)property, (Expression)literal1, 5.0, "x", MultiValuedFilter.MatchAction.ONE), fac.not((Filter)fac.beyond((Expression)property, (Expression)literal2, 5.0, "x", MultiValuedFilter.MatchAction.ONE)), fac.not((Filter)fac.beyond((Expression)property, (Expression)literal3, 5.0, "x", MultiValuedFilter.MatchAction.ONE))))), fac.and(new ArrayList<Filter>(Arrays.asList(fac.not((Filter)fac.beyond((Expression)property, (Expression)literal1, 5.0, "x", MultiValuedFilter.MatchAction.ONE)), fac.beyond((Expression)property, (Expression)literal2, 5.0, "x", MultiValuedFilter.MatchAction.ONE), fac.not((Filter)fac.beyond((Expression)property, (Expression)literal3, 5.0, "x", MultiValuedFilter.MatchAction.ONE))))), fac.and(new ArrayList<Filter>(Arrays.asList(fac.not((Filter)fac.beyond((Expression)property, (Expression)literal1, 5.0, "x", MultiValuedFilter.MatchAction.ONE)), fac.not((Filter)fac.beyond((Expression)property, (Expression)literal2, 5.0, "x", MultiValuedFilter.MatchAction.ONE)), fac.beyond((Expression)property, (Expression)literal3, 5.0, "x", MultiValuedFilter.MatchAction.ONE)))))));
        demultiplied = (Filter)filter.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)demultiplied, (Object)expected);
    }

    @Test
    public void testBinaryTemporalFilter() throws IllegalFilterException {
        LiteralDemultiplyingFilterVisitor visitor = new LiteralDemultiplyingFilterVisitor();
        String object1 = "2014-01-01";
        String object2 = "2014-02-02";
        String object3 = "2014-03-03";
        ArrayList<String> values = new ArrayList<String>();
        values.add(object1);
        values.add(object2);
        values.add(object3);
        PropertyName property = fac.property("property");
        Literal literal = fac.literal(values);
        Literal literal1 = fac.literal((Object)object1);
        Literal literal2 = fac.literal((Object)object2);
        Literal literal3 = fac.literal((Object)object3);
        After filter = fac.after((Expression)property, (Expression)literal, MultiValuedFilter.MatchAction.ANY);
        Or expected = fac.or(new ArrayList<After>(Arrays.asList(fac.after((Expression)property, (Expression)literal1, MultiValuedFilter.MatchAction.ANY), fac.after((Expression)property, (Expression)literal2, MultiValuedFilter.MatchAction.ANY), fac.after((Expression)property, (Expression)literal3, MultiValuedFilter.MatchAction.ANY))));
        Filter demultiplied = (Filter)filter.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)demultiplied, (Object)expected);
        filter = fac.after((Expression)property, (Expression)literal, MultiValuedFilter.MatchAction.ALL);
        expected = fac.and(new ArrayList<After>(Arrays.asList(fac.after((Expression)property, (Expression)literal1, MultiValuedFilter.MatchAction.ALL), fac.after((Expression)property, (Expression)literal2, MultiValuedFilter.MatchAction.ALL), fac.after((Expression)property, (Expression)literal3, MultiValuedFilter.MatchAction.ALL))));
        demultiplied = (Filter)filter.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)demultiplied, (Object)expected);
        filter = fac.after((Expression)property, (Expression)literal, MultiValuedFilter.MatchAction.ONE);
        expected = fac.or(new ArrayList<And>(Arrays.asList(fac.and(new ArrayList<Filter>(Arrays.asList(fac.after((Expression)property, (Expression)literal1, MultiValuedFilter.MatchAction.ONE), fac.not((Filter)fac.after((Expression)property, (Expression)literal2, MultiValuedFilter.MatchAction.ONE)), fac.not((Filter)fac.after((Expression)property, (Expression)literal3, MultiValuedFilter.MatchAction.ONE))))), fac.and(new ArrayList<Filter>(Arrays.asList(fac.not((Filter)fac.after((Expression)property, (Expression)literal1, MultiValuedFilter.MatchAction.ONE)), fac.after((Expression)property, (Expression)literal2, MultiValuedFilter.MatchAction.ONE), fac.not((Filter)fac.after((Expression)property, (Expression)literal3, MultiValuedFilter.MatchAction.ONE))))), fac.and(new ArrayList<Filter>(Arrays.asList(fac.not((Filter)fac.after((Expression)property, (Expression)literal1, MultiValuedFilter.MatchAction.ONE)), fac.not((Filter)fac.after((Expression)property, (Expression)literal2, MultiValuedFilter.MatchAction.ONE)), fac.after((Expression)property, (Expression)literal3, MultiValuedFilter.MatchAction.ONE)))))));
        demultiplied = (Filter)filter.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)demultiplied, (Object)expected);
    }
}

