/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import org.geotools.filter.visitor.AbstractCapabilitiesFilterSplitterTests;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.geometry.Geometry;

public class CapabilitiesFilterSplitterSpatialTest
extends AbstractCapabilitiesFilterSplitterTests {
    private Geometry geom = new AbstractCapabilitiesFilterSplitterTests.MockGeometryImpl();

    @Test
    public void testBBOX() throws Exception {
        BBOX f = this.ff.bbox("geom", 10.0, 10.0, 20.0, 20.0, "");
        this.runTest((Filter)f, this.newCapabilities(BBOX.class), "geom");
    }

    @Test
    public void testBEYOND() throws Exception {
        Beyond f = this.ff.beyond("geom", this.geom, 10.0, "");
        this.runTest((Filter)f, this.newCapabilities(Beyond.class), "geom");
    }

    @Test
    public void testCONTAINS() throws Exception {
        Contains f = this.ff.contains("geom", this.geom);
        this.runTest((Filter)f, this.newCapabilities(Contains.class), "geom");
    }

    @Test
    public void testCROSSES() throws Exception {
        Crosses f = this.ff.crosses("geom", this.geom);
        this.runTest((Filter)f, this.newCapabilities(Crosses.class), "geom");
    }

    @Test
    public void testDISJOINT() throws Exception {
        Disjoint f = this.ff.disjoint("geom", this.geom);
        this.runTest((Filter)f, this.newCapabilities(Disjoint.class), "geom");
    }

    @Test
    public void tesDWITHINt() throws Exception {
        DWithin f = this.ff.dwithin("geom", this.geom, 10.0, "");
        this.runTest((Filter)f, this.newCapabilities(DWithin.class), "geom");
    }

    @Test
    public void testEQUALS() throws Exception {
        Equals f = this.ff.equals("geom", this.geom);
        this.runTest((Filter)f, this.newCapabilities(Equals.class), "geom");
    }

    @Test
    public void testINTERSECTS() throws Exception {
        Intersects f = this.ff.intersects("geom", this.geom);
        this.runTest((Filter)f, this.newCapabilities(Intersects.class), "geom");
    }

    @Test
    public void testOVERLAPS() throws Exception {
        Overlaps f = this.ff.overlaps("geom", this.geom);
        this.runTest((Filter)f, this.newCapabilities(Overlaps.class), "geom");
    }

    @Test
    public void testTOUCHES() throws Exception {
        Touches f = this.ff.touches("geom", this.geom);
        this.runTest((Filter)f, this.newCapabilities(Touches.class), "geom");
    }

    @Test
    public void testWITHIN() throws Exception {
        Within f = this.ff.within("geom", this.geom);
        this.runTest((Filter)f, this.newCapabilities(Within.class), "geom");
    }
}

