/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.factory.CommonFactoryFinder;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;

public class JsonArrayContainsFunctionTest {
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory(null);

    @Test
    public void testArrayContainsString() {
        String json = "{\n    \"arrayString\" : [\"bar\", \"baz\"],\n    \"arrayInt\" : [1, 2],\n    \"arrayDate\" : [],\n    \"arrayDouble\" : [3.14, 4.6],\n    \"onNestedArrayStr\" : { \"nestedArray\": [\"bar\", \"baz\"] },    \"onNestedArrayInt\" : { \"nestedArray\": [4, 87] }}";
        Assert.assertTrue((boolean)((Boolean)this.containsFunction(json, "/arrayString", "bar").evaluate(null)));
        Assert.assertFalse((boolean)((Boolean)this.containsFunction(json, "/arrayString", "notpresent").evaluate(null)));
        Assert.assertFalse((boolean)((Boolean)this.containsFunction(json, "/arrayString", 1).evaluate(null)));
        Assert.assertTrue((boolean)((Boolean)this.containsFunction(json, "/arrayInt", 1).evaluate(null)));
        Assert.assertTrue((boolean)((Boolean)this.containsFunction(json, "/arrayDouble", 4.6).evaluate(null)));
        Assert.assertTrue((boolean)((Boolean)this.containsFunction(json, "/onNestedArrayStr/nestedArray", "baz").evaluate(null)));
        Assert.assertTrue((boolean)((Boolean)this.containsFunction(json, "/onNestedArrayInt/nestedArray", 87).evaluate(null)));
        Assert.assertFalse((boolean)((Boolean)this.containsFunction(json, "/nonexistingpointer", "...").evaluate(null)));
    }

    public Function containsFunction(String json, String pointer, Object expected) {
        return FF.function("jsonArrayContains", new Expression[]{FF.literal((Object)json), FF.literal((Object)pointer), FF.literal(expected)});
    }
}

