/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.filter.function.FunctionTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;

public class GeometryFunctionFilterTest
extends FunctionTestSupport {
    @Test
    public void testBasicTest() throws Exception {
        Function exp = this.ff.function("geometryType", new Expression[]{this.ff.property("geom")});
        try (SimpleFeatureIterator iter = this.featureCollection.features();){
            while (iter.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iter.next();
                Assert.assertEquals((Object)"Point", (Object)exp.evaluate((Object)feature));
            }
        }
    }

    @Test
    public void testNullTest() throws Exception {
        Function exp = this.ff.function("geometryType", new Expression[]{this.ff.property("geom")});
        try (SimpleFeatureIterator iter = this.featureCollection.features();){
            while (iter.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iter.next();
                feature.setAttribute("geom", null);
                Assert.assertNull((Object)exp.evaluate((Object)feature));
            }
        }
    }

    @Test
    public void testNull() throws Exception {
        Assert.assertNull((Object)this.ff.function("buffer", new Expression[]{this.ff.literal(null), this.ff.literal(10)}).evaluate(null));
    }
}

