/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.function.Classifier;
import org.geotools.filter.function.EqualIntervalFunction;
import org.geotools.filter.function.FunctionTestSupport;
import org.geotools.filter.function.RangedClassifier;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class EqualIntervalFunctionTest
extends FunctionTestSupport {
    private static final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    @Test
    public void testInstance() {
        Function equInt = ff.function("EqualInterval", new Expression[]{Expression.NIL});
        Assert.assertNotNull((Object)equInt);
        Assert.assertEquals((String)"test get name", (Object)"EqualInterval", (Object)equInt.getName());
    }

    @Test
    public void testSetClasses() throws Exception {
        PropertyName property = ff.property("foo");
        Literal literal = ff.literal(3);
        EqualIntervalFunction func = (EqualIntervalFunction)ff.function("EqualInterval", new Expression[]{property, literal});
        Assert.assertEquals((long)3L, (long)func.getClasses());
        func.getParameters().set(1, ff.literal(12));
        Assert.assertEquals((long)12L, (long)func.getClasses());
    }

    @Test
    public void testEvaluateWithExpressions() throws Exception {
        Literal classes = ff.literal(3);
        PropertyName name = ff.property("foo");
        Function func = ff.function("EqualInterval", new Expression[]{name, classes});
        Object classifier = func.evaluate((Object)this.featureCollection);
        Assert.assertTrue((boolean)(classifier instanceof RangedClassifier));
        RangedClassifier ranged = (RangedClassifier)classifier;
        Assert.assertEquals((long)3L, (long)ranged.getSize());
        Assert.assertEquals((Object)"4..32.667", (Object)ranged.getTitle(0));
        Assert.assertEquals((Object)"32.667..61.333", (Object)ranged.getTitle(1));
        Assert.assertEquals((Object)"61.333..90", (Object)ranged.getTitle(2));
        Assert.assertEquals((long)0L, (long)ranged.classify((Object)4.0));
        Assert.assertEquals((long)2L, (long)ranged.classify((Expression)name, (Object)this.testFeatures[1]));
        Assert.assertEquals((long)0L, (long)ranged.classify((Object)20.0));
        Assert.assertEquals((long)1L, (long)ranged.classify((Object)43.0));
        Assert.assertEquals((long)0L, (long)ranged.classify((Object)29.0));
        Assert.assertEquals((long)1L, (long)ranged.classify((Object)61.0));
        Assert.assertEquals((long)0L, (long)ranged.classify((Expression)name, (Object)this.testFeatures[6]));
        Assert.assertEquals((long)0L, (long)ranged.classify((Object)12.0));
    }

    @Test
    public void testEvaulateWithStrings() throws Exception {
        Function function = ff.function("EqualInterval", new Expression[]{ff.property("group"), ff.literal(5)});
        Classifier classifier = (Classifier)function.evaluate((Object)this.featureCollection);
        Assert.assertNotNull((Object)classifier);
        Classifier classifier2 = (Classifier)function.evaluate((Object)this.featureCollection, Classifier.class);
        Assert.assertNotNull((Object)classifier2);
        Integer number = (Integer)function.evaluate((Object)this.featureCollection, Integer.class);
        Assert.assertNull((Object)number);
    }

    @Test
    public void testUpgradeExample() {
        Function function = ff.function("equalInterval", new Expression[]{ff.property("foo"), ff.literal(12)});
        Object value = function.evaluate((Object)this.featureCollection);
        Assert.assertNotNull((String)"classifier failed", (Object)value);
        Classifier split = (Classifier)value;
        Function classify = ff.function("classify", new Expression[]{ff.property("foo"), ff.literal((Object)split)});
        SimpleFeature victim = this.testFeatures[2];
        Assert.assertEquals((String)"Feature was placed in wrong bin", (Object)2, (Object)classify.evaluate((Object)victim));
    }

    @Test
    public void testConstantValuesNumeric() {
        Function function = ff.function("equalInterval", new Expression[]{ff.property("v"), ff.literal(12)});
        RangedClassifier classifier = (RangedClassifier)function.evaluate((Object)this.constantCollection);
        Assert.assertNotNull((Object)classifier);
        Assert.assertEquals((long)1L, (long)classifier.getSize());
        Assert.assertEquals((double)123.123, (double)((Double)classifier.getMin(0)), (double)0.0);
        Assert.assertEquals((double)123.123, (double)((Double)classifier.getMax(0)), (double)0.0);
    }

    @Test
    public void testConstantValuesString() {
        Function function = ff.function("equalInterval", new Expression[]{ff.property("s"), ff.literal(12)});
        RangedClassifier classifier = (RangedClassifier)function.evaluate((Object)this.constantCollection);
        Assert.assertNotNull((Object)classifier);
        Assert.assertEquals((long)1L, (long)classifier.getSize());
        Assert.assertEquals((Object)"abc", (Object)classifier.getMin(0));
        Assert.assertEquals((Object)"abc", (Object)classifier.getMax(0));
    }

    @Test
    public void testEvaluateNumericalWithPercentages() {
        Literal classes = ff.literal(3);
        PropertyName name = ff.property("foo");
        Function func = ff.function("EqualInterval", new Expression[]{name, classes, ff.literal(true)});
        Object classifier = func.evaluate((Object)this.featureCollection);
        Assert.assertTrue((boolean)(classifier instanceof RangedClassifier));
        RangedClassifier ranged = (RangedClassifier)classifier;
        double[] percentages = ranged.getPercentages();
        Assert.assertEquals((long)3L, (long)percentages.length);
        Assert.assertEquals((double)62.5, (double)percentages[0], (double)0.0);
        Assert.assertEquals((double)25.0, (double)percentages[1], (double)0.0);
        Assert.assertEquals((double)12.5, (double)percentages[2], (double)0.0);
    }

    @Test
    public void testEvaluateNumericalWithPercentagesAndOutlier() throws SchemaException {
        SimpleFeatureType dataType = DataUtilities.createType((String)"classification.test1", (String)"id:0,foo:int,geom:Point");
        int[] iVal = new int[]{1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        ListFeatureCollection featureCollection = new ListFeatureCollection(dataType);
        GeometryFactory fac = new GeometryFactory();
        featureCollection = new ListFeatureCollection(dataType);
        for (int i = 0; i < iVal.length; ++i) {
            SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)dataType, (Object[])new Object[]{i + 1, iVal[i], fac.createPoint(new Coordinate((double)iVal[i], (double)iVal[i]))}, (String)("classification.t" + (i + 1)));
            featureCollection.add(feature);
        }
        Literal classes = ff.literal(3);
        PropertyName name = ff.property("foo");
        Function func = ff.function("EqualInterval", new Expression[]{name, classes, ff.literal(true)});
        Object classifier = func.evaluate((Object)featureCollection);
        Assert.assertTrue((boolean)(classifier instanceof RangedClassifier));
        RangedClassifier ranged = (RangedClassifier)classifier;
        double[] percentages = ranged.getPercentages();
        Assert.assertEquals((long)3L, (long)percentages.length);
        Assert.assertEquals((double)33.0, (double)Math.floor(percentages[0]), (double)0.0);
        Assert.assertEquals((double)26.0, (double)Math.floor(percentages[1]), (double)0.0);
        Assert.assertEquals((double)39.0, (double)Math.floor(percentages[2]), (double)0.0);
    }

    @Test
    public void testEvaluateNonNumericalWithPercentages() {
        Literal classes = ff.literal(3);
        PropertyName name = ff.property("foo");
        Function func = ff.function("EqualInterval", new Expression[]{name, classes, ff.literal(true)});
        Object classifier = func.evaluate((Object)this.featureCollection);
        Assert.assertTrue((boolean)(classifier instanceof RangedClassifier));
        RangedClassifier ranged = (RangedClassifier)classifier;
        double[] percentages = ranged.getPercentages();
        Assert.assertEquals((long)3L, (long)percentages.length);
        Assert.assertEquals((double)62.5, (double)percentages[0], (double)0.0);
        Assert.assertEquals((double)25.0, (double)percentages[1], (double)0.0);
        Assert.assertEquals((double)12.5, (double)percentages[2], (double)0.0);
    }
}

