/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.SimpleFeaturePropertyAccessorFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class SimpleFeaturePropertyAccessorTest {
    private static final String COMPLEX_PROPERTY = "pro.per.ty-G\\u00e9n\\\\u00e9rique:abc";
    SimpleFeatureType type;
    SimpleFeature feature;
    PropertyAccessor accessor = SimpleFeaturePropertyAccessorFactory.ATTRIBUTE_ACCESS;

    @Before
    public void setUp() throws Exception {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("test");
        typeBuilder.setNamespaceURI("http://www.geotools.org/test");
        typeBuilder.add("foo", Integer.class);
        typeBuilder.add("bar", Double.class);
        typeBuilder.add(COMPLEX_PROPERTY, Double.class);
        this.type = typeBuilder.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(this.type);
        builder.add((Object)1);
        builder.add((Object)2.0);
        builder.add((Object)3.0);
        this.feature = builder.buildFeature("fid");
        this.accessor = SimpleFeaturePropertyAccessorFactory.ATTRIBUTE_ACCESS;
    }

    @Test
    public void testCanHandle() {
        Assert.assertTrue((boolean)this.accessor.canHandle((Object)this.feature, "foo", null));
        Assert.assertTrue((boolean)this.accessor.canHandle((Object)this.feature, "bar", null));
        Assert.assertFalse((boolean)this.accessor.canHandle((Object)this.feature, "illegal", null));
    }

    @Test
    public void testCanHandleType() {
        Assert.assertTrue((boolean)this.accessor.canHandle((Object)this.type, "foo", null));
        Assert.assertTrue((boolean)this.accessor.canHandle((Object)this.type, "sf:foo", null));
        Assert.assertTrue((boolean)this.accessor.canHandle((Object)this.type, "foo[1]", null));
        Assert.assertTrue((boolean)this.accessor.canHandle((Object)this.type, "sf:foo[1]", null));
        Assert.assertTrue((boolean)this.accessor.canHandle((Object)this.type, "bar", null));
        Assert.assertTrue((boolean)this.accessor.canHandle((Object)this.type, COMPLEX_PROPERTY, null));
        Assert.assertFalse((boolean)this.accessor.canHandle((Object)this.type, "illegal", null));
        Assert.assertFalse((boolean)this.accessor.canHandle((Object)this.type, "sf:foo[0]", null));
        Assert.assertFalse((boolean)this.accessor.canHandle((Object)this.type, "sf:foo[2]", null));
    }

    @Test
    public void testGet() {
        Assert.assertEquals((Object)1, (Object)this.accessor.get((Object)this.feature, "foo", null));
        Assert.assertEquals((Object)1, (Object)this.accessor.get((Object)this.feature, "sf:foo", null));
        Assert.assertEquals((Object)1, (Object)this.accessor.get((Object)this.feature, "foo[1]", null));
        Assert.assertEquals((Object)1, (Object)this.accessor.get((Object)this.feature, "sf:foo[1]", null));
        Assert.assertEquals((Object)2.0, (Object)this.accessor.get((Object)this.feature, "bar", null));
        Assert.assertEquals((Object)3.0, (Object)this.accessor.get((Object)this.feature, COMPLEX_PROPERTY, null));
        Assert.assertEquals((Object)"fid", (Object)SimpleFeaturePropertyAccessorFactory.FID_ACCESS.get((Object)this.feature, "@id", null));
        Assert.assertEquals((Object)"fid", (Object)SimpleFeaturePropertyAccessorFactory.FID_ACCESS.get((Object)this.feature, "@gml:id", null));
        Assert.assertFalse((boolean)this.accessor.canHandle((Object)this.feature, "illegal", null));
        Assert.assertNull((Object)this.accessor.get((Object)this.feature, "illegal", null));
    }

    @Test
    public void testGetType() {
        Assert.assertEquals((Object)this.type.getDescriptor("foo"), (Object)this.accessor.get((Object)this.type, "foo", null));
        Assert.assertEquals((Object)this.type.getDescriptor("bar"), (Object)this.accessor.get((Object)this.type, "bar", null));
        Assert.assertNull((Object)this.accessor.get((Object)this.type, "illegal", null));
    }

    @Test
    public void testSet() {
        try {
            this.accessor.set((Object)this.feature, "foo", (Object)2, null);
        }
        catch (IllegalAttributeException e) {
            Assert.fail();
        }
        Assert.assertEquals((Object)2, (Object)this.accessor.get((Object)this.feature, "foo", null));
        try {
            this.accessor.set((Object)this.feature, "bar", (Object)1.0, null);
        }
        catch (IllegalAttributeException e) {
            Assert.fail();
        }
        Assert.assertEquals((Object)1.0, (Object)this.accessor.get((Object)this.feature, "bar", null));
        try {
            this.accessor.set((Object)this.feature, "@id", (Object)"fid2", null);
            Assert.fail((String)"Should have thrown exception trying to set fid");
        }
        catch (IllegalAttributeException illegalAttributeException) {
            // empty catch block
        }
    }

    @Test
    public void testSetType() {
        try {
            this.accessor.set((Object)this.type, "foo", new Object(), null);
            Assert.fail((String)"trying to set attribute type should have thrown exception");
        }
        catch (IllegalAttributeException illegalAttributeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAnyGeometry() throws Exception {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("test");
        tb.setCRS(null);
        tb.add("g1", Point.class);
        tb.add("g2", Point.class);
        tb.setDefaultGeometry("g1");
        SimpleFeatureType type = tb.buildFeatureType();
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(type);
        b.set("g1", null);
        Point p = new GeometryFactory().createPoint(new Coordinate(0.0, 0.0));
        b.set("g2", (Object)p);
        SimpleFeature feature = b.buildFeature(null);
        Assert.assertNull((Object)feature.getDefaultGeometry());
        Assert.assertEquals((Object)p, (Object)SimpleFeaturePropertyAccessorFactory.DEFAULT_GEOMETRY_ACCESS.get((Object)feature, "", Geometry.class));
    }
}

