/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.logging.Logger;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.util.logging.Logging;
import org.junit.Before;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public abstract class FilterTestSupport {
    protected static final Logger LOGGER = Logging.getLogger(FilterTestSupport.class);
    protected static SimpleFeatureType testSchema = null;
    protected static SimpleFeature testFeature = null;
    protected boolean setup = false;

    @Before
    public void setUp() throws SchemaException, IllegalAttributeException {
        if (this.setup) {
            return;
        }
        this.prepareFeatures();
        this.setup = true;
    }

    protected void prepareFeatures() throws SchemaException, IllegalAttributeException {
        LOGGER.finer("creating flat feature...");
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setCRS(null);
        ftb.add("testGeometry", LineString.class);
        ftb.add("testBoolean", Boolean.class);
        ftb.add("testCharacter", Character.class);
        ftb.add("testByte", Byte.class);
        ftb.add("testShort", Short.class);
        ftb.add("testInteger", Integer.class);
        ftb.add("testLong", Long.class);
        ftb.add("testFloat", Float.class);
        ftb.add("testDouble", Double.class);
        ftb.add("testString", String.class);
        ftb.setName("testSchema");
        testSchema = ftb.buildFeatureType();
        GeometryFactory geomFac = new GeometryFactory();
        Coordinate[] coords = new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(3.0, 4.0), new Coordinate(5.0, 6.0)};
        Object[] attributes = new Object[]{geomFac.createLineString(coords), Boolean.TRUE, Character.valueOf('t'), Byte.valueOf("10"), Short.valueOf("101"), 1002, 10003L, Float.valueOf(10000.4f), 100000.5, "test string data"};
        testFeature = SimpleFeatureBuilder.build((SimpleFeatureType)testSchema, (Object[])attributes, null);
        LOGGER.finer("...flat feature created");
    }
}

