/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.easymock.EasyMock;
import org.geotools.filter.ExpressionDOMParser;
import org.geotools.filter.LiteralExpressionImpl;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ExpressionDomParserTest {
    @Test(expected=NullPointerException.class)
    public void nullConstructorInjection() throws Exception {
        new ExpressionDOMParser(null);
    }

    @Test(expected=NullPointerException.class)
    public void nullSetterInjection() {
        ExpressionDOMParser parser = new ExpressionDOMParser();
        Assert.assertNotNull((Object)parser);
        parser.setFilterFactory(null);
    }

    @Test
    public void filterFactoryWithSetterInjectionInvoked() throws Exception {
        ExpressionDOMParser parser = new ExpressionDOMParser();
        Assert.assertNotNull((Object)parser);
        FilterFactory2 filterFactoryMock = (FilterFactory2)EasyMock.createNiceMock(FilterFactory2.class);
        parser.setFilterFactory(filterFactoryMock);
        LiteralExpressionImpl expectedLiteralExpr = new LiteralExpressionImpl(3);
        EasyMock.expect((Object)filterFactoryMock.literal((Object)"3")).andReturn((Object)expectedLiteralExpr);
        EasyMock.replay((Object[])new Object[]{filterFactoryMock});
        Assert.assertEquals((Object)expectedLiteralExpr, (Object)parser.expression(this.getDocumentNode()));
        EasyMock.verify((Object[])new Object[]{filterFactoryMock});
    }

    @Test
    public void filterFactoryWithConstructorInjectionInvoked() throws Exception {
        FilterFactory2 filterFactoryMock = (FilterFactory2)EasyMock.createNiceMock(FilterFactory2.class);
        LiteralExpressionImpl expectedLiteralExpr = new LiteralExpressionImpl(3);
        ExpressionDOMParser parser = new ExpressionDOMParser(filterFactoryMock);
        Assert.assertNotNull((Object)parser);
        EasyMock.expect((Object)filterFactoryMock.literal((Object)"3")).andReturn((Object)expectedLiteralExpr);
        EasyMock.replay((Object[])new Object[]{filterFactoryMock});
        Assert.assertEquals((Object)expectedLiteralExpr, (Object)parser.expression(this.getDocumentNode()));
        EasyMock.verify((Object[])new Object[]{filterFactoryMock});
    }

    @Test
    public void defaultConstructorExpessionWorksAsExpected() throws Exception {
        ExpressionDOMParser parser = new ExpressionDOMParser();
        Assert.assertNotNull((Object)parser);
        Node node = this.getDocumentNode();
        Expression expression = parser.expression(node);
        Assert.assertTrue((boolean)(expression instanceof Literal));
    }

    Node getDocumentNode() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        StringBuilder xmlStringBuilder = new StringBuilder();
        xmlStringBuilder.append("<?xml version=\"1.0\"?> <Literal>3</Literal>");
        ByteArrayInputStream input = new ByteArrayInputStream(xmlStringBuilder.toString().getBytes("UTF-8"));
        return builder.parse(input).getDocumentElement();
    }
}

