/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import java.util.Collections;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.geotools.feature.type.SchemaImpl;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.Schema;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SimpleTypeBuilderTest {
    static final String URI = "gopher://localhost/test";
    SimpleFeatureTypeBuilder builder;

    @Before
    public void setUp() throws Exception {
        SchemaImpl schema = new SchemaImpl("test");
        FeatureTypeFactoryImpl typeFactory = new FeatureTypeFactoryImpl();
        GeometryType pointType = typeFactory.createGeometryType((Name)new NameImpl("test", "pointType"), Point.class, null, false, false, Collections.emptyList(), null, null);
        schema.put((Object)new NameImpl("test", "pointType"), (Object)pointType);
        AttributeType intType = typeFactory.createAttributeType((Name)new NameImpl("test", "intType"), Integer.class, false, false, Collections.emptyList(), null, null);
        schema.put((Object)new NameImpl("test", "intType"), (Object)intType);
        this.builder = new SimpleFeatureTypeBuilder((FeatureTypeFactory)new FeatureTypeFactoryImpl());
        this.builder.setBindings((Schema)schema);
    }

    @Test
    public void testSanity() {
        this.builder.setName("testName");
        this.builder.setNamespaceURI("testNamespaceURI");
        this.builder.add("point", Point.class, (CoordinateReferenceSystem)null);
        this.builder.add("integer", Integer.class);
        SimpleFeatureType type = this.builder.buildFeatureType();
        Assert.assertNotNull((Object)type);
        Assert.assertEquals((long)2L, (long)type.getAttributeCount());
        AttributeType t = type.getType("point");
        Assert.assertNotNull((Object)t);
        Assert.assertEquals(Point.class, (Object)t.getBinding());
        t = type.getType("integer");
        Assert.assertNotNull((Object)t);
        Assert.assertEquals(Integer.class, (Object)t.getBinding());
        t = type.getGeometryDescriptor().getType();
        Assert.assertNotNull((Object)t);
        Assert.assertEquals(Point.class, (Object)t.getBinding());
    }

    @Test
    public void testCRS() {
        this.builder.setName("testName");
        this.builder.setNamespaceURI("testNamespaceURI");
        this.builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.builder.crs(null).add("point", Point.class);
        this.builder.add("point2", Point.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.builder.setDefaultGeometry("point");
        SimpleFeatureType type = this.builder.buildFeatureType();
        Assert.assertEquals((Object)DefaultGeographicCRS.WGS84, (Object)type.getCoordinateReferenceSystem());
        Assert.assertNull((Object)type.getGeometryDescriptor().getType().getCoordinateReferenceSystem());
        Assert.assertEquals((Object)DefaultGeographicCRS.WGS84, (Object)((GeometryType)type.getType("point2")).getCoordinateReferenceSystem());
    }

    @Test
    public void testAttributeDefaultValue() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("buggy");
        builder.nillable(false).defaultValue((Object)12).add("attrWithDefault", Integer.class);
        builder.nillable(true).defaultValue(null).add("attrWithoutDefault", Integer.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        Assert.assertFalse((boolean)featureType.getDescriptor("attrWithDefault").isNillable());
        Assert.assertEquals((Object)12, (Object)featureType.getDescriptor("attrWithDefault").getDefaultValue());
        Assert.assertTrue((boolean)featureType.getDescriptor("attrWithoutDefault").isNillable());
        Assert.assertNull((Object)featureType.getDescriptor("attrWithoutDefault").getDefaultValue());
    }

    @Test
    public void testMaintainDefaultGeometryOnRetype() {
        this.builder.setName("testGeometries");
        this.builder.add("geo1", Point.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.builder.add("geo2", Polygon.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.builder.setDefaultGeometry("geo1");
        SimpleFeatureType type = this.builder.buildFeatureType();
        SimpleFeatureType retyped = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)type, (String[])new String[]{"geo2", "geo1"});
        Assert.assertEquals((Object)"geo1", (Object)retyped.getGeometryDescriptor().getLocalName());
    }

    @Test
    public void testRetypeGeometryless() {
        this.builder.setName("testGeometryless");
        this.builder.add("geo1", Point.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.builder.add("integer", Integer.class);
        this.builder.setDefaultGeometry("geo1");
        SimpleFeatureType type = this.builder.buildFeatureType();
        SimpleFeatureType retyped = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)type, (String[])new String[]{"integer"});
        Assert.assertNotNull((Object)retyped);
        Assert.assertNull((Object)retyped.getGeometryDescriptor());
        Assert.assertEquals((long)1L, (long)retyped.getAttributeCount());
        Assert.assertEquals((Object)"integer", (Object)((AttributeDescriptor)retyped.getAttributeDescriptors().get(0)).getLocalName());
    }

    @Test
    public void testInitGeometryless() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("testGeometryless");
        builder.add("integer", Integer.class);
        SimpleFeatureType type1 = builder.buildFeatureType();
        builder = new SimpleFeatureTypeBuilder();
        builder.init(type1);
        SimpleFeatureType type2 = builder.buildFeatureType();
        Assert.assertEquals((Object)type1, (Object)type2);
    }

    @Test
    public void testMaintainDefaultGeometryOnInit() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("testGeometries");
        builder.add("geo1", Point.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.add("geo2", Polygon.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.setDefaultGeometry("geo2");
        SimpleFeatureType type1 = builder.buildFeatureType();
        builder = new SimpleFeatureTypeBuilder();
        builder.init(type1);
        SimpleFeatureType type2 = builder.buildFeatureType();
        Assert.assertEquals((Object)"geo2", (Object)type1.getGeometryDescriptor().getLocalName());
        Assert.assertEquals((Object)"geo2", (Object)type2.getGeometryDescriptor().getLocalName());
    }

    @Test
    public void testRemoveDefaultGeometryAfterInit() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("testGeometries");
        builder.add("geo1", Point.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.add("geo2", Polygon.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.setDefaultGeometry("geo2");
        SimpleFeatureType type1 = builder.buildFeatureType();
        builder = new SimpleFeatureTypeBuilder();
        builder.init(type1);
        builder.remove("geo2");
        SimpleFeatureType type2 = builder.buildFeatureType();
        Assert.assertEquals((Object)"geo2", (Object)type1.getGeometryDescriptor().getLocalName());
        Assert.assertEquals((Object)"geo1", (Object)type2.getGeometryDescriptor().getLocalName());
    }
}

