/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import org.geotools.data.DataUtilities;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;

public class SimpleFeatureImplTest {
    SimpleFeatureType schema;
    SimpleFeature feature;
    WKTReader wkt;

    @Before
    public void setUp() throws Exception {
        this.schema = DataUtilities.createType((String)"buildings", (String)"the_geom:Geometry,name:String,ADDRESS:String");
        this.feature = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])new Object[]{null, "ABC", "Random Road, 12"}, (String)"building.1");
        this.wkt = new WKTReader();
    }

    @Test
    public void testGetProperty() {
        Assert.assertEquals((Object)"ABC", (Object)this.feature.getProperty("name").getValue());
        Assert.assertNull((Object)this.feature.getProperty("NOWHERE"));
        Assert.assertEquals((long)0L, (long)this.feature.getProperties("NOWHERE").size());
    }

    @Test
    public void testGetPropertyNullValue() {
        Assert.assertNotNull((Object)this.feature.getProperty("the_geom"));
        Assert.assertNull((Object)this.feature.getProperty("the_geom").getValue());
    }

    @Test
    public void testGeometryPropertyType() {
        Assert.assertTrue((String)("expected GeometryAttribute, got " + this.feature.getProperty("the_geom").getClass().getName()), (boolean)(this.feature.getProperty("the_geom") instanceof GeometryAttribute));
    }

    @Test
    public void testDefaultGeometryProperty() {
        Assert.assertTrue((String)("expected GeometryAttribute, got " + this.feature.getProperty("the_geom").getClass().getName()), (boolean)(this.feature.getProperty("the_geom") instanceof GeometryAttribute));
        GeometryAttribute defaultGeometryProperty = this.feature.getDefaultGeometryProperty();
        Assert.assertNotNull((Object)defaultGeometryProperty);
        Assert.assertNull((Object)defaultGeometryProperty.getValue());
        Assert.assertNotNull((Object)defaultGeometryProperty.getDescriptor());
        Assert.assertTrue((boolean)(defaultGeometryProperty.getDescriptor() instanceof GeometryDescriptor));
    }

    @Test
    public void testGetName() {
        Assert.assertNotNull((Object)this.feature.getName());
        Assert.assertEquals((Object)this.feature.getFeatureType().getName(), (Object)this.feature.getName());
    }

    @Test
    public void testGetDescriptor() {
        Assert.assertNotNull((Object)this.feature.getDescriptor());
        Assert.assertSame((Object)this.feature.getType(), (Object)this.feature.getDescriptor().getType());
        Assert.assertTrue((boolean)this.feature.getDescriptor().isNillable());
        Assert.assertEquals((long)0L, (long)this.feature.getDescriptor().getMinOccurs());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)this.feature.getDescriptor().getMaxOccurs());
    }

    @Test
    public void testSetValue() {
        SimpleFeature myFeature = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])new Object[]{null, null, null}, (String)"building.2");
        myFeature.setValue(this.feature.getProperties());
        for (int i = 0; i < this.feature.getAttributeCount(); ++i) {
            Assert.assertEquals((Object)this.feature.getAttribute(i), (Object)myFeature.getAttribute(i));
        }
    }

    @Test
    public void testCompare2D() throws ParseException {
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])new Object[]{this.wkt.read("POINT(1 2)"), "ABC", "Random Road, 12"}, (String)"building.1");
        SimpleFeature f2 = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])new Object[]{this.wkt.read("POINT(1 2)"), "ABC", "Random Road, 12"}, (String)"building.1");
        SimpleFeature f3 = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])new Object[]{this.wkt.read("POINT(3 4)"), "ABC", "Random Road, 12"}, (String)"building.1");
        Assert.assertEquals((Object)f1, (Object)f2);
        Assert.assertNotEquals((Object)f1, (Object)f3);
    }

    @Test
    public void testCompare3D() throws ParseException {
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])new Object[]{this.wkt.read("POINT(1 2)"), "ABC", "Random Road, 12"}, (String)"building.1");
        SimpleFeature f2 = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])new Object[]{this.wkt.read("POINT(1 2 15)"), "ABC", "Random Road, 12"}, (String)"building.1");
        SimpleFeature f3 = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])new Object[]{this.wkt.read("POINT(1 2 18)"), "ABC", "Random Road, 12"}, (String)"building.1");
        SimpleFeature f4 = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])new Object[]{this.wkt.read("POINT(1 2 18)"), "ABC", "Random Road, 12"}, (String)"building.1");
        Assert.assertNotEquals((Object)f1, (Object)f2);
        Assert.assertNotEquals((Object)f1, (Object)f3);
        Assert.assertNotEquals((Object)f2, (Object)f3);
        Assert.assertEquals((Object)f3, (Object)f4);
    }

    @Test
    public void testUserMetadata() throws ParseException {
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])new Object[]{this.wkt.read("POINT(1 2)"), "ABC", "Random Road, 12"}, (String)"building.1");
        Assert.assertFalse((boolean)feature.hasUserData());
        Assert.assertNotNull((Object)feature.getUserData());
        Assert.assertFalse((boolean)feature.hasUserData());
        feature.getUserData().put("a", "b");
        Assert.assertTrue((boolean)feature.hasUserData());
    }
}

