/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import java.util.Arrays;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SimpleFeatureBuilderTest {
    SimpleFeatureBuilder builder;

    @Before
    public void setUp() throws Exception {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("test");
        typeBuilder.add("point", Point.class, (CoordinateReferenceSystem)null);
        typeBuilder.add("integer", Integer.class);
        typeBuilder.add("float", Float.class);
        SimpleFeatureType featureType = typeBuilder.buildFeatureType();
        this.builder = new SimpleFeatureBuilder(featureType);
        this.builder.setValidating(true);
    }

    @Test
    public void testSanity() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        this.builder.add((Object)gf.createPoint(new Coordinate(0.0, 0.0)));
        this.builder.add((Object)1);
        this.builder.add((Object)Float.valueOf(2.0f));
        SimpleFeature feature = this.builder.buildFeature("fid");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((long)3L, (long)feature.getAttributeCount());
        Assert.assertEquals((Object)gf.createPoint(new Coordinate(0.0, 0.0)), (Object)feature.getAttribute("point"));
        Assert.assertEquals((Object)1, (Object)feature.getAttribute("integer"));
        Assert.assertEquals((Object)Float.valueOf(2.0f), (Object)feature.getAttribute("float"));
    }

    @Test
    public void testTooFewAttributes() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        this.builder.add((Object)gf.createPoint(new Coordinate(0.0, 0.0)));
        this.builder.add((Object)1);
        SimpleFeature feature = this.builder.buildFeature("fid");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((long)3L, (long)feature.getAttributeCount());
        Assert.assertEquals((Object)gf.createPoint(new Coordinate(0.0, 0.0)), (Object)feature.getAttribute("point"));
        Assert.assertEquals((Object)1, (Object)feature.getAttribute("integer"));
        Assert.assertNull((Object)feature.getAttribute("float"));
    }

    @Test
    public void testSetSequential() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        this.builder.set("point", (Object)gf.createPoint(new Coordinate(0.0, 0.0)));
        this.builder.set("integer", (Object)1);
        this.builder.set("float", (Object)Float.valueOf(2.0f));
        SimpleFeature feature = this.builder.buildFeature("fid");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((long)3L, (long)feature.getAttributeCount());
        Assert.assertEquals((Object)gf.createPoint(new Coordinate(0.0, 0.0)), (Object)feature.getAttribute(0));
        Assert.assertEquals((Object)1, (Object)feature.getAttribute(1));
        Assert.assertEquals((Object)Float.valueOf(2.0f), (Object)feature.getAttribute(2));
    }

    @Test
    public void testSetNonSequential() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        this.builder.set("float", (Object)Float.valueOf(2.0f));
        this.builder.set("point", (Object)gf.createPoint(new Coordinate(0.0, 0.0)));
        this.builder.set("integer", (Object)1);
        SimpleFeature feature = this.builder.buildFeature("fid");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((long)3L, (long)feature.getAttributeCount());
        Assert.assertEquals((Object)gf.createPoint(new Coordinate(0.0, 0.0)), (Object)feature.getAttribute(0));
        Assert.assertEquals((Object)1, (Object)feature.getAttribute(1));
        Assert.assertEquals((Object)Float.valueOf(2.0f), (Object)feature.getAttribute(2));
    }

    @Test
    public void testSetTooFew() throws Exception {
        this.builder.set("integer", (Object)1);
        SimpleFeature feature = this.builder.buildFeature("fid");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((long)3L, (long)feature.getAttributeCount());
        Assert.assertNull((Object)feature.getAttribute(0));
        Assert.assertEquals((Object)1, (Object)feature.getAttribute(1));
        Assert.assertNull((Object)feature.getAttribute(2));
    }

    @Test
    public void testConverting() throws Exception {
        this.builder.set("integer", (Object)"1");
        this.builder.buildFeature("fid");
        try {
            this.builder.set("integer", (Object)"foo");
            Assert.fail((String)"should have failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCreateFeatureWithLength() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("test");
        builder.length(5).add("name", String.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"Val"}, (String)"ID");
        Assert.assertNotNull((Object)feature);
        try {
            feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"Longer Than 5"}, (String)"ID");
            feature.validate();
            Assert.fail((String)"this should fail because the value is longer than 5 characters");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCreateFeatureWithRestriction() throws Exception {
        FilterFactory fac = CommonFactoryFinder.getFilterFactory(null);
        String attributeName = "string";
        PropertyIsEqualTo filter = fac.equals((Expression)fac.property("."), (Expression)fac.literal((Object)"Value"));
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("test");
        builder.restriction((Filter)filter).add(attributeName, String.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"Value"}, (String)"ID");
        Assert.assertNotNull((Object)feature);
        try {
            SimpleFeature sf = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"NotValue"}, (String)"ID");
            sf.validate();
            Assert.fail((String)"PropertyIsEqualTo filter should have failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCreateFeatureWithOptions() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("test");
        builder.options(new Object[]{"a", "b", "c"}).add("name", String.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"a"}, (String)"ID");
        Assert.assertNotNull((Object)feature);
        feature.validate();
        try {
            feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"d"}, (String)"ID");
            feature.validate();
            Assert.fail((String)"this should fail because the value is not either a, b or c, but d");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCreateFeatureWithOptionsOnAttributeTypeBuilder() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("test");
        AttributeTypeBuilder atb = new AttributeTypeBuilder();
        atb.name("name").binding(String.class).options(Arrays.asList("a", "b", "c"));
        builder.add(atb.buildDescriptor("name"));
        SimpleFeatureType featureType = builder.buildFeatureType();
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"a"}, (String)"ID");
        Assert.assertNotNull((Object)feature);
        feature.validate();
        try {
            feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"d"}, (String)"ID");
            feature.validate();
            Assert.fail((String)"this should fail because the value is not either a, b or c, but d");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testUserData() throws Exception {
        SimpleFeature feature = this.buildUserDataFeature();
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)"bar", feature.getUserData().get("foo"));
        this.builder = new SimpleFeatureBuilder(feature.getFeatureType());
        this.builder.init(feature);
        feature = this.builder.buildFeature("fid");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)"bar", feature.getUserData().get("foo"));
    }

    private SimpleFeature buildUserDataFeature() {
        GeometryFactory gf = new GeometryFactory();
        this.builder.add((Object)gf.createPoint(new Coordinate(0.0, 0.0)));
        this.builder.add((Object)1);
        this.builder.add((Object)Float.valueOf(2.0f));
        this.builder.featureUserData((Object)"foo", (Object)"bar");
        return this.builder.buildFeature("fid");
    }

    @Test
    public void testCopyUserData() throws Exception {
        SimpleFeature template = this.buildUserDataFeature();
        this.builder = new SimpleFeatureBuilder(template.getFeatureType());
        GeometryFactory gf = new GeometryFactory();
        this.builder.add((Object)gf.createPoint(new Coordinate(1.0, 1.0)));
        this.builder.add((Object)2);
        this.builder.add((Object)Float.valueOf(4.0f));
        this.builder.featureUserData(template);
        SimpleFeature feature = this.builder.buildFeature("myfid");
        Assert.assertEquals((Object)"bar", feature.getUserData().get("foo"));
    }
}

