/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.ArrayList;
import org.geotools.ExceptionChecker;
import org.geotools.feature.AttributeBuilder;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.ComplexFeatureBuilder;
import org.geotools.feature.FakeTypes;
import org.geotools.feature.LenientFeatureFactoryImpl;
import org.geotools.feature.NameImpl;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.Property;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Name;

public class ComplexFeatureBuilderTest {
    private static ComplexAttribute getAMineNameProperty(String name, boolean isPreferred) {
        AttributeBuilder builder = new AttributeBuilder((FeatureFactory)new LenientFeatureFactoryImpl());
        builder.setType((AttributeType)FakeTypes.Mine.MINENAMETYPE_TYPE);
        builder.add("isPreferred_testId", (Object)isPreferred, FakeTypes.Mine.NAME_isPreferred);
        builder.add("mineName_testId", (Object)name, FakeTypes.Mine.NAME_mineName);
        Attribute mineName = builder.build();
        ArrayList<Attribute> mineNames = new ArrayList<Attribute>();
        mineNames.add(mineName);
        builder.init();
        builder.setType((AttributeType)FakeTypes.Mine.MINENAMEPROPERTYTYPE_TYPE);
        builder.add("MineName_testId", mineNames, FakeTypes.Mine.NAME_MineName);
        return (ComplexAttribute)builder.build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void append_invalidName_throwsIllegalArgumentException() throws Exception {
        ComplexFeatureBuilder builder = new ComplexFeatureBuilder(FakeTypes.Mine.MINETYPE_TYPE);
        try {
            builder.append((Name)new NameImpl("invalid_descriptor_name"), null);
        }
        catch (IllegalArgumentException iae) {
            ExceptionChecker.assertExceptionMessage(iae, "The name 'invalid_descriptor_name' is not a valid descriptor name for the type 'urn:org:example:MineType'.");
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void append_validNameInvalidValueClass_throwsIllegalArgumentException() throws Exception {
        ComplexFeatureBuilder builder = new ComplexFeatureBuilder(FakeTypes.Mine.MINETYPE_TYPE);
        try {
            builder.append(FakeTypes.Mine.NAME_mineName, (Property)new AttributeImpl((Object)"Test", FakeTypes.ANYSIMPLETYPE_TYPE, null));
        }
        catch (IllegalArgumentException iae) {
            ExceptionChecker.assertExceptionMessage(iae, "The value provided contains an object of 'class java.lang.Object' but the method expects an object of 'interface java.util.Collection'.");
        }
    }

    @Test
    public void append_validNameValidValue_valueShouldBeAddedToTheMap() {
        ComplexFeatureBuilder builder = new ComplexFeatureBuilder(FakeTypes.Mine.MINETYPE_TYPE);
        ComplexAttribute mineNameProperty = ComplexFeatureBuilderTest.getAMineNameProperty("mine 1", true);
        builder.append(FakeTypes.Mine.NAME_mineName, (Property)mineNameProperty);
        Object actualValue = ((ArrayList)builder.values.get(FakeTypes.Mine.NAME_mineName)).get(0);
        Assert.assertSame((Object)mineNameProperty, actualValue);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void append_exceedMaxOccursLimit_throwsIndexOutOfBoundsException() throws Exception {
        ComplexFeatureBuilder builder = new ComplexFeatureBuilder(FakeTypes.Mine.MINETYPE_TYPE);
        builder.append(FakeTypes.Mine.NAME_mineName, (Property)ComplexFeatureBuilderTest.getAMineNameProperty("mine 1", true));
        builder.append(FakeTypes.Mine.NAME_mineName, (Property)ComplexFeatureBuilderTest.getAMineNameProperty("mine 2", false));
        builder.append(FakeTypes.Mine.NAME_mineName, (Property)ComplexFeatureBuilderTest.getAMineNameProperty("mine 3", false));
        try {
            builder.append(FakeTypes.Mine.NAME_mineName, (Property)ComplexFeatureBuilderTest.getAMineNameProperty("mine 4", false));
        }
        catch (IndexOutOfBoundsException ioobe) {
            ExceptionChecker.assertExceptionMessage(ioobe, "You can't add another object with the name of 'urn:org:example:mineName' because you already have the maximum number (3) allowed by the property descriptor.");
        }
    }

    @Test(expected=IllegalStateException.class)
    public void buildFeature_noLocationSet_throwsIllegalStateException() throws Exception {
        ComplexFeatureBuilder builder = new ComplexFeatureBuilder(FakeTypes.Mine.MINETYPE_TYPE);
        try {
            builder.buildFeature("id");
        }
        catch (IllegalStateException ise) {
            ExceptionChecker.assertExceptionMessage(ise, "Failed to build feature 'urn:org:example:MineType'; its property 'urn:org:example:mineName' requires at least 1 occurrence(s) but number of occurrences was 0.");
        }
    }

    @Test
    public void build_typeIsMineTypeAndAddedDataIsValid_buildsFeature() {
        ComplexAttribute mineNameProperty = ComplexFeatureBuilderTest.getAMineNameProperty("Sharlston Colliery", true);
        ComplexFeatureBuilder complexFeatureBuilder = new ComplexFeatureBuilder(FakeTypes.Mine.MINETYPE_TYPE);
        complexFeatureBuilder.append(FakeTypes.Mine.NAME_mineName, (Property)mineNameProperty);
        Feature mine = complexFeatureBuilder.buildFeature("er.mine.S0000001");
        Assert.assertEquals((Object)"FeatureImpl:MineType<MineType id=er.mine.S0000001>=[ComplexAttributeImpl:MineNamePropertyType=[ComplexAttributeImpl:MineName<MineNameType id=MineName_testId>=[ComplexAttributeImpl:MineNameType=[AttributeImpl:isPreferred<boolean id=isPreferred_testId>=true, AttributeImpl:mineName<string id=mineName_testId>=Sharlston Colliery]]]]", (Object)mine.toString());
    }
}

