/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.util.Set;
import org.geotools.data.util.CRSConverterFactory;
import org.geotools.data.util.ReferencedEnvelopeConverterFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ReferencedEnvelopeConverterFactoryTest {
    ReferencedEnvelopeConverterFactory factory;

    @Before
    public void setUp() throws Exception {
        this.factory = new ReferencedEnvelopeConverterFactory();
    }

    @Test
    public void testReferencedEnvelopeToString() throws Exception {
        String text = (String)this.factory.createConverter(ReferencedEnvelope.class, String.class, null).convert((Object)new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), String.class);
        Assert.assertNotNull((Object)text);
        Assert.assertEquals((Object)("[-180.0 : 180.0, -90.0 : 90.0] {" + DefaultGeographicCRS.WGS84.toWKT() + "}"), (Object)text);
    }

    @Test
    public void testStringToReferencedEnvelope() throws Exception {
        Envelope envelope = (Envelope)this.factory.createConverter(String.class, ReferencedEnvelope.class, null).convert((Object)("[-180.0 : 180.0, -90.0 : 90.0] {" + DefaultGeographicCRS.WGS84.toWKT() + "}"), ReferencedEnvelope.class);
        Assert.assertEquals((Object)new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), (Object)envelope);
    }

    @Test
    public void testReferencedEnvelopeConverterFactory() {
        Set set = Converters.getConverterFactories(String.class, ReferencedEnvelope.class);
        Assert.assertNotNull((Object)set);
        Assert.assertFalse((boolean)set.isEmpty());
        Assert.assertEquals((long)set.size(), (long)1L);
        Assert.assertSame(((ConverterFactory)set.iterator().next()).getClass(), ReferencedEnvelopeConverterFactory.class);
        Set set1 = Converters.getConverterFactories(ReferencedEnvelope.class, String.class);
        Assert.assertNotNull((Object)set1);
        Assert.assertFalse((boolean)set1.isEmpty());
        Assert.assertEquals((long)set1.size(), (long)1L);
        Assert.assertSame(((ConverterFactory)set1.iterator().next()).getClass(), ReferencedEnvelopeConverterFactory.class);
        Assert.assertNull((Object)new CRSConverterFactory().createConverter(null, null, null));
        Assert.assertNull((Object)new CRSConverterFactory().createConverter(String.class, null, null));
        Assert.assertNull((Object)new CRSConverterFactory().createConverter(String.class, Double.class, null));
    }
}

