/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.awt.Color;
import java.awt.RenderingHints;
import org.geotools.data.util.ColorConverterFactory;
import org.geotools.filter.ConstantExpression;
import org.geotools.util.Converter;
import org.geotools.util.Converters;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ColorConverterFactoryTest {
    private static final Color THISTLE = new Color(216, 191, 216);
    private static final Color LEMON_CHIFFON = new Color(255, 250, 205);
    private static final Color ALICE_BLUE = new Color(240, 248, 255);
    private static final Color GRAY_TRANSPARENT = new Color(128, 128, 128, 128);
    private static final Color GRAY = new Color(128, 128, 128);
    ColorConverterFactory factory;

    @Before
    public void setUp() throws Exception {
        this.factory = new ColorConverterFactory();
    }

    @Test
    public void testVsConstantExpression() throws Exception {
        ConstantExpression expr = ConstantExpression.color((Color)Color.RED);
        String expected = (String)expr.evaluate(null, String.class);
        Converter converter = this.factory.createConverter(Color.class, String.class, null);
        String actual = (String)converter.convert((Object)Color.RED, String.class);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testFromString() throws Exception {
        Assert.assertEquals((Object)Color.RED, (Object)this.convert("#FF0000"));
    }

    @Test
    public void testFromInteger() throws Exception {
        Assert.assertEquals((Object)Color.RED, (Object)this.convert(0xFF0000));
        Assert.assertEquals((String)"no alpha", (Object)new Color(0, 0, 255, 255), (Object)this.convert(255));
        Assert.assertEquals((String)"255 alpha", (Object)new Color(0, 0, 255, 255), (Object)this.convert(-16776961));
        Assert.assertEquals((String)"1 alpha", (Object)new Color(0, 0, 255, 1), (Object)this.convert(0x10000FF));
    }

    @Test
    public void testFromLong() throws Exception {
        Assert.assertEquals((Object)Color.RED, (Object)this.convert(0xFF0000));
        Assert.assertEquals((String)"no alpha", (Object)new Color(0, 0, 255, 255), (Object)this.convert(255L));
        Assert.assertEquals((String)"255 alpha", (Object)new Color(0, 0, 255, 255), (Object)this.convert(-16776961L));
        Assert.assertEquals((String)"1 alpha", (Object)new Color(0, 0, 255, 1), (Object)this.convert(0x10000FFL));
    }

    @Test
    public void testToCSS() throws Exception {
        Converter converter = this.factory.createConverter(Color.class, String.class, new Hints((RenderingHints.Key)Hints.COLOR_DEFINITION, (Object)"CSS"));
        Assert.assertEquals((String)"aliceblue", (Object)"aliceblue", (Object)converter.convert((Object)ALICE_BLUE, String.class));
        Assert.assertEquals((String)"gray", (Object)"gray", (Object)converter.convert((Object)GRAY, String.class));
        Assert.assertEquals((String)"pale blue", (Object)"rgb(33,66,255)", (Object)converter.convert((Object)new Color(33, 66, 255), String.class));
        Assert.assertEquals((String)"gray transparent", (Object)"rgba(128,128,128,0.5)", (Object)converter.convert((Object)GRAY_TRANSPARENT, String.class));
        Assert.assertEquals((String)"blueish", (Object)"rgba(33,66,255,0.992)", (Object)converter.convert((Object)new Color(33, 66, 255, 254), String.class));
    }

    @Test
    public void testFromCss() throws Exception {
        Converter converter = this.factory.createConverter(String.class, Color.class, new Hints((RenderingHints.Key)Hints.COLOR_DEFINITION, (Object)"CSS"));
        Assert.assertEquals((String)"aliceblue", (Object)ALICE_BLUE, (Object)converter.convert((Object)"aliceblue", Color.class));
        Assert.assertEquals((String)"AliceBlue", (Object)ALICE_BLUE, (Object)converter.convert((Object)"AliceBlue", Color.class));
        Assert.assertEquals((String)"gray", (Object)GRAY, (Object)converter.convert((Object)"gray", Color.class));
        Assert.assertEquals((String)"lemonchiffon", (Object)LEMON_CHIFFON, (Object)converter.convert((Object)"lemonchiffon", Color.class));
        Assert.assertEquals((String)"WHITE", (Object)Color.WHITE, (Object)converter.convert((Object)"WHITE", Color.class));
        Assert.assertEquals((String)"black", (Object)Color.BLACK, (Object)converter.convert((Object)"black", Color.class));
        Assert.assertEquals((String)"thistle", (Object)THISTLE, (Object)converter.convert((Object)"thistle", Color.class));
        Assert.assertEquals((String)"hex", (Object)GRAY, (Object)converter.convert((Object)"#808080", Color.class));
        Assert.assertEquals((String)"hex alpha", (Object)GRAY_TRANSPARENT, (Object)converter.convert((Object)"#80808080", Color.class));
        Assert.assertEquals((String)"rgb", (Object)GRAY, (Object)converter.convert((Object)"rgb(128,128,128)", Color.class));
        Assert.assertEquals((String)"rgba", (Object)GRAY_TRANSPARENT, (Object)converter.convert((Object)"rgba(128,128,128, 0.5)", Color.class));
        Assert.assertEquals((String)"rgba", (Object)GRAY, (Object)converter.convert((Object)"rgba(128,128,128, 1)", Color.class));
        Assert.assertEquals((String)"rgba", (Object)new Color(33, 66, 255, 254), (Object)converter.convert((Object)"rgba(33,66,255,0.99607843)", Color.class));
    }

    @Test
    public void testAlpha() throws Exception {
        Converter converter = this.factory.createConverter(String.class, Color.class, null);
        Assert.assertEquals((String)"hex", (Object)GRAY, (Object)converter.convert((Object)"#808080", Color.class));
        Assert.assertNull((String)"hex alpha", (Object)converter.convert((Object)"#80808080", Color.class));
    }

    Color convert(Object value) throws Exception {
        Converter converter = this.factory.createConverter(value.getClass(), Color.class, null);
        return (Color)converter.convert(value, Color.class);
    }

    @Test
    public void testRegisteredWithConverters() {
        Color color = (Color)Converters.convert((Object)"#189E77", Color.class);
        Color expected = new Color(24, 158, 119);
        Assert.assertNotNull((String)"converter not registered", (Object)color);
        Assert.assertEquals((Object)expected, (Object)color);
    }

    @Test
    public void testCompactColor() {
        Color color = (Color)Converters.convert((Object)"#aaa", Color.class);
        Assert.assertEquals((long)170L, (long)color.getRed());
        Assert.assertEquals((long)170L, (long)color.getGreen());
        Assert.assertEquals((long)170L, (long)color.getBlue());
    }

    @Test
    public void testHsl() throws Exception {
        Converter converter = this.factory.createConverter(String.class, Color.class, new Hints((RenderingHints.Key)Hints.COLOR_DEFINITION, (Object)"CSS"));
        Assert.assertEquals((Object)Color.BLACK, (Object)converter.convert((Object)"hsl(0, 0, 0)", Color.class));
        Assert.assertEquals((Object)Color.WHITE, (Object)converter.convert((Object)"hsl(0, 0, 100%)", Color.class));
        Assert.assertEquals((Object)Color.RED, (Object)converter.convert((Object)"hsl(0, 100%, 50%)", Color.class));
        Assert.assertEquals((Object)Color.GREEN, (Object)converter.convert((Object)"hsl(120, 100%, 50%)", Color.class));
    }

    @Test
    public void testHsla() throws Exception {
        Converter converter = this.factory.createConverter(String.class, Color.class, new Hints((RenderingHints.Key)Hints.COLOR_DEFINITION, (Object)"CSS"));
        Assert.assertEquals((Object)Color.BLACK, (Object)converter.convert((Object)"hsla(0, 0%, 0%, 1)", Color.class));
        Assert.assertEquals((Object)new Color(255, 255, 255, 128), (Object)converter.convert((Object)"hsla(0, 0%, 100%, 0.5)", Color.class));
    }
}

