/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import org.easymock.EasyMock;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.FeatureCollectionWrapperTestSupport;
import org.geotools.data.store.ReprojectingFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;

public class ReprojectingFeatureCollectionTest
extends FeatureCollectionWrapperTestSupport {
    CoordinateReferenceSystem target;
    GeometryCoordinateSequenceTransformer transformer;
    FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.target = CRS.decode((String)"EPSG:3005");
        MathTransform2D tx = (MathTransform2D)ReferencingFactoryFinder.getCoordinateOperationFactory(null).createOperation(this.crs, this.target).getMathTransform();
        this.transformer = new GeometryCoordinateSequenceTransformer();
        this.transformer.setMathTransform((MathTransform)tx);
    }

    @Test
    public void testNormal() throws Exception {
        try (SimpleFeatureIterator reproject = new ReprojectingFeatureCollection((SimpleFeatureCollection)this.delegate, this.target).features();
             SimpleFeatureIterator reader = this.delegate.features();){
            while (reader.hasNext()) {
                SimpleFeature normal = (SimpleFeature)reader.next();
                SimpleFeature reprojected = (SimpleFeature)reproject.next();
                Point p1 = (Point)normal.getAttribute("defaultGeom");
                Point p2 = (Point)reprojected.getAttribute("defaultGeom");
                if (p1 != null) {
                    p1 = (Point)this.transformer.transform((Geometry)p1);
                    Assert.assertTrue((boolean)p1.equalsExact((Geometry)p2));
                } else {
                    Assert.assertNull((Object)p2);
                }
                LineString l1 = (LineString)normal.getAttribute("otherGeom");
                LineString l2 = (LineString)reprojected.getAttribute("otherGeom");
                if (l1 != null) {
                    l1 = (LineString)this.transformer.transform((Geometry)l1);
                    Assert.assertTrue((boolean)l1.equalsExact((Geometry)l2));
                    continue;
                }
                Assert.assertNull((Object)l2);
            }
        }
    }

    @Test
    public void testBounds() throws Exception {
        ReprojectingFeatureCollection rfc = new ReprojectingFeatureCollection((SimpleFeatureCollection)this.delegate, this.target);
        ReferencedEnvelope bounds = this.delegate.getBounds();
        Assert.assertTrue((boolean)bounds.transform(this.target, true).contains((BoundingBox)rfc.getBounds()));
        Assert.assertEquals((Object)this.target, (Object)rfc.getBounds().getCoordinateReferenceSystem());
    }

    @Test
    public void testFilter() throws Exception {
        ReprojectingFeatureCollection rfc = new ReprojectingFeatureCollection((SimpleFeatureCollection)this.delegate, this.target);
        ReferencedEnvelope bounds = this.delegate.getBounds();
        ReferencedEnvelope rbounds = bounds.transform(this.target, true);
        BBOX filter = this.ff.bbox("", bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY(), CRS.toSRS((CoordinateReferenceSystem)this.delegate.getSchema().getCoordinateReferenceSystem()));
        BBOX rfilter = this.ff.bbox("", rbounds.getMinX(), rbounds.getMinY(), rbounds.getMaxX(), rbounds.getMaxY(), CRS.toSRS((CoordinateReferenceSystem)this.target));
        Assert.assertEquals((long)this.delegate.subCollection((Filter)filter).size(), (long)rfc.subCollection((Filter)rfilter).size());
    }

    @Test
    public void testLenient() throws Exception {
        CoordinateReferenceSystem lenientTarget = CRS.parseWKT((String)"PROJCS[\"MGI (Ferro) / Austria GK West Zone\",GEOGCS[\"MGI (Ferro)\",DATUM[\"Militar_Geographische_Institut_Ferro\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6805\"]],PRIMEM[\"Ferro\",-17.66666666666667,AUTHORITY[\"EPSG\",\"8909\"]],UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4805\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\",28],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",-5000000],AUTHORITY[\"EPSG\",\"31251\"],AXIS[\"Y\",EAST],AXIS[\"X\",NORTH]]");
        SimpleFeatureIterator reproject = new ReprojectingFeatureCollection((SimpleFeatureCollection)this.delegate, lenientTarget).features();
        reproject.close();
    }

    @Test
    public void testDelegateAccepts() throws Exception {
        SimpleFeatureTypeBuilder stb = new SimpleFeatureTypeBuilder();
        stb.setName("test");
        stb.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        stb.add("geo", Geometry.class);
        stb.add("bar", Integer.class);
        SimpleFeatureType ft = stb.buildFeatureType();
        UniqueVisitor vis = new UniqueVisitor(new String[]{"bar"});
        SimpleFeatureCollection delegate = (SimpleFeatureCollection)EasyMock.createMock(SimpleFeatureCollection.class);
        EasyMock.expect((Object)((SimpleFeatureType)delegate.getSchema())).andReturn((Object)ft).anyTimes();
        delegate.accepts((FeatureVisitor)vis, null);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{delegate});
        ReprojectingFeatureCollection rfc = new ReprojectingFeatureCollection(delegate, this.target);
        rfc.accepts((FeatureVisitor)vis, null);
        EasyMock.verify((Object[])new Object[]{delegate});
        vis = new UniqueVisitor(new String[]{"geo"});
        SimpleFeatureIterator it = (SimpleFeatureIterator)EasyMock.createNiceMock(SimpleFeatureIterator.class);
        EasyMock.replay((Object[])new Object[]{it});
        delegate = (SimpleFeatureCollection)EasyMock.createMock(SimpleFeatureCollection.class);
        EasyMock.expect((Object)delegate.features()).andReturn((Object)it).once();
        EasyMock.expect((Object)((SimpleFeatureType)delegate.getSchema())).andReturn((Object)ft).anyTimes();
        EasyMock.replay((Object[])new Object[]{delegate});
        rfc = new ReprojectingFeatureCollection(delegate, this.target);
        rfc.accepts((FeatureVisitor)vis, null);
        EasyMock.verify((Object[])new Object[]{delegate});
    }

    @Test
    public void testPreserveUserData() {
        ReprojectingFeatureCollection reproject = new ReprojectingFeatureCollection((SimpleFeatureCollection)this.delegate, this.target);
        SimpleFeature first = (SimpleFeature)DataUtilities.first((FeatureCollection)reproject);
        Assert.assertEquals((Object)"test_value", first.getUserData().get("test_key"));
    }
}

