/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.util.ArrayList;
import java.util.List;
import org.geotools.data.BatchFeatureEvent;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.AbstractContentTest;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;

public class ContentFeatureSourceEventsTest
extends AbstractContentTest {
    private DefaultTransaction defaultTransaction;
    private DefaultTransaction anotherTransaction;

    @Before
    public void setUp() {
        this.defaultTransaction = new DefaultTransaction();
        this.anotherTransaction = new DefaultTransaction();
    }

    @After
    public void tearDown() {
        this.defaultTransaction.close();
        this.anotherTransaction.close();
    }

    @Test
    public void testFeatureEventsAutoCommit() throws Exception {
        AbstractContentTest.MockContentDataStore store = new AbstractContentTest.MockContentDataStore(this);
        SimpleFeatureStore store1 = (SimpleFeatureStore)store.getFeatureSource(TYPENAME);
        SimpleFeatureStore store2 = (SimpleFeatureStore)store.getFeatureSource(TYPENAME);
        Listener listener1 = new Listener("one");
        Listener listener2 = new Listener("two");
        store1.addFeatureListener((FeatureListener)listener1);
        store2.addFeatureListener((FeatureListener)listener2);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        SimpleFeature feature = (SimpleFeature)this.FEATURES.get(0);
        Id fidFilter = ff.id(new FeatureId[]{feature.getIdentifier()});
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        WKTReader reader = new WKTReader(geometryFactory);
        Polygon geom = (Polygon)reader.read("POLYGON ((0 2, 1 0, 1 1, 0 1, 0 2))");
        ReferencedEnvelope bounds = new ReferencedEnvelope();
        bounds.include(feature.getBounds());
        bounds.expandToInclude(geom.getEnvelopeInternal());
        store1.modifyFeatures(new Name[]{new NameImpl("geom")}, new Object[]{geom}, (Filter)fidFilter);
        Assert.assertEquals((long)1L, (long)listener1.events.size());
        Assert.assertEquals((long)1L, (long)listener2.events.size());
        FeatureEvent event = listener1.getEvent(0);
        Assert.assertEquals((Object)bounds, (Object)event.getBounds());
        Assert.assertEquals((Object)FeatureEvent.Type.CHANGED, (Object)event.getType());
        Assert.assertEquals((Object)event, (Object)listener2.getEvent(0));
        listener1.events.clear();
        listener2.events.clear();
        store1.removeFeatures((Filter)fidFilter);
        Assert.assertEquals((long)1L, (long)listener1.events.size());
        Assert.assertEquals((long)1L, (long)listener2.events.size());
        event = listener1.getEvent(0);
        Assert.assertEquals((Object)feature.getBounds(), (Object)event.getBounds());
        Assert.assertEquals((Object)FeatureEvent.Type.REMOVED, (Object)event.getType());
        Assert.assertEquals((Object)event, (Object)listener2.getEvent(0));
        listener1.events.clear();
        listener2.events.clear();
        store1.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)feature));
        Assert.assertEquals((long)1L, (long)listener1.events.size());
        Assert.assertEquals((long)1L, (long)listener2.events.size());
        event = listener1.getEvent(0);
        Assert.assertEquals((Object)feature.getBounds(), (Object)event.getBounds());
        Assert.assertEquals((Object)FeatureEvent.Type.ADDED, (Object)event.getType());
        Assert.assertEquals((Object)event, (Object)listener2.getEvent(0));
    }

    @Test
    public void testFeatureEventsWithTransaction() throws Exception {
        AbstractContentTest.MockContentDataStore store = new AbstractContentTest.MockContentDataStore(this);
        SimpleFeatureStore store1 = (SimpleFeatureStore)store.getFeatureSource(TYPENAME);
        SimpleFeatureStore store2 = (SimpleFeatureStore)store.getFeatureSource(TYPENAME);
        store1.setTransaction((Transaction)this.defaultTransaction);
        store2.setTransaction((Transaction)this.anotherTransaction);
        Listener listener1 = new Listener("one");
        Listener listener2 = new Listener("two");
        store1.addFeatureListener((FeatureListener)listener1);
        store2.addFeatureListener((FeatureListener)listener2);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        SimpleFeature feature = (SimpleFeature)this.FEATURES.get(0);
        Id fidFilter = ff.id(new FeatureId[]{feature.getIdentifier()});
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        WKTReader reader = new WKTReader(geometryFactory);
        Polygon geom = (Polygon)reader.read("POLYGON ((0 2, 1 0, 1 1, 0 1, 0 2))");
        ReferencedEnvelope bounds = new ReferencedEnvelope();
        bounds.include(feature.getBounds());
        bounds.expandToInclude(geom.getEnvelopeInternal());
        store1.modifyFeatures(new Name[]{new NameImpl("geom")}, new Object[]{geom}, (Filter)fidFilter);
        Assert.assertEquals((long)1L, (long)listener1.events.size());
        Assert.assertEquals((long)0L, (long)listener2.events.size());
        FeatureEvent event = listener1.getEvent(0);
        Assert.assertEquals((Object)bounds, (Object)event.getBounds());
        Assert.assertEquals((Object)FeatureEvent.Type.CHANGED, (Object)event.getType());
        listener1.events.clear();
        listener2.events.clear();
        store1.getTransaction().rollback();
        Assert.assertEquals((long)1L, (long)listener1.events.size());
        Assert.assertEquals((long)0L, (long)listener2.events.size());
        event = listener1.getEvent(0);
        Assert.assertEquals((Object)bounds, (Object)event.getBounds());
        Assert.assertEquals((Object)FeatureEvent.Type.ROLLBACK, (Object)event.getType());
        listener1.events.clear();
        listener2.events.clear();
        store1.removeFeatures((Filter)fidFilter);
        Assert.assertEquals((long)1L, (long)listener1.events.size());
        Assert.assertEquals((long)0L, (long)listener2.events.size());
        event = listener1.getEvent(0);
        Assert.assertEquals((Object)feature.getBounds(), (Object)event.getBounds());
        Assert.assertEquals((Object)FeatureEvent.Type.REMOVED, (Object)event.getType());
        listener1.events.clear();
        listener2.events.clear();
        store1.getTransaction().commit();
        Assert.assertEquals((long)0L, (long)listener1.events.size());
        Assert.assertEquals((long)1L, (long)listener2.events.size());
        event = listener2.getEvent(0);
        Assert.assertEquals((Object)feature.getBounds(), (Object)event.getBounds());
        Assert.assertEquals((Object)FeatureEvent.Type.COMMIT, (Object)event.getType());
        listener1.events.clear();
        listener2.events.clear();
        store1.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)feature));
        Assert.assertEquals((long)1L, (long)listener1.events.size());
        event = listener1.getEvent(0);
        Assert.assertEquals((Object)feature.getBounds(), (Object)event.getBounds());
        Assert.assertEquals((Object)FeatureEvent.Type.ADDED, (Object)event.getType());
        Assert.assertEquals((long)0L, (long)listener2.events.size());
        listener1.events.clear();
        listener2.events.clear();
        store1.getTransaction().rollback();
        Assert.assertEquals((long)1L, (long)listener1.events.size());
        Assert.assertEquals((long)0L, (long)listener2.events.size());
        event = listener1.getEvent(0);
        Assert.assertEquals((Object)FeatureEvent.Type.ROLLBACK, (Object)event.getType());
    }

    @Test
    public void testBatchFeatureEvents() throws Exception {
        AbstractContentTest.MockContentDataStore store = new AbstractContentTest.MockContentDataStore(this);
        SimpleFeatureStore store1 = (SimpleFeatureStore)store.getFeatureSource(TYPENAME);
        SimpleFeatureStore store2 = (SimpleFeatureStore)store.getFeatureSource(TYPENAME);
        store1.setTransaction((Transaction)this.defaultTransaction);
        Listener listener1 = new Listener("one");
        Listener listener2 = new Listener("two");
        store1.addFeatureListener((FeatureListener)listener1);
        store2.addFeatureListener((FeatureListener)listener2);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        SimpleFeature feature0 = (SimpleFeature)this.FEATURES.get(0);
        SimpleFeature feature1 = (SimpleFeature)this.FEATURES.get(1);
        Id fidFilter0 = ff.id(new FeatureId[]{feature0.getIdentifier()});
        Id fidFilter1 = ff.id(new FeatureId[]{feature1.getIdentifier()});
        store1.removeFeatures((Filter)fidFilter0);
        Assert.assertEquals((long)1L, (long)listener1.events.size());
        Assert.assertEquals((long)0L, (long)listener2.events.size());
        FeatureEvent event = listener1.getEvent(0);
        Assert.assertEquals((Object)feature0.getBounds(), (Object)event.getBounds());
        Assert.assertEquals((Object)FeatureEvent.Type.REMOVED, (Object)event.getType());
        store1.removeFeatures((Filter)fidFilter1);
        Assert.assertEquals((long)2L, (long)listener1.events.size());
        Assert.assertEquals((long)0L, (long)listener2.events.size());
        event = listener1.getEvent(1);
        Assert.assertEquals((Object)feature1.getBounds(), (Object)event.getBounds());
        Assert.assertEquals((Object)FeatureEvent.Type.REMOVED, (Object)event.getType());
        store1.getTransaction().commit();
        Assert.assertEquals((long)2L, (long)listener1.events.size());
        Assert.assertEquals((long)1L, (long)listener2.events.size());
        event = listener2.getEvent(0);
        Assert.assertTrue((boolean)(event instanceof BatchFeatureEvent));
        ReferencedEnvelope bounds = new ReferencedEnvelope();
        bounds.include(feature0.getBounds());
        bounds.include(feature1.getBounds());
        Assert.assertEquals((Object)bounds, (Object)event.getBounds());
        Assert.assertEquals((Object)FeatureEvent.Type.COMMIT, (Object)event.getType());
    }

    private static class Listener
    implements FeatureListener {
        String name;
        List<FeatureEvent> events = new ArrayList<FeatureEvent>();

        public Listener(String name) {
            this.name = name;
        }

        public void changed(FeatureEvent featureEvent) {
            this.events.add(featureEvent);
        }

        FeatureEvent getEvent(int i) {
            return this.events.get(i);
        }
    }
}

