/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ows;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.geotools.data.ows.ServiceExceptionParser;
import org.geotools.ows.ServiceException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class ServiceExceptionParserTest {
    @Test
    public void testSimple() throws Exception {
        ServiceException exception = ServiceExceptionParser.parse((InputStream)this.mockStream("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<ServiceExceptionReport>\n  <ServiceException code=\"42\">test</ServiceException>\n</ServiceExceptionReport>"));
        MatcherAssert.assertThat((Object)exception, (Matcher)Matchers.both((Matcher)Matchers.hasProperty((String)"message", (Matcher)Matchers.equalTo((Object)"test"))).and(Matchers.hasProperty((String)"code", (Matcher)Matchers.equalTo((Object)"42"))));
        MatcherAssert.assertThat((Object)exception.getNext(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testCoalescing() throws Exception {
        ServiceException exception = ServiceExceptionParser.parse((InputStream)this.mockStream("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<ServiceExceptionReport>\n  <ServiceException code=\"42\"><![CDATA[coalesced]]> message</ServiceException>\n</ServiceExceptionReport>"));
        MatcherAssert.assertThat((Object)exception, (Matcher)Matchers.both((Matcher)Matchers.hasProperty((String)"message", (Matcher)Matchers.equalTo((Object)"coalesced message"))).and(Matchers.hasProperty((String)"code", (Matcher)Matchers.equalTo((Object)"42"))));
        MatcherAssert.assertThat((Object)exception.getNext(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testSequence() throws Exception {
        ServiceException exception = ServiceExceptionParser.parse((InputStream)this.mockStream("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<ServiceExceptionReport>\n  <ServiceException code=\"42\">test</ServiceException>\n  <ServiceException code=\"20\">another test</ServiceException>\n  <ServiceException code=\"60\">yet another test</ServiceException>\n</ServiceExceptionReport>"));
        MatcherAssert.assertThat((Object)exception, (Matcher)Matchers.both((Matcher)Matchers.hasProperty((String)"message", (Matcher)Matchers.equalTo((Object)"test"))).and(Matchers.hasProperty((String)"code", (Matcher)Matchers.equalTo((Object)"42"))));
        MatcherAssert.assertThat((Object)exception.getNext(), (Matcher)Matchers.both((Matcher)Matchers.hasProperty((String)"message", (Matcher)Matchers.equalTo((Object)"another test"))).and(Matchers.hasProperty((String)"code", (Matcher)Matchers.equalTo((Object)"20"))));
        MatcherAssert.assertThat((Object)exception.getNext().getNext(), (Matcher)Matchers.both((Matcher)Matchers.hasProperty((String)"message", (Matcher)Matchers.equalTo((Object)"yet another test"))).and(Matchers.hasProperty((String)"code", (Matcher)Matchers.equalTo((Object)"60"))));
        MatcherAssert.assertThat((Object)exception.getNext().getNext().getNext(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testSequenceWithEmptyCodes() throws Exception {
        ServiceException exception = ServiceExceptionParser.parse((InputStream)this.mockStream("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<ServiceExceptionReport>\n  <ServiceException>test</ServiceException>\n  <ServiceException code=\"\">another test</ServiceException>\n  <ServiceException code=\"60\">yet another test</ServiceException>\n  <ServiceException code=\"20\">still another test</ServiceException>\n</ServiceExceptionReport>"));
        MatcherAssert.assertThat((Object)exception, (Matcher)Matchers.both((Matcher)Matchers.hasProperty((String)"message", (Matcher)Matchers.equalTo((Object)"yet another test"))).and(Matchers.hasProperty((String)"code", (Matcher)Matchers.equalTo((Object)"60"))));
        MatcherAssert.assertThat((Object)exception.getNext(), (Matcher)Matchers.both((Matcher)Matchers.hasProperty((String)"message", (Matcher)Matchers.equalTo((Object)"still another test"))).and(Matchers.hasProperty((String)"code", (Matcher)Matchers.equalTo((Object)"20"))));
        MatcherAssert.assertThat((Object)exception.getNext().getNext(), (Matcher)Matchers.both((Matcher)Matchers.hasProperty((String)"message", (Matcher)Matchers.equalTo((Object)"test"))).and(Matchers.hasProperty((String)"code", (Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)exception.getNext().getNext().getNext(), (Matcher)Matchers.both((Matcher)Matchers.hasProperty((String)"message", (Matcher)Matchers.equalTo((Object)"another test"))).and(Matchers.hasProperty((String)"code", (Matcher)Matchers.equalTo((Object)""))));
        MatcherAssert.assertThat((Object)exception.getNext().getNext().getNext().getNext(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testXXE() throws Exception {
        URL resource = ServiceExceptionParserTest.class.getResource("secret.txt");
        ServiceException exception = ServiceExceptionParser.parse((InputStream)this.mockStream("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<!DOCTYPE foo [ <!ELEMENT ServiceExceptionReport ANY ><!ENTITY xxe SYSTEM \"" + String.valueOf(resource) + "\" >]><ServiceExceptionReport>\n  <ServiceException code=\"42\">&xxe;</ServiceException>\n</ServiceExceptionReport>"));
        MatcherAssert.assertThat((Object)exception, (Matcher)Matchers.hasProperty((String)"message", (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Top secret information that shouldn't appear in an error message."))));
        MatcherAssert.assertThat((Object)exception.getNext(), (Matcher)Matchers.nullValue());
    }

    protected InputStream mockStream(String string) {
        return new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
    }
}

