/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import org.geotools.data.DataTestCase;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class MemoryDataStoreConcurrencyTest
extends DataTestCase {
    @Test
    public void testConcurrencyReadsAndWrite() throws Exception {
        MemoryDataStore dataStore = new MemoryDataStore();
        dataStore.createSchema(this.roadType);
        Runnable writeSomeFeatures = () -> {
            for (int i = 0; i < 10000 && !Thread.interrupted(); ++i) {
                SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)this.roadType, (Object[])new Object[]{i, this.line(new int[]{10, 10, 20, 10}), "r" + i}, (String)("road.rd" + i));
                dataStore.addFeature(feature);
            }
        };
        Thread writeThread = new Thread(writeSomeFeatures);
        writeThread.start();
        try {
            for (int i = 0; i < 10; ++i) {
                Assert.assertNotNull((Object)dataStore);
                Query query = new Query(this.roadType.getTypeName());
                try (FeatureReader featureReader = dataStore.getFeatureReader(query, Transaction.AUTO_COMMIT);){
                    Assert.assertNotNull((Object)featureReader);
                    while (featureReader.hasNext()) {
                        featureReader.next();
                    }
                    continue;
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            writeThread.interrupt();
            writeThread.join();
        }
    }
}

