/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import org.geotools.data.DataTestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MemoryDataStoreBoundsTest
extends DataTestCase {
    MemoryDataStore data;
    ReferencedEnvelope riverBounds;

    public void init() throws Exception {
        super.init();
        this.data = new MemoryDataStore();
        this.data.addFeatures(this.roadFeatures);
        SimpleFeatureType riverTypeWithCrs = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.riverType, (CoordinateReferenceSystem)CRS.decode((String)"EPSG:4326"));
        this.data.addFeature(SimpleFeatureBuilder.retype((SimpleFeature)this.riverFeatures[0], (SimpleFeatureType)riverTypeWithCrs));
        this.riverBounds = new ReferencedEnvelope(this.riverFeatures[0].getBounds());
    }

    @After
    public void tearDown() throws Exception {
        this.data = null;
        super.tearDown();
    }

    @Test
    public void testGetBounds() throws Exception {
        Assert.assertEquals((Object)this.roadBounds, (Object)this.data.getFeatureSource("road").getBounds(Query.ALL));
    }

    @Test
    public void testGetBoundsFilter() throws Exception {
        Query query = new Query("road", this.rd2Filter);
        Assert.assertEquals((Object)this.roadFeatures[1].getBounds(), (Object)this.data.getFeatureSource("road").getFeatures(query).getBounds());
    }

    @Test
    public void testNoCrs() throws Exception {
        Query query = new Query(Query.ALL);
        ReferencedEnvelope envelope = this.data.getFeatureSource("road").getBounds(query);
        Assert.assertNull((Object)envelope.getCoordinateReferenceSystem());
    }

    @Test
    public void testSetsEnvelopeCrsFromQuery() throws Exception {
        Query query = new Query(Query.ALL);
        query.setCoordinateSystem((CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D);
        ReferencedEnvelope envelope = this.data.getFeatureSource("river").getBounds(query);
        Assert.assertEquals((Object)DefaultEngineeringCRS.CARTESIAN_2D, (Object)envelope.getCoordinateReferenceSystem());
        Assert.assertEquals((Object)new ReferencedEnvelope((Envelope)this.riverBounds, (CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D), (Object)envelope);
    }

    @Test
    public void testReprojectEnvelopeCrsFromQuery() throws Exception {
        Query query = new Query(Query.ALL);
        CoordinateReferenceSystem sourceCRS = CRS.decode((String)"EPSG:4326");
        CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:3005");
        query.setCoordinateSystemReproject(targetCRS);
        ReferencedEnvelope envelope = this.data.getFeatureSource("river").getBounds(query);
        Assert.assertEquals((Object)targetCRS, (Object)envelope.getCoordinateReferenceSystem());
        Assert.assertEquals((Object)new ReferencedEnvelope((Envelope)this.riverBounds, sourceCRS).transform(targetCRS, true), (Object)envelope);
    }

    @Test
    public void testSetReprojectEnvelopeCrsFromQuery() throws Exception {
        Query query = new Query(Query.ALL);
        query.setCoordinateSystem((CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D);
        query.setCoordinateSystemReproject((CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D);
        ReferencedEnvelope envelope = this.data.getFeatureSource("river").getBounds(query);
        Assert.assertEquals((Object)DefaultEngineeringCRS.CARTESIAN_2D, (Object)envelope.getCoordinateReferenceSystem());
        Assert.assertEquals((Object)new ReferencedEnvelope((Envelope)this.riverBounds, (CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D).transform((CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D, true), (Object)envelope);
    }

    @Test
    public void testSetsEnvelopeCrsFromFeatureType() throws Exception {
        Query query = new Query(Query.ALL);
        CoordinateReferenceSystem sourceCRS = CRS.decode((String)"EPSG:4326");
        ReferencedEnvelope envelope = this.data.getFeatureSource("river").getBounds(query);
        Assert.assertEquals((Object)sourceCRS, (Object)envelope.getCoordinateReferenceSystem());
    }

    @Test
    public void testGetBoundsSupportsFeaturesWithoutGeometry() throws Exception {
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(this.data.getSchema("road"));
        featureBuilder.init(this.roadFeatures[0]);
        featureBuilder.set("geom", null);
        SimpleFeature feature = featureBuilder.buildFeature("road.rd0");
        this.data.addFeature(feature);
        ContentFeatureSource road = this.data.getFeatureSource("road");
        Assert.assertEquals((Object)this.roadBounds, (Object)road.getBounds(Query.ALL));
    }

    @Test
    public void testGetBoundsSupportsEmptyBounds() throws Exception {
        SimpleFeatureType type = DataUtilities.createType((String)"test", (String)"id:0,geom:LineString,name:String");
        SimpleFeature[] features = new SimpleFeature[]{SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{1, null, "r1"}, (String)"test.f1"), SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{2, null, "r2"}, (String)"test.f2"), SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{3, null, "r3"}, (String)"test.f3")};
        this.data.addFeatures(features);
        ContentFeatureSource featureSource = this.data.getFeatureSource("test");
        Assert.assertTrue((boolean)featureSource.getBounds(Query.ALL).isEmpty());
    }
}

