/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.spatialschema.geometry.primitive;

import org.geotools.geometry.jts.spatialschema.geometry.JTSGeometry;
import org.geotools.geometry.jts.spatialschema.geometry.geometry.GenericSurfaceImpl;
import org.locationtech.jts.geom.Geometry;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.primitive.Surface;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.geometry.primitive.SurfaceInterpolation;
import org.opengis.geometry.primitive.SurfacePatch;

public abstract class SurfacePatchImpl
extends GenericSurfaceImpl
implements SurfacePatch,
JTSGeometry {
    private Surface surface;
    private SurfaceInterpolation interpolation;
    private SurfaceBoundary boundary;
    private Geometry jtsPeer;

    public SurfacePatchImpl(SurfaceInterpolation interpolation, SurfaceBoundary boundary) {
        this.interpolation = interpolation;
        this.boundary = boundary;
    }

    public Surface getSurface() {
        return null;
    }

    public void setSurface(Surface surface) {
        this.surface = surface;
    }

    public SurfaceInterpolation getInterpolation() {
        return this.interpolation;
    }

    public abstract int getNumDerivativesOnBoundary();

    public SurfaceBoundary getBoundary() {
        return this.boundary;
    }

    @Override
    public final double[] getUpNormal(DirectPosition point) {
        return new double[]{0.0, 0.0, 1.0};
    }

    @Override
    public final double getPerimeter() {
        Geometry jtsGeom = this.getJTSGeometry();
        return jtsGeom.getBoundary().getLength();
    }

    @Override
    public final double getArea() {
        Geometry jtsGeom = this.getJTSGeometry();
        return jtsGeom.getArea();
    }

    @Override
    public Geometry getJTSGeometry() {
        if (this.jtsPeer == null) {
            this.jtsPeer = this.calculateJTSPeer();
        }
        return this.jtsPeer;
    }

    @Override
    public void invalidateCachedJTSPeer() {
        this.jtsPeer = null;
    }

    public abstract Geometry calculateJTSPeer();
}

