/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.spatialschema.geometry.primitive;

import org.geotools.geometry.jts.spatialschema.geometry.JTSUtils;
import org.geotools.geometry.jts.spatialschema.geometry.complex.CompositeCurveImpl;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opengis.geometry.complex.CompositeCurve;
import org.opengis.geometry.primitive.Ring;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class RingImpl
extends CompositeCurveImpl
implements Ring {
    public RingImpl() {
        this(null, null);
    }

    public RingImpl(CoordinateReferenceSystem crs) {
        this(null, crs);
    }

    public RingImpl(CompositeCurve parentCurve) {
        this(parentCurve, parentCurve.getCoordinateReferenceSystem());
    }

    public RingImpl(CompositeCurve parentCurve, CoordinateReferenceSystem crs) {
        super(parentCurve, crs);
    }

    public boolean isValid() {
        Coordinate[] coords = this.computeJTSPeer().getCoordinates();
        int count = coords.length;
        if (count > 2) {
            if (!coords[0].equals((Object)coords[count - 1])) {
                Coordinate[] tmp = new Coordinate[count + 1];
                System.arraycopy(coords, 0, tmp, 0, count);
                tmp[count] = coords[0];
                coords = tmp;
            }
            LineString jtsLineString = JTSUtils.GEOMETRY_FACTORY.createLineString(coords);
            return jtsLineString.isRing();
        }
        return false;
    }
}

