/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.spatialschema.geometry;

import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Set;
import org.geotools.geometry.GeometryFactoryFinder;
import org.geotools.geometry.jts.spatialschema.geometry.DirectPositionImpl;
import org.geotools.geometry.jts.spatialschema.geometry.GeometryUtils;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.PositionFactory;
import org.opengis.geometry.aggregate.MultiPrimitive;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Polygon;
import org.opengis.geometry.coordinate.PolyhedralSurface;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.Curve;
import org.opengis.geometry.primitive.PrimitiveFactory;
import org.opengis.geometry.primitive.Ring;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;

public final class JTSUtils {
    public static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();

    private JTSUtils() {
    }

    public static org.opengis.geometry.Geometry jtsToGo1(Geometry jtsGeom, CoordinateReferenceSystem crs) {
        Hints hints = new Hints((RenderingHints.Key)Hints.CRS, (Object)crs);
        PrimitiveFactory pf = GeometryFactoryFinder.getPrimitiveFactory((Hints)hints);
        org.opengis.geometry.coordinate.GeometryFactory gf = GeometryFactoryFinder.getGeometryFactory((Hints)hints);
        String geomType = jtsGeom.getGeometryType();
        if (geomType.equalsIgnoreCase("Point")) {
            Point jtsPoint = (Point)jtsGeom;
            DirectPosition dp = JTSUtils.pointToDirectPosition(jtsPoint, crs);
            org.opengis.geometry.primitive.Point result = pf.createPoint((Position)dp);
            return result;
        }
        if (geomType.equalsIgnoreCase("LineString")) {
            LineString jtsLineString = (LineString)jtsGeom;
            int numPoints = jtsLineString.getNumPoints();
            org.opengis.geometry.coordinate.LineString ls = gf.createLineString(new ArrayList());
            PointArray pointList = ls.getControlPoints();
            for (int i = 0; i < numPoints; ++i) {
                pointList.add(JTSUtils.coordinateToDirectPosition(jtsLineString.getCoordinateN(i), crs));
            }
            ArrayList<org.opengis.geometry.coordinate.LineString> segments = new ArrayList<org.opengis.geometry.coordinate.LineString>();
            segments.add(ls);
            Curve result = pf.createCurve(segments);
            return result;
        }
        if (geomType.equalsIgnoreCase("LinearRing")) {
            Ring result = JTSUtils.linearRingToRing((LineString)((LinearRing)jtsGeom), crs);
            return result;
        }
        if (geomType.equalsIgnoreCase("Polygon")) {
            org.locationtech.jts.geom.Polygon jtsPolygon = (org.locationtech.jts.geom.Polygon)jtsGeom;
            Ring externalRing = JTSUtils.linearRingToRing((LineString)jtsPolygon.getExteriorRing(), crs);
            int n = jtsPolygon.getNumInteriorRing();
            ArrayList<Ring> internalRings = new ArrayList<Ring>();
            for (int i = 0; i < n; ++i) {
                internalRings.add(JTSUtils.linearRingToRing((LineString)jtsPolygon.getInteriorRingN(i), crs));
            }
            SurfaceBoundary boundary = pf.createSurfaceBoundary(externalRing, internalRings);
            Polygon polygon = gf.createPolygon(boundary);
            ArrayList<Polygon> patches = new ArrayList<Polygon>();
            patches.add(polygon);
            PolyhedralSurface result = gf.createPolyhedralSurface(patches);
            return result;
        }
        if (geomType.equalsIgnoreCase("GeometryCollection") || geomType.equalsIgnoreCase("MultiPoint") || geomType.equalsIgnoreCase("MultiLineString") || geomType.equalsIgnoreCase("MultiPolygon")) {
            GeometryCollection jtsCollection = (GeometryCollection)jtsGeom;
            int n = jtsCollection.getNumGeometries();
            MultiPrimitive result = gf.createMultiPrimitive();
            Set elements = result.getElements();
            for (int i = 0; i < n; ++i) {
                elements.add(JTSUtils.jtsToGo1(jtsCollection.getGeometryN(i), crs));
            }
            return result;
        }
        throw new IllegalArgumentException("Unsupported geometry type: " + geomType);
    }

    public static Coordinate directPositionToCoordinate(DirectPosition dp) {
        double x = Double.NaN;
        double y = Double.NaN;
        double z = Double.NaN;
        int d = dp.getDimension();
        if (d >= 1) {
            x = dp.getOrdinate(0);
            if (d >= 2) {
                y = dp.getOrdinate(1);
                if (d >= 3) {
                    z = dp.getOrdinate(2);
                }
            }
        }
        return new Coordinate(x, y, z);
    }

    public static void directPositionToCoordinate(DirectPosition dp, Coordinate result) {
        int d = dp.getDimension();
        if (d >= 1) {
            result.x = dp.getOrdinate(0);
            if (d >= 2) {
                result.y = dp.getOrdinate(1);
                if (d >= 3) {
                    result.setZ(dp.getOrdinate(3));
                } else {
                    result.setZ(Double.NaN);
                }
            } else {
                result.y = Double.NaN;
                result.setZ(Double.NaN);
            }
        } else {
            result.y = Double.NaN;
            result.x = Double.NaN;
            result.setZ(Double.NaN);
        }
    }

    public static Point directPositionToPoint(DirectPosition dp) {
        return GEOMETRY_FACTORY.createPoint(JTSUtils.directPositionToCoordinate(dp));
    }

    public static DirectPosition coordinateToDirectPosition(Coordinate c, CoordinateReferenceSystem crs) {
        Hints hints = new Hints((RenderingHints.Key)Hints.CRS, (Object)crs);
        PositionFactory pf = GeometryFactoryFinder.getPositionFactory((Hints)hints);
        double[] vertices = crs == null ? new double[3] : new double[crs.getCoordinateSystem().getDimension()];
        DirectPosition result = pf.createDirectPosition(vertices);
        JTSUtils.coordinateToDirectPosition(c, result);
        return result;
    }

    public static void coordinateToDirectPosition(Coordinate c, DirectPosition result) {
        CoordinateReferenceSystem crs = result.getCoordinateReferenceSystem();
        int d = crs.getCoordinateSystem().getDimension();
        CoordinateSystem cs = crs.getCoordinateSystem();
        if (d >= 1) {
            int xIndex = GeometryUtils.getDirectedAxisIndex(cs, AxisDirection.EAST);
            result.setOrdinate(xIndex, c.x);
            if (d >= 2) {
                int yIndex = GeometryUtils.getDirectedAxisIndex(cs, AxisDirection.NORTH);
                result.setOrdinate(yIndex, c.y);
                if (d >= 3) {
                    int zIndex = GeometryUtils.getDirectedAxisIndex(cs, AxisDirection.UP);
                    result.setOrdinate(zIndex, c.getZ());
                    if (d > 3) {
                        for (int i = 3; i < d; ++i) {
                            result.setOrdinate(i, 0.0);
                        }
                    }
                }
            }
        }
    }

    public static DirectPosition pointToDirectPosition(Point p, CoordinateReferenceSystem crs) {
        return JTSUtils.coordinateToDirectPosition(p.getCoordinate(), crs);
    }

    public static Ring linearRingToRing(LineString jtsLinearRing, CoordinateReferenceSystem crs) {
        int numPoints = jtsLinearRing.getNumPoints();
        if (!jtsLinearRing.getCoordinateN(0).equals((Object)jtsLinearRing.getCoordinateN(numPoints - 1))) {
            throw new IllegalArgumentException("LineString must be a ring");
        }
        Hints hints = new Hints((RenderingHints.Key)Hints.CRS, (Object)crs);
        PrimitiveFactory pf = GeometryFactoryFinder.getPrimitiveFactory((Hints)hints);
        org.opengis.geometry.coordinate.GeometryFactory gf = GeometryFactoryFinder.getGeometryFactory((Hints)hints);
        org.opengis.geometry.coordinate.LineString ls = gf.createLineString(new ArrayList());
        PointArray pointList = ls.getControlPoints();
        for (int i = 0; i < numPoints; ++i) {
            pointList.add(JTSUtils.coordinateToDirectPosition(jtsLinearRing.getCoordinateN(i), crs));
        }
        Curve curve = pf.createCurve(new ArrayList());
        curve.getSegments().add(ls);
        Ring result = pf.createRing(new ArrayList());
        result.getGenerators().add(curve);
        return result;
    }

    public static double distance(Geometry g1, Geometry g2) {
        if (g1 instanceof GeometryCollection) {
            double minDistance = Double.POSITIVE_INFINITY;
            GeometryCollection gc1 = (GeometryCollection)g1;
            int n = gc1.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                double d = JTSUtils.distance(gc1.getGeometryN(i), g2);
                if (!(d < minDistance)) continue;
                minDistance = d;
            }
            return minDistance;
        }
        if (g2 instanceof GeometryCollection) {
            double minDistance = Double.POSITIVE_INFINITY;
            GeometryCollection gc2 = (GeometryCollection)g2;
            int n = gc2.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                double d = JTSUtils.distance(g1, gc2.getGeometryN(i));
                if (!(d < minDistance)) continue;
                minDistance = d;
            }
            return minDistance;
        }
        return g1.distance(g2);
    }

    public static Geometry union(Geometry g1, Geometry g2) {
        return null;
    }

    public static Geometry intersection(Geometry g1, Geometry g2) {
        return null;
    }

    public static Geometry difference(Geometry g1, Geometry g2) {
        return null;
    }

    public static Geometry symmetricDifference(Geometry g1, Geometry g2) {
        return null;
    }

    public static boolean contains(Geometry g1, Geometry g2) {
        return false;
    }

    public static boolean equals(Geometry g1, Geometry g2) {
        return false;
    }

    public static boolean intersects(Geometry g1, Geometry g2) {
        if (g1 instanceof GeometryCollection) {
            GeometryCollection gc1 = (GeometryCollection)g1;
            int n = gc1.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                Geometry g = gc1.getGeometryN(i);
                if (!JTSUtils.intersects(g, g2)) continue;
                return true;
            }
            return false;
        }
        if (g2 instanceof GeometryCollection) {
            GeometryCollection gc2 = (GeometryCollection)g2;
            int n = gc2.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                Geometry g = gc2.getGeometryN(i);
                if (!JTSUtils.intersects(g1, g)) continue;
                return true;
            }
            return false;
        }
        return g1.intersects(g2);
    }

    public static Geometry getEnvelopeGeometry(Envelope envelope) {
        DirectPosition topCorner = envelope.getUpperCorner();
        DirectPosition botCorner = envelope.getLowerCorner();
        DirectPositionImpl topLeft = new DirectPositionImpl(topCorner);
        DirectPositionImpl botRight = new DirectPositionImpl(botCorner);
        topLeft.setOrdinate(1, botCorner.getOrdinate(1));
        botRight.setOrdinate(1, topCorner.getOrdinate(1));
        Coordinate jtsTopRight = JTSUtils.directPositionToCoordinate(topCorner);
        Coordinate jtsTopLeft = JTSUtils.directPositionToCoordinate(topLeft);
        Coordinate jtsBotLeft = JTSUtils.directPositionToCoordinate(botCorner);
        Coordinate jtsBotRight = JTSUtils.directPositionToCoordinate(botRight);
        Geometry jtsEnv = GEOMETRY_FACTORY.createLineString(new Coordinate[]{jtsTopLeft, jtsTopRight, jtsBotRight, jtsBotLeft, jtsTopLeft}).getEnvelope();
        return jtsEnv;
    }
}

