/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.spatialschema.geometry;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import org.geotools.geometry.jts.spatialschema.geometry.GeometryUtils;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DirectPosition2D
extends Point2D.Double
implements DirectPosition,
Serializable {
    private CoordinateReferenceSystem crs;

    public DirectPosition2D() {
    }

    public DirectPosition2D(CoordinateReferenceSystem crs) {
        this.setCoordinateReferenceSystem(crs);
    }

    public DirectPosition2D(double x, double y) {
        super(x, y);
    }

    public DirectPosition2D(CoordinateReferenceSystem crs, double x, double y) {
        super(x, y);
        this.setCoordinateReferenceSystem(crs);
    }

    public DirectPosition2D(Point2D point) {
        super(point.getX(), point.getY());
        if (point instanceof DirectPosition) {
            this.setCoordinateReferenceSystem(((DirectPosition)point).getCoordinateReferenceSystem());
        }
    }

    public DirectPosition2D(DirectPosition point) {
        this.setLocation(point);
    }

    public DirectPosition getDirectPosition() {
        return this;
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        GeometryUtils.checkDimension("dimension", crs, 2);
        this.crs = crs;
    }

    public final int getDimension() {
        return 2;
    }

    public double[] getCoordinate() {
        return new double[]{this.x, this.y};
    }

    public final double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        switch (dimension) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    public final void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
        switch (dimension) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(String.valueOf(dimension));
            }
        }
    }

    public void setLocation(DirectPosition position) throws MismatchedDimensionException {
        GeometryUtils.ensureDimensionMatch("position", position.getDimension(), 2);
        this.setCoordinateReferenceSystem(position.getCoordinateReferenceSystem());
        this.x = position.getOrdinate(0);
        this.y = position.getOrdinate(1);
    }

    public Point2D toPoint2D() {
        return new Point2D.Double(this.x, this.y);
    }

    @Override
    public String toString() {
        return DirectPosition2D.toString(this, this.getCoordinate());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DirectPosition2D that = (DirectPosition2D)o;
        return Objects.equals(this.crs, that.crs);
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        if (this.crs != null) {
            code ^= this.crs.hashCode();
        }
        return code;
    }

    @Override
    public DirectPosition2D clone() {
        return (DirectPosition2D)super.clone();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeDouble(this.x);
        out.writeDouble(this.y);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.x = in.readDouble();
        this.y = in.readDouble();
    }

    static String toString(Object owner, double[] ordinates) {
        StringBuffer buffer = new StringBuffer(owner.toString());
        buffer.append('[');
        for (int i = 0; i < ordinates.length; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(ordinates[i]);
        }
        buffer.append(']');
        return buffer.toString();
    }
}

