/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.jp2k;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderCodecLibSpi;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderSpi;
import it.geosolutions.imageio.imageioimpl.imagereadmt.ImageReadDescriptorMT;
import it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageReaderSpi;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import it.geosolutions.util.KakaduUtilities;
import java.awt.RenderingHints;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import org.geotools.coverage.grid.io.GridFormatFactorySpi;
import org.geotools.coverageio.jp2k.JP2KFormat;
import org.geotools.util.logging.Logging;

public final class JP2KFormatFactory
implements GridFormatFactorySpi {
    private static final Logger LOGGER;
    static ImageReaderSpi cachedSpi;

    public static ImageReaderSpi getCachedSpi() {
        return cachedSpi;
    }

    public boolean isAvailable() {
        boolean available = false;
        try {
            Class.forName("javax.media.jai.JAI");
            Class.forName("com.sun.media.jai.operator.ImageReadDescriptor");
            if (cachedSpi != null) {
                available = true;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                if (available) {
                    LOGGER.fine("JP2KFormatFactory is available.");
                } else {
                    LOGGER.fine("JP2KFormatFactory is not available.");
                }
            }
        }
        catch (ClassNotFoundException cnf) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("JP2KFormatFactory is not available.");
            }
            available = false;
        }
        return available;
    }

    public JP2KFormat createFormat() {
        return new JP2KFormat();
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }

    static {
        String jp2CodecLibName;
        String standardJp2Name;
        String kakaduJp2Name;
        boolean hasStandardJp2;
        boolean hasNativeJp2;
        boolean hasKakaduSpi;
        block16: {
            block15: {
                block14: {
                    LOGGER = Logging.getLogger(JP2KFormatFactory.class);
                    try {
                        new ParameterBlockJAI("ImageReadMT");
                    }
                    catch (Exception e) {
                        try {
                            ImageReadDescriptorMT.register((JAI)JAI.getDefaultInstance());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    hasKakaduSpi = false;
                    hasNativeJp2 = false;
                    hasStandardJp2 = false;
                    kakaduJp2Name = null;
                    standardJp2Name = null;
                    jp2CodecLibName = null;
                    try {
                        Class.forName("it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageReaderSpi");
                        kakaduJp2Name = JP2KKakaduImageReaderSpi.class.getName();
                        hasKakaduSpi = true;
                    }
                    catch (ClassNotFoundException e) {
                        if (!LOGGER.isLoggable(Level.WARNING)) break block14;
                        LOGGER.log(Level.WARNING, "Unable to load specific JP2K reader spi", e);
                    }
                }
                try {
                    Class.forName("com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderSpi");
                    standardJp2Name = J2KImageReaderSpi.class.getName();
                    hasStandardJp2 = true;
                }
                catch (ClassNotFoundException e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block15;
                    LOGGER.log(Level.WARNING, "Unable to load specific JP2K reader spi", e);
                }
            }
            try {
                Class.forName("com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderCodecLibSpi");
                jp2CodecLibName = J2KImageReaderCodecLibSpi.class.getName();
                hasNativeJp2 = true;
            }
            catch (ClassNotFoundException e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block16;
                LOGGER.log(Level.WARNING, "Unable to load specific JP2K reader spi", e);
            }
        }
        if (hasKakaduSpi && KakaduUtilities.isKakaduAvailable()) {
            cachedSpi = new JP2KKakaduImageReaderSpi();
            if (hasStandardJp2) {
                ImageIOUtilities.replaceProvider(ImageReaderSpi.class, (String)kakaduJp2Name, (String)standardJp2Name, (String)"JPEG2000");
            }
            if (hasNativeJp2) {
                ImageIOUtilities.replaceProvider(ImageReaderSpi.class, (String)kakaduJp2Name, (String)jp2CodecLibName, (String)"JPEG2000");
            }
        } else {
            cachedSpi = hasStandardJp2 ? new J2KImageReaderSpi() : new J2KImageReaderCodecLibSpi();
        }
    }
}

