/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.jp2k;

import java.awt.Rectangle;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.metadata.extent.GeographicBoundingBox;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverageio.jp2k.Granule;
import org.geotools.coverageio.jp2k.JP2KReader;
import org.geotools.coverageio.jp2k.RasterLayerRequest;
import org.geotools.coverageio.jp2k.RasterLayerResponse;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.util.ImageUtilities;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.referencing.CRS;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.Utilities;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

class RasterManager {
    private static final Logger LOGGER = Logging.getLogger(RasterManager.class);
    final SoftValueHashMap<String, Granule> granulesCache = new SoftValueHashMap();
    private CoordinateReferenceSystem coverageCRS;
    private GeneralBounds coverageEnvelope;
    private GridCoverageFactory coverageFactory;
    private String coverageIdentifier;
    private double[] highestRes;
    private Hints hints;
    private URL inputURL;
    private int numberOfOverviews;
    private double[][] overviewsResolution;
    private MathTransform raster2Model;
    OverviewsController overviewsController;
    private GridEnvelope coverageGridrange;
    OverviewPolicy overviewPolicy;
    DecimationController decimationController;
    JP2KReader parent;
    boolean expandMe;
    SpatialDomainManager spatialDomainManager;

    public RasterManager(JP2KReader reader) throws DataSourceException {
        Utilities.ensureNonNull((String)"JP2KReader", (Object)((Object)reader));
        this.parent = reader;
        this.expandMe = this.parent.expandMe;
        this.inputURL = reader.sourceURL;
        this.coverageIdentifier = reader.getName();
        this.hints = reader.getHints();
        this.coverageEnvelope = reader.getOriginalEnvelope();
        this.coverageGridrange = reader.getOriginalGridRange();
        this.coverageCRS = reader.getCoordinateReferenceSystem();
        this.raster2Model = reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER);
        this.coverageIdentifier = reader.getName();
        this.coverageFactory = reader.getGridCoverageFactory();
        this.highestRes = reader.getHighestRes();
        this.numberOfOverviews = reader.getNumberOfOverviews();
        this.overviewsResolution = reader.getOverviewsResolution();
        this.overviewsController = new OverviewsController();
        this.decimationController = new DecimationController();
        try {
            this.spatialDomainManager = new SpatialDomainManager();
        }
        catch (FactoryException | TransformException e) {
            throw new DataSourceException(e);
        }
        this.extractOverviewPolicy();
    }

    private OverviewPolicy extractOverviewPolicy() {
        if (this.hints != null && this.hints.containsKey((Object)Hints.OVERVIEW_POLICY)) {
            this.overviewPolicy = (OverviewPolicy)this.hints.get((Object)Hints.OVERVIEW_POLICY);
        }
        if (this.overviewPolicy == null) {
            this.overviewPolicy = OverviewPolicy.getDefaultPolicy();
        }
        assert (this.overviewPolicy != null);
        return this.overviewPolicy;
    }

    public Collection<GridCoverage2D> read(GeneralParameterValue[] params) throws IOException {
        RasterLayerRequest request = new RasterLayerRequest(params, this);
        if (request.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Request is empty: " + request.toString());
            }
            return Collections.emptyList();
        }
        RasterLayerResponse response = new RasterLayerResponse(request, this);
        GridCoverage2D elem = response.createResponse();
        if (elem != null) {
            return Collections.singletonList(elem);
        }
        return Collections.emptyList();
    }

    public void dispose() {
    }

    public URL getInputURL() {
        return this.inputURL;
    }

    public String getCoverageIdentifier() {
        return this.coverageIdentifier;
    }

    public Hints getHints() {
        return this.hints;
    }

    public CoordinateReferenceSystem getCoverageCRS() {
        return this.coverageCRS;
    }

    public GeneralBounds getCoverageEnvelope() {
        return this.coverageEnvelope;
    }

    public GridCoverageFactory getCoverageFactory() {
        return this.coverageFactory;
    }

    public MathTransform getRaster2Model() {
        return this.raster2Model;
    }

    public GridEnvelope getCoverageGridrange() {
        return this.coverageGridrange;
    }

    class SpatialDomainManager {
        ReferencedEnvelope coverageBBox;
        CoordinateReferenceSystem coverageCRS;
        CoordinateReferenceSystem coverageCRS2D;
        GeneralBounds coverageEnvelope = null;
        double[] coverageFullResolution;
        ReferencedEnvelope coverageGeographicBBox;
        CoordinateReferenceSystem coverageGeographicCRS2D;
        MathTransform2D coverageGridToWorld2D;
        Rectangle coverageRasterArea;

        public SpatialDomainManager() throws TransformException, FactoryException {
            this.setBaseParameters();
            this.prepareCoverageSpatialElements();
        }

        private void prepareCoverageSpatialElements() throws TransformException, FactoryException {
            this.coverageGeographicBBox = ImageUtilities.getReferencedEnvelopeFromGeographicBoundingBox((GeographicBoundingBox)new GeographicBoundingBoxImpl((Bounds)this.coverageEnvelope));
            this.coverageGeographicCRS2D = this.coverageGeographicBBox.getCoordinateReferenceSystem();
            this.coverageCRS2D = CRS.getHorizontalCRS((CoordinateReferenceSystem)this.coverageCRS);
            assert (this.coverageCRS2D.getCoordinateSystem().getDimension() == 2);
            if (this.coverageCRS.getCoordinateSystem().getDimension() != 2) {
                MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)this.coverageCRS, (CoordinateReferenceSystem)this.coverageCRS2D);
                GeneralBounds bbox = CRS.transform((MathTransform)transform, (Bounds)this.coverageEnvelope);
                bbox.setCoordinateReferenceSystem(this.coverageCRS2D);
                this.coverageBBox = new ReferencedEnvelope((Bounds)bbox);
            } else {
                this.coverageBBox = new ReferencedEnvelope((Bounds)this.coverageEnvelope);
            }
        }

        private void setBaseParameters() {
            this.coverageEnvelope = RasterManager.this.getCoverageEnvelope().clone();
            this.coverageRasterArea = (GridEnvelope2D)RasterManager.this.getCoverageGridrange();
            this.coverageCRS = RasterManager.this.getCoverageCRS();
            this.coverageGridToWorld2D = (MathTransform2D)RasterManager.this.getRaster2Model();
            this.coverageFullResolution = new double[2];
            OverviewLevel highestLevel = RasterManager.this.overviewsController.resolutionsLevels.get(0);
            this.coverageFullResolution[0] = highestLevel.resolutionX;
            this.coverageFullResolution[1] = highestLevel.resolutionY;
        }
    }

    class DecimationController {
        void performDecimation(int imageIndex, ImageReadParam readParameters, RasterLayerRequest request) {
            int rasterHeight;
            int rasterWidth;
            Utilities.ensureNonNull((String)"readParameters", (Object)readParameters);
            Utilities.ensureNonNull((String)"request", (Object)request);
            double[] requestedRes = request.getRequestedResolution();
            if (requestedRes == null) {
                readParameters.setSourceSubsampling(1, 1, 0, 0);
                return;
            }
            double[] selectedRes = new double[2];
            OverviewLevel level = RasterManager.this.overviewsController.resolutionsLevels.get(imageIndex);
            selectedRes[0] = level.resolutionX;
            selectedRes[1] = level.resolutionY;
            if (imageIndex == 0) {
                rasterWidth = RasterManager.this.spatialDomainManager.coverageRasterArea.width;
                rasterHeight = RasterManager.this.spatialDomainManager.coverageRasterArea.height;
            } else {
                rasterWidth = (int)Math.round(RasterManager.this.spatialDomainManager.coverageBBox.getSpan(0) / selectedRes[0]);
                rasterHeight = (int)Math.round(RasterManager.this.spatialDomainManager.coverageBBox.getSpan(1) / selectedRes[1]);
            }
            ImageUtilities.setSubsamplingFactors((ImageReadParam)readParameters, (double[])requestedRes, (double[])selectedRes, (int)rasterWidth, (int)rasterHeight);
        }
    }

    class OverviewsController {
        final ArrayList<OverviewLevel> resolutionsLevels = new ArrayList();

        public OverviewsController() {
            this.resolutionsLevels.add(new OverviewLevel(1.0, RasterManager.this.highestRes[0], RasterManager.this.highestRes[1], 0));
            if (RasterManager.this.numberOfOverviews > 0) {
                for (int i = 0; i < RasterManager.this.overviewsResolution.length; ++i) {
                    this.resolutionsLevels.add(new OverviewLevel(RasterManager.this.overviewsResolution[i][0] / RasterManager.this.highestRes[0], RasterManager.this.overviewsResolution[i][0], RasterManager.this.overviewsResolution[i][1], i + 1));
                }
                Collections.sort(this.resolutionsLevels);
            }
        }

        int pickOverviewLevel(OverviewPolicy policy, RasterLayerRequest request) {
            double requestedScaleFactor;
            if (this.resolutionsLevels == null || this.resolutionsLevels.isEmpty()) {
                return 0;
            }
            OverviewLevel max = this.resolutionsLevels.get(0);
            double[] requestedRes = request.getRequestedResolution();
            if (requestedRes == null) {
                return 0;
            }
            double reqx = requestedRes[0];
            double reqy = requestedRes[1];
            double requestedScaleFactorX = reqx / max.resolutionX;
            double requestedScaleFactorY = reqy / max.resolutionY;
            boolean leastReduceAxis = !(requestedScaleFactorX <= requestedScaleFactorY);
            double d = requestedScaleFactor = !leastReduceAxis ? requestedScaleFactorX : requestedScaleFactorY;
            if (requestedScaleFactor <= 1.0) {
                return max.imageChoice;
            }
            OverviewLevel min = this.resolutionsLevels.get(this.resolutionsLevels.size() - 1);
            if (requestedScaleFactor >= min.scaleFactor) {
                return min.imageChoice;
            }
            OverviewLevel prev = max;
            int size = this.resolutionsLevels.size();
            for (int i = 1; i < size; ++i) {
                OverviewLevel curr = this.resolutionsLevels.get(i);
                if (curr.scaleFactor == requestedScaleFactor) {
                    return curr.imageChoice;
                }
                if (curr.scaleFactor > requestedScaleFactor || i == size - 1) {
                    if (policy == OverviewPolicy.QUALITY) {
                        return prev.imageChoice;
                    }
                    if (policy == OverviewPolicy.SPEED) {
                        return curr.imageChoice;
                    }
                    if (requestedScaleFactor - prev.scaleFactor < curr.scaleFactor - requestedScaleFactor) {
                        return prev.imageChoice;
                    }
                    return curr.imageChoice;
                }
                prev = curr;
            }
            return max.imageChoice;
        }
    }

    static class OverviewLevel
    implements Comparable<OverviewLevel> {
        double scaleFactor;
        double resolutionX;
        double resolutionY;
        int imageChoice;

        public OverviewLevel(double scaleFactor, double resolutionX, double resolutionY, int imageChoice) {
            this.scaleFactor = scaleFactor;
            this.resolutionX = resolutionX;
            this.resolutionY = resolutionY;
            this.imageChoice = imageChoice;
        }

        @Override
        public int compareTo(OverviewLevel other) {
            if (this.scaleFactor > other.scaleFactor) {
                return 1;
            }
            if (this.scaleFactor < other.scaleFactor) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return "OverviewLevel[Choice=" + this.imageChoice + ",scaleFactor=" + this.scaleFactor + "]";
        }

        public int hashCode() {
            int hash = Utilities.hash((int)this.imageChoice, (int)31);
            hash = Utilities.hash((double)this.resolutionX, (int)hash);
            hash = Utilities.hash((double)this.resolutionY, (int)hash);
            hash = Utilities.hash((double)this.scaleFactor, (int)hash);
            return hash;
        }
    }
}

