/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.jp2k;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverageio.jp2k.JP2KFormat;
import org.geotools.coverageio.jp2k.RasterManager;
import org.geotools.coverageio.jp2k.ReadType;
import org.geotools.data.DataSourceException;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.PixelTranslation;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.util.XRectangle2D;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

class RasterLayerRequest {
    private static final Logger LOGGER = Logging.getLogger(RasterLayerRequest.class);
    private ReadType readType = (Boolean)AbstractGridFormat.USE_JAI_IMAGEREAD.getDefaultValue() != false ? ReadType.JAI_IMAGEREAD : ReadType.DIRECT_READ;
    private BoundingBox requestedBBox;
    private BoundingBox cropBBox;
    private OverviewPolicy overviewPolicy;
    private Rectangle requestedRasterArea;
    private Rectangle destinationRasterArea;
    private boolean useMultithreading;
    private boolean empty;
    private Color inputTransparentColor = (Color)JP2KFormat.INPUT_TRANSPARENT_COLOR.getDefaultValue();
    private AffineTransform requestedGridToWorld;
    private double[] requestedResolution;
    private RasterManager rasterManager;
    private MathTransform destinationToSourceTransform;
    private GeneralEnvelope requestedBBOXInCoverageGeographicCRS;
    private GeneralEnvelope approximateRequestedBBoInNativeCRS;
    private Dimension tileDimensions;
    private SingleCRS requestCRS;

    public boolean isUseMultithreading() {
        return this.useMultithreading;
    }

    public RasterLayerRequest(GeneralParameterValue[] params, RasterManager rasterManager) throws DataSourceException {
        this.rasterManager = rasterManager;
        this.setDefaultParameterValues();
        if (params != null) {
            for (GeneralParameterValue gParam : params) {
                if (!(gParam instanceof ParameterValue)) continue;
                ParameterValue param = (ParameterValue)gParam;
                ReferenceIdentifier name = param.getDescriptor().getName();
                this.extractParameter(param, (Identifier)name);
            }
        }
        this.checkReadType();
        this.prepare();
    }

    private void setDefaultParameterValues() {
        ParameterValueGroup readParams = this.rasterManager.parent.getFormat().getReadParameters();
        if (readParams == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("No default values for the read parameters!");
            }
            return;
        }
        List parametersDescriptors = readParams.getDescriptor().descriptors();
        for (GeneralParameterDescriptor descriptor : parametersDescriptors) {
            String[] tilesSize;
            String suggestedTileSize;
            if (!(descriptor instanceof ParameterDescriptor)) continue;
            ParameterDescriptor desc = (ParameterDescriptor)descriptor;
            ReferenceIdentifier name = desc.getName();
            Object value = desc.getDefaultValue();
            if (descriptor.getName().equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) {
                if (value == null) continue;
                GridGeometry2D gg = (GridGeometry2D)value;
                this.requestedBBox = new ReferencedEnvelope((org.opengis.geometry.Envelope)gg.getEnvelope2D());
                this.requestedRasterArea = gg.getGridRange2D().getBounds();
                this.requestedGridToWorld = (AffineTransform)gg.getGridToCRS2D();
                continue;
            }
            if (name.equals(AbstractGridFormat.USE_JAI_IMAGEREAD.getName())) {
                if (value == null) continue;
                this.readType = (Boolean)value != false ? ReadType.JAI_IMAGEREAD : ReadType.DIRECT_READ;
                continue;
            }
            if (name.equals(JP2KFormat.USE_MULTITHREADING.getName())) {
                if (value == null) continue;
                this.useMultithreading = (Boolean)value;
                continue;
            }
            if (name.equals(AbstractGridFormat.OVERVIEW_POLICY.getName())) {
                if (value == null) continue;
                this.overviewPolicy = (OverviewPolicy)value;
                continue;
            }
            if (name.equals(JP2KFormat.INPUT_TRANSPARENT_COLOR.getName())) {
                if (value == null) continue;
                this.inputTransparentColor = (Color)value;
                this.inputTransparentColor = new Color(this.inputTransparentColor.getRed(), this.inputTransparentColor.getGreen(), this.inputTransparentColor.getBlue());
                continue;
            }
            if (!name.equals(JP2KFormat.SUGGESTED_TILE_SIZE.getName()) || (suggestedTileSize = (String)value) == null || suggestedTileSize.trim().length() <= 0 || !suggestedTileSize.contains(",") || (tilesSize = suggestedTileSize.split(",")).length != 2) continue;
            try {
                int tileWidth = Integer.valueOf(tilesSize[0].trim());
                int tileHeight = Integer.valueOf(tilesSize[1].trim());
                this.tileDimensions = new Dimension(tileWidth, tileHeight);
            }
            catch (NumberFormatException nfe) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, "Unable to parse suggested tile size parameter");
            }
        }
    }

    private void extractParameter(ParameterValue<?> param, Identifier name) {
        block13: {
            String[] tilesSize;
            String suggestedTileSize;
            if (name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) {
                Object value = param.getValue();
                if (value == null) {
                    return;
                }
                GridGeometry2D gg = (GridGeometry2D)param.getValue();
                if (gg == null) {
                    return;
                }
                this.requestedBBox = new ReferencedEnvelope((org.opengis.geometry.Envelope)gg.getEnvelope2D());
                this.requestedRasterArea = gg.getGridRange2D().getBounds();
                this.requestedGridToWorld = (AffineTransform)gg.getGridToCRS2D();
                return;
            }
            if (name.equals(JP2KFormat.USE_MULTITHREADING.getName())) {
                this.useMultithreading = param.booleanValue();
                return;
            }
            if (name.equals(AbstractGridFormat.USE_JAI_IMAGEREAD.getName())) {
                Object value = param.getValue();
                if (value == null) {
                    return;
                }
                this.readType = param.booleanValue() ? ReadType.JAI_IMAGEREAD : ReadType.DIRECT_READ;
                return;
            }
            if (name.equals(AbstractGridFormat.OVERVIEW_POLICY.getName())) {
                Object value = param.getValue();
                if (value == null) {
                    return;
                }
                this.overviewPolicy = (OverviewPolicy)param.getValue();
                return;
            }
            if (name.equals(JP2KFormat.INPUT_TRANSPARENT_COLOR.getName())) {
                Object value = param.getValue();
                if (value == null) {
                    return;
                }
                this.inputTransparentColor = (Color)param.getValue();
                this.inputTransparentColor = new Color(this.inputTransparentColor.getRed(), this.inputTransparentColor.getGreen(), this.inputTransparentColor.getBlue());
                return;
            }
            if (name.equals(JP2KFormat.SUGGESTED_TILE_SIZE.getName()) && (suggestedTileSize = (String)param.getValue()) != null && suggestedTileSize.trim().length() > 0 && suggestedTileSize.contains(",") && (tilesSize = suggestedTileSize.split(",")).length == 2) {
                try {
                    int tileWidth = Integer.valueOf(tilesSize[0].trim());
                    int tileHeight = Integer.valueOf(tilesSize[1].trim());
                    this.tileDimensions = new Dimension(tileWidth, tileHeight);
                }
                catch (NumberFormatException nfe) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block13;
                    LOGGER.log(Level.WARNING, "Unable to parse suggested tile size parameter");
                }
            }
        }
    }

    private void prepare() throws DataSourceException {
        if (this.requestedBBox == null) {
            this.requestedBBox = this.rasterManager.spatialDomainManager.coverageBBox;
            this.cropBBox = this.rasterManager.spatialDomainManager.coverageBBox;
            this.requestedRasterArea = (Rectangle)this.rasterManager.spatialDomainManager.coverageRasterArea.clone();
            this.destinationRasterArea = (Rectangle)this.rasterManager.spatialDomainManager.coverageRasterArea.clone();
            this.requestedResolution = (double[])this.rasterManager.spatialDomainManager.coverageFullResolution.clone();
            this.requestedGridToWorld = (AffineTransform)this.rasterManager.spatialDomainManager.coverageGridToWorld2D;
            return;
        }
        this.computeRequestSpatialElements();
    }

    private void inspectCoordinateReferenceSystems() throws DataSourceException {
        this.requestCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)this.requestedBBox.getCoordinateReferenceSystem());
        if (!CRS.equalsIgnoreMetadata((Object)this.requestCRS, (Object)this.rasterManager.spatialDomainManager.coverageCRS2D)) {
            try {
                this.destinationToSourceTransform = CRS.findMathTransform((CoordinateReferenceSystem)this.requestCRS, (CoordinateReferenceSystem)this.rasterManager.spatialDomainManager.coverageCRS2D, (boolean)true);
            }
            catch (FactoryException e) {
                throw new DataSourceException("Unable to inspect request CRS", (Throwable)e);
            }
        }
        if (this.destinationToSourceTransform != null && this.destinationToSourceTransform.isIdentity()) {
            this.destinationToSourceTransform = null;
        } else if (this.destinationToSourceTransform instanceof AffineTransform) {
            AffineTransform mutableTransform = (AffineTransform)this.requestedGridToWorld.clone();
            mutableTransform.preConcatenate((AffineTransform)this.destinationToSourceTransform);
            try {
                MathTransform tempTransform = PixelTranslation.translate((MathTransform)ProjectiveTransform.create((AffineTransform)this.requestedGridToWorld), (PixelInCell)PixelInCell.CELL_CENTER, (PixelInCell)PixelInCell.CELL_CORNER);
                this.requestedBBox = new ReferencedEnvelope((org.opengis.geometry.Envelope)CRS.transform((MathTransform)tempTransform, (org.opengis.geometry.Envelope)new GeneralEnvelope((Rectangle2D)this.requestedRasterArea)));
            }
            catch (MismatchedDimensionException e) {
                throw new DataSourceException("Unable to inspect request CRS", (Throwable)e);
            }
            catch (TransformException e) {
                throw new DataSourceException("Unable to inspect request CRS", (Throwable)e);
            }
            this.destinationToSourceTransform = null;
        }
    }

    private void checkReadType() {
        Object o;
        if (this.readType != ReadType.UNSPECIFIED) {
            if (this.readType == ReadType.JAI_IMAGEREAD && this.useMultithreading) {
                this.readType = ReadType.JAI_IMAGEREAD_MT;
            }
            return;
        }
        Hints hints = this.rasterManager.getHints();
        if (hints != null && (o = hints.get((Object)Hints.USE_JAI_IMAGEREAD)) != null) {
            this.readType = (ReadType)((Object)o);
            return;
        }
        this.readType = ReadType.getDefault();
    }

    private void computeCropRasterArea() throws DataSourceException {
        MathTransform2D requestedWorldToGrid;
        if (this.cropBBox == null) {
            this.destinationRasterArea = null;
            return;
        }
        try {
            requestedWorldToGrid = (MathTransform2D)PixelTranslation.translate((MathTransform)ProjectiveTransform.create((AffineTransform)this.requestedGridToWorld), (PixelInCell)PixelInCell.CELL_CENTER, (PixelInCell)PixelInCell.CELL_CORNER).inverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new DataSourceException((Throwable)e);
        }
        if (this.destinationToSourceTransform == null || this.destinationToSourceTransform.isIdentity()) {
            try {
                this.destinationRasterArea = new GeneralGridEnvelope((org.opengis.geometry.Envelope)CRS.transform((MathTransform)requestedWorldToGrid, (org.opengis.geometry.Envelope)new GeneralEnvelope((org.opengis.geometry.Envelope)this.cropBBox)), PixelInCell.CELL_CORNER, false).toRectangle();
            }
            catch (IllegalStateException e) {
                throw new DataSourceException((Throwable)e);
            }
            catch (TransformException e) {
                throw new DataSourceException((Throwable)e);
            }
        }
        try {
            GeneralEnvelope cropBBOXInRequestCRS = CRS.transform((org.opengis.geometry.Envelope)this.cropBBox, (CoordinateReferenceSystem)this.requestedBBox.getCoordinateReferenceSystem());
            cropBBOXInRequestCRS.setCoordinateReferenceSystem(this.requestedBBox.getCoordinateReferenceSystem());
            cropBBOXInRequestCRS.intersect((org.opengis.geometry.Envelope)this.requestedBBox);
            this.destinationRasterArea = new GeneralGridEnvelope((org.opengis.geometry.Envelope)CRS.transform((MathTransform)requestedWorldToGrid, (org.opengis.geometry.Envelope)cropBBOXInRequestCRS), PixelInCell.CELL_CORNER, false).toRectangle();
            XRectangle2D.intersect((Rectangle2D)this.destinationRasterArea, (Rectangle2D)this.requestedRasterArea, (Rectangle2D)this.destinationRasterArea);
        }
        catch (NoninvertibleTransformException e) {
            throw new DataSourceException((Throwable)e);
        }
        catch (TransformException e) {
            throw new DataSourceException((Throwable)e);
        }
        if (this.destinationRasterArea.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Requested envelope too small resulting in empty cropped raster region");
            }
            this.empty = true;
            return;
        }
    }

    private void computeRequestSpatialElements() throws DataSourceException {
        this.inspectCoordinateReferenceSystems();
        this.computeCropBBOX();
        if (this.empty || this.cropBBox != null && this.cropBBox.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "RequestedBBox empty or null");
            }
            this.empty = true;
            return;
        }
        this.computeCropRasterArea();
        if (this.empty || this.destinationRasterArea != null && this.destinationRasterArea.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "CropRasterArea empty or null");
            }
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer("Adjusted Requested Envelope = ").append(this.requestedBBox.toString()).append("\n").append("Requested raster dimension = ").append(this.requestedRasterArea.toString()).append("\n").append("Corresponding raster source region = ").append(this.requestedRasterArea.toString());
            LOGGER.log(Level.FINE, sb.toString());
        }
        this.computeRequestedResolution();
    }

    private void computeRequestedResolution() throws DataSourceException {
        try {
            if (this.requestedGridToWorld instanceof LinearTransform) {
                if (this.destinationToSourceTransform != null && !this.destinationToSourceTransform.isIdentity()) {
                    this.requestedResolution = null;
                    GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(this.destinationRasterArea), (org.opengis.geometry.Envelope)this.cropBBox);
                    AffineTransform tempTransform = geMapper.createAffineTransform();
                    this.requestedResolution = new double[]{XAffineTransform.getScaleX0((AffineTransform)tempTransform), XAffineTransform.getScaleY0((AffineTransform)tempTransform)};
                } else {
                    this.requestedResolution = new double[]{XAffineTransform.getScaleX0((AffineTransform)this.requestedGridToWorld), XAffineTransform.getScaleY0((AffineTransform)this.requestedGridToWorld)};
                }
            } else {
                throw new UnsupportedOperationException(Errors.format((int)205, (Object)this.requestedGridToWorld.toString()));
            }
            return;
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Unable to compute requested resolution", e);
            }
            LOGGER.log(Level.WARNING, "Unable to compute requested resolution, using highest available");
            this.requestedResolution = this.rasterManager.spatialDomainManager.coverageFullResolution;
            return;
        }
    }

    private void computeCropBBOX() throws DataSourceException {
        block17: {
            block16: {
                if (this.requestCRS == null) {
                    this.requestCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)this.requestedBBox.getCoordinateReferenceSystem());
                }
                try {
                    if (!CRS.equalsIgnoreMetadata((Object)this.requestCRS, (Object)this.rasterManager.spatialDomainManager.coverageCRS2D)) {
                        this.destinationToSourceTransform = CRS.findMathTransform((CoordinateReferenceSystem)this.requestCRS, (CoordinateReferenceSystem)this.rasterManager.spatialDomainManager.coverageCRS2D, (boolean)true);
                    }
                    if (this.destinationToSourceTransform != null && !this.destinationToSourceTransform.isIdentity()) {
                        GeneralEnvelope temp = CRS.transform((org.opengis.geometry.Envelope)this.requestedBBox, (CoordinateReferenceSystem)this.rasterManager.spatialDomainManager.coverageCRS2D);
                        temp.setCoordinateReferenceSystem(this.rasterManager.spatialDomainManager.coverageCRS2D);
                        this.cropBBox = new ReferencedEnvelope((org.opengis.geometry.Envelope)temp);
                    } else {
                        this.cropBBox = new ReferencedEnvelope(this.requestedBBox.getMinX(), this.requestedBBox.getMaxX(), this.requestedBBox.getMinY(), this.requestedBBox.getMaxY(), this.rasterManager.spatialDomainManager.coverageCRS2D);
                    }
                    if (!this.cropBBox.intersects((BoundingBox)this.rasterManager.spatialDomainManager.coverageBBox)) {
                        this.cropBBox = null;
                        this.empty = true;
                        return;
                    }
                    this.cropBBox = new ReferencedEnvelope((Envelope)((ReferencedEnvelope)this.cropBBox).intersection((Envelope)this.rasterManager.spatialDomainManager.coverageBBox), this.rasterManager.spatialDomainManager.coverageCRS2D);
                    return;
                }
                catch (TransformException te) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, te.getLocalizedMessage(), te);
                    }
                }
                catch (FactoryException fe) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block16;
                    LOGGER.log(Level.FINE, fe.getLocalizedMessage(), fe);
                }
            }
            try {
                if (!CRS.equalsIgnoreMetadata((Object)this.rasterManager.spatialDomainManager.coverageGeographicCRS2D, (Object)this.requestCRS)) {
                    CoordinateOperationFactory factory = CRS.getCoordinateOperationFactory((boolean)true);
                    CoordinateOperation op = factory.createOperation((CoordinateReferenceSystem)this.requestCRS, this.rasterManager.spatialDomainManager.coverageGeographicCRS2D);
                    this.requestedBBOXInCoverageGeographicCRS = CRS.transform((CoordinateOperation)op, (org.opengis.geometry.Envelope)this.requestedBBox);
                    this.requestedBBOXInCoverageGeographicCRS.setCoordinateReferenceSystem(this.rasterManager.spatialDomainManager.coverageGeographicCRS2D);
                }
                if (this.requestedBBOXInCoverageGeographicCRS == null) {
                    this.requestedBBOXInCoverageGeographicCRS = new GeneralEnvelope((CoordinateReferenceSystem)this.requestCRS);
                }
                if (!this.requestedBBOXInCoverageGeographicCRS.intersects((org.opengis.geometry.Envelope)this.rasterManager.spatialDomainManager.coverageGeographicBBox, true)) {
                    this.cropBBox = null;
                    this.empty = true;
                    return;
                }
                this.requestedBBOXInCoverageGeographicCRS.intersect((org.opengis.geometry.Envelope)this.rasterManager.spatialDomainManager.coverageGeographicBBox);
                this.requestedBBOXInCoverageGeographicCRS.setCoordinateReferenceSystem(this.rasterManager.spatialDomainManager.coverageGeographicCRS2D);
                this.approximateRequestedBBoInNativeCRS = CRS.transform((org.opengis.geometry.Envelope)this.requestedBBOXInCoverageGeographicCRS, (CoordinateReferenceSystem)this.rasterManager.spatialDomainManager.coverageCRS2D);
                this.approximateRequestedBBoInNativeCRS.setCoordinateReferenceSystem(this.rasterManager.spatialDomainManager.coverageCRS2D);
                this.cropBBox = new ReferencedEnvelope((org.opengis.geometry.Envelope)this.approximateRequestedBBoInNativeCRS);
            }
            catch (TransformException te) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, te.getLocalizedMessage(), te);
                }
            }
            catch (FactoryException fe) {
                if (!LOGGER.isLoggable(Level.FINE)) break block17;
                LOGGER.log(Level.FINE, fe.getLocalizedMessage(), fe);
            }
        }
        LOGGER.log(Level.INFO, "We did not manage to crop the requested envelope, we fall back onto loading the whole coverage.");
        this.cropBBox = null;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public BoundingBox getRequestedBBox() {
        return this.requestedBBox;
    }

    public OverviewPolicy getOverviewPolicy() {
        return this.overviewPolicy;
    }

    public Rectangle getRequestedRasterArea() {
        return (Rectangle)(this.requestedRasterArea != null ? this.requestedRasterArea.clone() : this.requestedRasterArea);
    }

    public double[] getRequestedResolution() {
        return this.requestedResolution != null ? (double[])this.requestedResolution.clone() : null;
    }

    public Color getInputTransparentColor() {
        return this.inputTransparentColor;
    }

    public ReadType getReadType() {
        return this.readType;
    }

    public Rectangle getDestinationRasterArea() {
        return this.destinationRasterArea;
    }

    public BoundingBox getCropBBox() {
        return this.cropBBox;
    }

    public AffineTransform getRequestedGridToWorld() {
        return this.requestedGridToWorld;
    }

    public Dimension getTileDimensions() {
        return this.tileDimensions;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RasterLayerRequest description: \n");
        builder.append("\tRequestedBBox=").append(this.requestedBBox).append("\n");
        builder.append("\tRequestedRasterArea=").append(this.requestedRasterArea).append("\n");
        builder.append("\tRequestedGridToWorld=").append(this.requestedGridToWorld).append("\n");
        builder.append("\tReadType=").append((Object)this.readType);
        return builder.toString();
    }
}

