/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.jp2k;

import it.geosolutions.imageio.stream.AccessibleStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.geotools.coverageio.jp2k.JP2KFormatFactory;
import org.geotools.data.DataSourceException;
import org.geotools.util.URLs;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

class Utils {
    static final IOFileFilter FILEFILTER = Utils.createFilter();
    static final Logger LOGGER = Logging.getLogger(Utils.class);

    Utils() {
    }

    static URL checkSource(Object source) throws MalformedURLException, DataSourceException {
        URL sourceURL = null;
        if (source instanceof URL) {
            sourceURL = (URL)source;
            source = URLs.urlToFile((URL)sourceURL);
        } else if (source instanceof String) {
            String tempSource = (String)source;
            File tempFile = new File(tempSource);
            if (!tempFile.exists()) {
                try {
                    sourceURL = new URL(tempSource);
                    source = URLs.urlToFile((URL)sourceURL);
                }
                catch (MalformedURLException e) {
                    sourceURL = null;
                    source = null;
                }
            } else {
                sourceURL = URLs.fileToUrl((File)tempFile);
                source = tempFile;
            }
        } else if (source instanceof AccessibleStream && ((AccessibleStream)source).getTarget() instanceof File) {
            File inputFile = (File)((AccessibleStream)source).getTarget();
            source = inputFile;
        }
        if (source instanceof File) {
            File sourceFile = (File)source;
            if (!sourceFile.isDirectory()) {
                sourceURL = ((File)source).toURI().toURL();
            }
        } else {
            sourceURL = null;
        }
        return sourceURL;
    }

    static ImageReader getReader(ImageInputStream inStream) {
        Utilities.ensureNonNull((String)"inStream", (Object)inStream);
        try {
            File file;
            if (inStream instanceof AccessibleStream && ((AccessibleStream)inStream).getTarget() instanceof File && FILEFILTER.accept(file = (File)((AccessibleStream)inStream).getTarget())) {
                return JP2KFormatFactory.getCachedSpi().createReaderInstance();
            }
            return null;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning(e.getLocalizedMessage());
            }
            return null;
        }
    }

    static ImageInputStream getInputStream(File file) throws IOException {
        ImageInputStream inStream = ImageIO.createImageInputStream(file);
        return inStream;
    }

    public static double bytes2double(byte[] bytes, int start) {
        int i = 0;
        int length = 8;
        int count = 0;
        byte[] tmp = new byte[8];
        for (i = start; i < start + 8; ++i) {
            tmp[count] = bytes[i];
            ++count;
        }
        long accum = 0L;
        i = 0;
        for (int shiftBy = 0; shiftBy < 64; shiftBy += 8) {
            accum |= (long)(tmp[i] & 0xFF) << shiftBy;
            ++i;
        }
        return Double.longBitsToDouble(accum);
    }

    public static long bytes2long(byte[] bytes, int start) {
        int i = 0;
        int length = 4;
        int count = 0;
        byte[] tmp = new byte[4];
        for (i = start; i < start + 4; ++i) {
            tmp[count] = bytes[i];
            ++count;
        }
        long accum = 0L;
        i = 0;
        for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
            accum |= (long)(tmp[i] & 0xFF) << shiftBy;
            ++i;
        }
        return accum;
    }

    private static IOFileFilter createFilter() {
        IOFileFilter fileFilter = Utils.includeFilters(FileFilterUtils.suffixFileFilter((String)"jp2"), FileFilterUtils.suffixFileFilter((String)"JP2"), FileFilterUtils.suffixFileFilter((String)"j2c"), FileFilterUtils.suffixFileFilter((String)"J2C"), FileFilterUtils.suffixFileFilter((String)"jpx"), FileFilterUtils.suffixFileFilter((String)"JPX"), FileFilterUtils.suffixFileFilter((String)"jp2k"), FileFilterUtils.suffixFileFilter((String)"JP2K"), FileFilterUtils.nameFileFilter((String)"jpeg2000"));
        return fileFilter;
    }

    static IOFileFilter excludeFilters(IOFileFilter inputFilter, IOFileFilter ... filters) {
        IOFileFilter retFilter = inputFilter;
        for (IOFileFilter filter : filters) {
            retFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{retFilter, FileFilterUtils.notFileFilter((IOFileFilter)filter)});
        }
        return retFilter;
    }

    static IOFileFilter includeFilters(IOFileFilter inputFilter, IOFileFilter ... filters) {
        IOFileFilter retFilter = inputFilter;
        for (IOFileFilter filter : filters) {
            retFilter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{retFilter, filter});
        }
        return retFilter;
    }
}

