/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.ArrayList;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.NativeFilter;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public abstract class JDBCNativeFilterOnlineTest
extends JDBCTestSupport {
    protected final FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);

    @Test
    public void testNativeFilterExecution() throws Exception {
        BBOX boundingBoxFilter = this.filterFactory.bbox(this.tname("location"), -5.0, -5.0, 5.0, 5.0, DefaultGeographicCRS.WGS84.toString());
        And filter = this.filterFactory.and((Filter)boundingBoxFilter, (Filter)this.getNativeFilter());
        ContentFeatureSource featureSource = this.dataStore.getFeatureSource(this.tname("gt_jdbc_test_measurements"));
        MatcherAssert.assertThat((Object)featureSource, (Matcher)CoreMatchers.notNullValue());
        try (SimpleFeatureIterator iterator = featureSource.getFeatures((Filter)filter).features();){
            ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
            while (iterator.hasNext()) {
                features.add((SimpleFeature)iterator.next());
            }
            MatcherAssert.assertThat((Object)features.size(), (Matcher)CoreMatchers.is((Object)1));
            MatcherAssert.assertThat((Object)((SimpleFeature)features.get(0)).getAttribute(this.tname("code")), (Matcher)CoreMatchers.is((Object)"#2"));
        }
    }

    protected abstract NativeFilter getNativeFilter();
}

