/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.geotools.api.data.Join;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.jdbc.JDBCJoinTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.junit.Assert;
import org.junit.Test;

public abstract class JDBCJoinOnlineTest
extends JDBCTestSupport {
    public JDBCJoinOnlineTest() {
        super(1.0E-6);
    }

    @Override
    protected abstract JDBCJoinTestSetup createTestSetup();

    @Test
    public void testSimpleJoin() throws Exception {
        this.doTestSimpleJoin(false);
        this.doTestSimpleJoin(true);
    }

    @Test
    public void testJoinSchema() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        Query q = new Query(this.tname("ft1"));
        Join join = new Join(this.tname("ftjoin"), (Filter)ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.property(this.aname("name")), true));
        join.setAlias("b");
        q.getJoins().add(join);
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
        SimpleFeatureType schema = (SimpleFeatureType)features.getSchema();
        AttributeDescriptor ad = schema.getDescriptor("b");
        Assert.assertNotNull((Object)ad);
        Assert.assertEquals(SimpleFeature.class, (Object)ad.getType().getBinding());
        SimpleFeatureType joinedSchema = (SimpleFeatureType)ad.getUserData().get("JoinedFeatureType");
        Assert.assertEquals((Object)this.dataStore.getSchema(this.tname("ftjoin")), (Object)joinedSchema);
    }

    void doTestSimpleJoin(boolean exposePrimaryKeys) throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(exposePrimaryKeys);
        try (SimpleFeatureIterator ita = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures().features();
             SimpleFeatureIterator itb = this.dataStore.getFeatureSource(this.tname("ftjoin")).getFeatures().features();){
            FilterFactory ff = this.dataStore.getFilterFactory();
            Query q = new Query(this.tname("ft1"));
            q.getJoins().add(new Join(this.tname("ftjoin"), (Filter)ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.property(this.aname("name")), true)));
            ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
            Assert.assertEquals((long)this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q).size(), (long)features.size());
            try (SimpleFeatureIterator it = features.features();){
                Assert.assertTrue((it.hasNext() && ita.hasNext() && itb.hasNext() ? 1 : 0) != 0);
                while (it.hasNext()) {
                    int i;
                    SimpleFeature f = (SimpleFeature)it.next();
                    Assert.assertEquals((long)(5 + (exposePrimaryKeys ? 1 : 0)), (long)f.getAttributeCount());
                    SimpleFeature g = (SimpleFeature)f.getAttribute(this.tname("ftjoin"));
                    SimpleFeature a = (SimpleFeature)ita.next();
                    SimpleFeature b = (SimpleFeature)itb.next();
                    for (i = 0; i < a.getAttributeCount(); ++i) {
                        this.assertAttributeValuesEqual(a.getAttribute(i), f.getAttribute(i));
                    }
                    for (i = 0; i < b.getAttributeCount(); ++i) {
                        this.assertAttributeValuesEqual(b.getAttribute(i), g.getAttribute(i));
                    }
                }
            }
        }
    }

    @Test
    public void testSimpleJoinOnPrimaryKey() throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(true);
        try (SimpleFeatureIterator ita = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures().features();
             SimpleFeatureIterator itb = this.dataStore.getFeatureSource(this.tname("ftjoin")).getFeatures().features();){
            FilterFactory ff = this.dataStore.getFilterFactory();
            Query q = new Query(this.tname("ft1"));
            Join join = new Join(this.tname("ftjoin"), (Filter)ff.equal((Expression)ff.property(this.aname("id")), (Expression)ff.property(this.aname("ftjoin.id")), true));
            join.setAlias(this.tname("ftjoin"));
            q.getJoins().add(join);
            ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
            Assert.assertEquals((long)this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q).size(), (long)features.size());
            try (SimpleFeatureIterator it = features.features();){
                Assert.assertTrue((it.hasNext() && ita.hasNext() && itb.hasNext() ? 1 : 0) != 0);
                while (it.hasNext()) {
                    int i;
                    SimpleFeature f = (SimpleFeature)it.next();
                    Assert.assertEquals((long)6L, (long)f.getAttributeCount());
                    SimpleFeature g = (SimpleFeature)f.getAttribute(this.tname("ftjoin"));
                    SimpleFeature a = (SimpleFeature)ita.next();
                    SimpleFeature b = (SimpleFeature)itb.next();
                    for (i = 0; i < a.getAttributeCount(); ++i) {
                        this.assertAttributeValuesEqual(a.getAttribute(i), f.getAttribute(i));
                    }
                    for (i = 0; i < b.getAttributeCount(); ++i) {
                        this.assertAttributeValuesEqual(b.getAttribute(i), g.getAttribute(i));
                    }
                }
            }
        }
    }

    @Test
    public void testSimpleJoinInvertedAliases() throws Exception {
        this.doTestSimpleJoinInvertedAliases(false);
        this.doTestSimpleJoinInvertedAliases(true);
    }

    void doTestSimpleJoinInvertedAliases(boolean exposePrimaryKeys) throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(exposePrimaryKeys);
        try (SimpleFeatureIterator ita = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures().features();
             SimpleFeatureIterator itb = this.dataStore.getFeatureSource(this.tname("ftjoin")).getFeatures().features();){
            FilterFactory ff = this.dataStore.getFilterFactory();
            Query q = new Query(this.tname("ft1"));
            q.setAlias("b");
            Join join = new Join(this.tname("ftjoin"), (Filter)ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.property(this.aname("name")), true));
            join.setAlias("a");
            q.getJoins().add(join);
            ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
            Assert.assertEquals((long)this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q).size(), (long)features.size());
            try (SimpleFeatureIterator it = features.features();){
                Assert.assertTrue((it.hasNext() && ita.hasNext() && itb.hasNext() ? 1 : 0) != 0);
                while (it.hasNext()) {
                    int i;
                    SimpleFeature f = (SimpleFeature)it.next();
                    Assert.assertEquals((long)(5 + (exposePrimaryKeys ? 1 : 0)), (long)f.getAttributeCount());
                    SimpleFeature g = (SimpleFeature)f.getAttribute("a");
                    SimpleFeature a = (SimpleFeature)ita.next();
                    SimpleFeature b = (SimpleFeature)itb.next();
                    for (i = 0; i < a.getAttributeCount(); ++i) {
                        this.assertAttributeValuesEqual(a.getAttribute(i), f.getAttribute(i));
                    }
                    for (i = 0; i < b.getAttributeCount(); ++i) {
                        this.assertAttributeValuesEqual(b.getAttribute(i), g.getAttribute(i));
                    }
                }
            }
        }
    }

    @Test
    public void testSimpleJoinWithFilter() throws Exception {
        this.doTestSimpleJoinWithFilter(false);
        this.doTestSimpleJoinWithFilter(true);
    }

    void doTestSimpleJoinWithFilter(boolean exposePrimaryKeys) throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(exposePrimaryKeys);
        FilterFactory ff = this.dataStore.getFilterFactory();
        Query q = new Query(this.tname("ft1"));
        q.getJoins().add(new Join(this.tname("ftjoin"), (Filter)ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.property(this.aname("name")), true)));
        q.setFilter((Filter)ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"two"), true));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
        Assert.assertEquals((long)1L, (long)features.size());
        try (SimpleFeatureIterator it = features.features();){
            SimpleFeature f = (SimpleFeature)it.next();
            Assert.assertEquals((long)(5 + (exposePrimaryKeys ? 1 : 0)), (long)f.getAttributeCount());
            Assert.assertEquals((long)2L, (long)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
            Assert.assertEquals((Object)"two", (Object)f.getAttribute(this.aname("stringProperty")));
            SimpleFeature g = (SimpleFeature)f.getAttribute(this.aname("ftjoin"));
            Assert.assertEquals((long)(3 + (exposePrimaryKeys ? 1 : 0)), (long)g.getAttributeCount());
            if (exposePrimaryKeys) {
                Assert.assertEquals((long)2L, (long)((Number)g.getAttribute(this.aname("id"))).intValue());
            }
            Assert.assertEquals((Object)"two", (Object)g.getAttribute(this.aname("name")));
        }
    }

    @Test
    public void testSimpleJoinWithFilterNoProperties() throws Exception {
        this.doTestSimpleJoinWithFilterNoProperties(false);
        this.doTestSimpleJoinWithFilterNoProperties(true);
    }

    void doTestSimpleJoinWithFilterNoProperties(boolean exposePrimaryKeys) throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(exposePrimaryKeys);
        FilterFactory ff = this.dataStore.getFilterFactory();
        Query q = new Query(this.tname("ft1"));
        Join j = new Join(this.tname("ftjoin"), (Filter)ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.property(this.aname("name")), true));
        j.setProperties(Query.NO_PROPERTIES);
        q.getJoins().add(j);
        q.setFilter((Filter)ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"two"), true));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
        Assert.assertEquals((long)1L, (long)features.size());
        try (SimpleFeatureIterator it = features.features();){
            SimpleFeature f = (SimpleFeature)it.next();
            Assert.assertEquals((long)(5 + (exposePrimaryKeys ? 1 : 0)), (long)f.getAttributeCount());
            Assert.assertEquals((long)2L, (long)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
            Assert.assertEquals((Object)"two", (Object)f.getAttribute(this.aname("stringProperty")));
            SimpleFeature g = (SimpleFeature)f.getAttribute(this.aname("ftjoin"));
            Assert.assertEquals((long)0L, (long)g.getAttributeCount());
        }
    }

    @Test
    public void testSimpleJoinWithFilterCount() throws Exception {
        this.doTestSimpleJoinWithFilterCount(false);
        this.doTestSimpleJoinWithFilterCount(true);
    }

    void doTestSimpleJoinWithFilterCount(boolean exposePrimaryKeys) throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(exposePrimaryKeys);
        FilterFactory ff = this.dataStore.getFilterFactory();
        Query q = new Query(this.tname("ft1"));
        Join j = new Join(this.tname("ftjoin"), (Filter)ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.property(this.aname("name")), true));
        j.filter((Filter)ff.greater((Expression)ff.property(this.aname("join1intProperty")), (Expression)ff.literal(1)));
        q.getJoins().add(j);
        q.setFilter((Filter)ff.less((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(3)));
        Assert.assertEquals((long)1L, (long)this.dataStore.getFeatureSource(this.tname("ft1")).getCount(q));
    }

    @Test
    public void testSimpleJoinWithPostFilter() throws Exception {
        this.doTestSimpleJoinWithPostFilter(false);
        this.doTestSimpleJoinWithPostFilter(true);
    }

    void doTestSimpleJoinWithPostFilter(boolean exposePrimaryKeys) throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(exposePrimaryKeys);
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo j = ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.property(this.aname("name")), true);
        Query q = new Query(this.tname("ft1"));
        q.getJoins().add(new Join(this.tname("ftjoin"), (Filter)j));
        q.setFilter((Filter)ff.equal((Expression)ff.function("__equals", new Expression[]{ff.property(this.aname("stringProperty")), ff.literal((Object)"one")}), (Expression)ff.literal(true), true));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
        Assert.assertEquals((long)1L, (long)features.size());
        q = new Query(this.tname("ft1"));
        Join join = new Join(this.tname("ftjoin"), (Filter)j);
        join.filter((Filter)ff.equal((Expression)ff.function("__equals", new Expression[]{ff.property(this.aname("name")), ff.literal((Object)"one")}), (Expression)ff.literal(true), true));
        q.getJoins().add(join);
        features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
        Assert.assertEquals((long)1L, (long)features.size());
    }

    @Test
    public void testSimpleJoinWithPostFilterNoProperties() throws Exception {
        this.doTestSimpleJoinWithPostFilterNoProperties(false);
        this.doTestSimpleJoinWithPostFilterNoProperties(true);
    }

    void doTestSimpleJoinWithPostFilterNoProperties(boolean exposePrimaryKeys) throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(exposePrimaryKeys);
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo j = ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.property(this.aname("name")), true);
        Query q = new Query(this.tname("ft1"));
        Join join = new Join(this.tname("ftjoin"), (Filter)j);
        join.setProperties(Query.NO_PROPERTIES);
        q.getJoins().add(join);
        q.setFilter((Filter)ff.equal((Expression)ff.function("__equals", new Expression[]{ff.property(this.aname("stringProperty")), ff.literal((Object)"one")}), (Expression)ff.literal(true), true));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
        Assert.assertEquals((long)1L, (long)features.size());
        q = new Query(this.tname("ft1"));
        join = new Join(this.tname("ftjoin"), (Filter)j);
        join.setProperties(Query.NO_PROPERTIES);
        join.filter((Filter)ff.equal((Expression)ff.function("__equals", new Expression[]{ff.property(this.aname("name")), ff.literal((Object)"one")}), (Expression)ff.literal(true), true));
        q.getJoins().add(join);
        features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
        Assert.assertEquals((long)1L, (long)features.size());
    }

    @Test
    public void testSimpleJoinWithSort() throws Exception {
        this.doTestSimpleJoinWithSort(false);
        this.doTestSimpleJoinWithSort(true);
    }

    void doTestSimpleJoinWithSort(boolean exposePrimaryKeys) throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(exposePrimaryKeys);
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo j = ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.property(this.aname("name")), true);
        Query q = new Query(this.tname("ft1"));
        q.getJoins().add(new Join(this.tname("ftjoin"), (Filter)j));
        q.setSortBy(new SortBy[]{ff.sort(this.aname("intProperty"), SortOrder.DESCENDING)});
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
        try (SimpleFeatureIterator it = features.features();){
            Assert.assertTrue((boolean)it.hasNext());
            Assert.assertEquals((Object)"two", (Object)((SimpleFeature)it.next()).getAttribute(this.aname("stringProperty")));
            Assert.assertTrue((boolean)it.hasNext());
            Assert.assertEquals((Object)"one", (Object)((SimpleFeature)it.next()).getAttribute(this.aname("stringProperty")));
            Assert.assertTrue((boolean)it.hasNext());
            Assert.assertEquals((Object)"zero", (Object)((SimpleFeature)it.next()).getAttribute(this.aname("stringProperty")));
        }
    }

    @Test
    public void testSimpleJoinWithLimitOffset() throws Exception {
        this.doTestSimpleJoinWithLimitOffset(false);
        this.doTestSimpleJoinWithLimitOffset(true);
    }

    void doTestSimpleJoinWithLimitOffset(boolean exposePrimaryKeys) throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(exposePrimaryKeys);
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo j = ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.property(this.aname("name")), true);
        Query q = new Query(this.tname("ft1"));
        q.getJoins().add(new Join(this.tname("ftjoin"), (Filter)j));
        q.setFilter((Filter)ff.greater((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(0)));
        q.setStartIndex(Integer.valueOf(1));
        q.setSortBy(new SortBy[]{ff.sort(this.aname("intProperty"), SortOrder.ASCENDING)});
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
        Assert.assertEquals((long)1L, (long)features.size());
        try (SimpleFeatureIterator it = features.features();){
            Assert.assertTrue((boolean)it.hasNext());
            SimpleFeature f = (SimpleFeature)it.next();
            Assert.assertEquals((Object)"two", (Object)f.getAttribute(this.aname("stringProperty")));
            SimpleFeature g = (SimpleFeature)f.getAttribute(this.aname("ftjoin"));
            Assert.assertEquals((Object)"two", (Object)g.getAttribute(this.aname("name")));
        }
    }

    @Test
    public void testSelfJoin() throws Exception {
        this.doTestSelfJoin(false);
        this.doTestSelfJoin(true);
    }

    public void doTestSelfJoin(boolean exposePrimaryKeys) throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(exposePrimaryKeys);
        FilterFactory ff = this.dataStore.getFilterFactory();
        Query q = new Query(this.tname("ft1"));
        q.getJoins().add(new Join(this.tname("ft1"), (Filter)ff.equal((Expression)ff.property(this.aname("intProperty")), (Expression)ff.property(this.aname("foo.intProperty")), true)).alias(this.aname("foo")));
        q.setFilter((Filter)ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"two"), true));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
        Assert.assertEquals((long)1L, (long)features.size());
        try (SimpleFeatureIterator it = features.features();){
            Assert.assertTrue((boolean)it.hasNext());
            SimpleFeature f = (SimpleFeature)it.next();
            Assert.assertEquals((long)(5 + (exposePrimaryKeys ? 1 : 0)), (long)f.getAttributeCount());
            Assert.assertEquals((long)2L, (long)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
            Assert.assertEquals((Object)"two", (Object)f.getAttribute(this.aname("stringProperty")));
            SimpleFeature g = (SimpleFeature)f.getAttribute(this.aname("foo"));
            Assert.assertEquals((long)(4 + (exposePrimaryKeys ? 1 : 0)), (long)g.getAttributeCount());
            Assert.assertEquals((long)2L, (long)((Number)g.getAttribute(this.aname("intProperty"))).intValue());
            Assert.assertEquals((Object)"two", (Object)g.getAttribute(this.aname("stringProperty")));
        }
    }

    @Test
    public void testSpatialJoin() throws Exception {
        this.doTestSpatialJoin(true);
    }

    void doTestSpatialJoin(boolean exposePrimaryKeys) throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(exposePrimaryKeys);
        FilterFactory ff = this.dataStore.getFilterFactory();
        Query q = new Query(this.tname("ft1"));
        q.setPropertyNames(Arrays.asList(this.aname("geometry"), this.aname("intProperty")));
        q.setSortBy(new SortBy[]{ff.sort(this.aname("intProperty"), SortOrder.ASCENDING)});
        q.getJoins().add(new Join(this.tname("ftjoin"), (Filter)ff.contains((Expression)ff.property(this.aname("geom")), (Expression)ff.property(this.aname("geometry")))));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
        Assert.assertEquals((long)6L, (long)features.size());
        try (SimpleFeatureIterator it = features.features();){
            HashSet<String> s = new HashSet<String>(Arrays.asList("zero", "one", "two"));
            Assert.assertTrue((boolean)it.hasNext());
            SimpleFeature f = (SimpleFeature)it.next();
            Assert.assertEquals((long)0L, (long)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
            s.remove(((SimpleFeature)f.getAttribute(this.tname("ftjoin"))).getAttribute(this.aname("name")));
            Assert.assertTrue((boolean)it.hasNext());
            f = (SimpleFeature)it.next();
            Assert.assertEquals((long)0L, (long)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
            s.remove(((SimpleFeature)f.getAttribute(this.tname("ftjoin"))).getAttribute(this.aname("name")));
            Assert.assertTrue((boolean)it.hasNext());
            f = (SimpleFeature)it.next();
            Assert.assertEquals((long)0L, (long)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
            s.remove(((SimpleFeature)f.getAttribute(this.tname("ftjoin"))).getAttribute(this.aname("name")));
            Assert.assertEquals((long)0L, (long)s.size());
            s = new HashSet<String>(Arrays.asList("one", "two"));
            Assert.assertTrue((boolean)it.hasNext());
            f = (SimpleFeature)it.next();
            Assert.assertEquals((long)1L, (long)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
            s.remove(((SimpleFeature)f.getAttribute(this.tname("ftjoin"))).getAttribute(this.aname("name")));
            Assert.assertTrue((boolean)it.hasNext());
            f = (SimpleFeature)it.next();
            Assert.assertEquals((long)1L, (long)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
            s.remove(((SimpleFeature)f.getAttribute(this.tname("ftjoin"))).getAttribute(this.aname("name")));
            Assert.assertEquals((long)0L, (long)s.size());
            Assert.assertTrue((boolean)it.hasNext());
            f = (SimpleFeature)it.next();
            Assert.assertEquals((long)2L, (long)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
            Assert.assertEquals((Object)"two", (Object)((SimpleFeature)f.getAttribute(this.tname("ftjoin"))).getAttribute(this.aname("name")));
            Assert.assertFalse((boolean)it.hasNext());
        }
    }

    @Test
    public void testOuterJoin() throws Exception {
        this.doTestOuterJoin(false);
        this.doTestOuterJoin(true);
    }

    void doTestOuterJoin(boolean exposePrimaryKeys) throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(exposePrimaryKeys);
        FilterFactory ff = this.dataStore.getFilterFactory();
        Query q = new Query(this.tname("ftjoin"));
        q.getJoins().add(new Join(this.tname("ft1"), (Filter)ff.equal((Expression)ff.property(this.aname("name")), (Expression)ff.property(this.aname("stringProperty")), true)).type(Join.Type.OUTER));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ftjoin")).getFeatures(q);
        Assert.assertEquals((long)this.dataStore.getFeatureSource(this.tname("ftjoin")).getFeatures(q).size(), (long)features.size());
        try (SimpleFeatureIterator it = features.features();){
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                Assert.assertEquals((long)(4 + (exposePrimaryKeys ? 1 : 0)), (long)f.getAttributeCount());
                SimpleFeature g = (SimpleFeature)f.getAttribute(this.tname("ft1"));
                if ("three".equals(f.getAttribute(this.aname("name")))) {
                    Assert.assertNull((Object)g);
                    continue;
                }
                Assert.assertNotNull((Object)g);
            }
        }
    }

    @Test
    public void testJoinMoreThanTwo() throws Exception {
        this.doJoinMoreThanTwo(false);
        this.doJoinMoreThanTwo(true);
    }

    void doJoinMoreThanTwo(boolean exposePrimaryKeys) throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(exposePrimaryKeys);
        FilterFactory ff = this.dataStore.getFilterFactory();
        Query q = new Query(this.tname("ftjoin"));
        q.getJoins().add(new Join(this.tname("ft1"), (Filter)ff.equal((Expression)ff.property(this.aname("name")), (Expression)ff.property(this.aname("stringProperty")), true)));
        q.getJoins().add(new Join(this.tname("ftjoin2"), (Filter)ff.equal((Expression)ff.property(this.aname("join2intProperty")), (Expression)ff.property(this.aname("join1intProperty")), true)));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ftjoin")).getFeatures(q);
        Assert.assertEquals((long)3L, (long)features.size());
        try (SimpleFeatureIterator it = features.features();){
            String[] ft1StringProp = new String[]{"zero", "one", "two"};
            String[] ftjoin2StringProp = new String[]{"2nd zero", "2nd one", "2nd two"};
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                Assert.assertEquals((long)(5 + (exposePrimaryKeys ? 1 : 0)), (long)f.getAttributeCount());
                Number nmb = (Number)f.getAttribute(this.aname("join1intProperty"));
                Integer idx = nmb.intValue();
                Assert.assertTrue((idx < 3 ? 1 : 0) != 0);
                SimpleFeature g = (SimpleFeature)f.getAttribute(this.tname("ft1"));
                Assert.assertNotNull((Object)g);
                Assert.assertEquals((Object)ft1StringProp[idx], (Object)g.getAttribute(this.aname("stringProperty")));
                g = (SimpleFeature)f.getAttribute(this.tname("ftjoin2"));
                Assert.assertNotNull((Object)g);
                Assert.assertEquals((Object)ftjoin2StringProp[idx], (Object)g.getAttribute(this.aname("stringProperty2")));
            }
        }
    }

    @Test
    public void testJoinWithFidFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        Query q = new Query(this.tname("ft1"));
        Join join = new Join(this.tname("ftjoin"), (Filter)ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.property(this.aname("name")), true));
        join.setAlias("b");
        q.getJoins().add(join);
        FeatureId id = ff.featureId(this.tname("ft1") + ".2");
        q.setFilter((Filter)ff.id(Collections.singleton(id)));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
        Assert.assertEquals((long)1L, (long)features.size());
        SimpleFeature f = (SimpleFeature)DataUtilities.first((FeatureCollection)features);
        Assert.assertEquals((Object)id.getID(), (Object)f.getID());
        SimpleFeature b = (SimpleFeature)f.getAttribute("b");
        Assert.assertEquals((Object)(this.tname("ftjoin") + ".2"), (Object)b.getID());
    }
}

