/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JDBCPrimaryKeyFinderTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.NonIncrementingPrimaryKeyColumn;
import org.geotools.jdbc.SequencedPrimaryKeyColumn;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;

public abstract class JDBCPrimaryKeyFinderOnlineTest
extends JDBCTestSupport {
    @Override
    protected abstract JDBCPrimaryKeyFinderTestSetup createTestSetup();

    @Override
    protected void connect() throws Exception {
        super.connect();
        if (this.setup.canResetSchema()) {
            this.dataStore.setDatabaseSchema(null);
        }
    }

    @Test
    public void testSequencedPrimaryKey() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("seqtable"));
        Assert.assertEquals((long)1L, (long)fs.getPrimaryKey().getColumns().size());
        Assert.assertTrue((boolean)(fs.getPrimaryKey().getColumns().get(0) instanceof SequencedPrimaryKeyColumn));
        ContentFeatureCollection features = fs.getFeatures();
        this.assertPrimaryKeyValues((SimpleFeatureCollection)features, 3);
        this.addFeature(fs.getSchema(), fs);
        this.assertPrimaryKeyValues((SimpleFeatureCollection)features, 4);
    }

    @Test
    public void testAssignedSinglePKeyView() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("assignedsinglepk"));
        Assert.assertEquals((long)1L, (long)fs.getPrimaryKey().getColumns().size());
        Assert.assertTrue((boolean)(fs.getPrimaryKey().getColumns().get(0) instanceof NonIncrementingPrimaryKeyColumn));
        ContentFeatureCollection features = fs.getFeatures();
        this.assertPrimaryKeyValues((SimpleFeatureCollection)features, 3);
    }

    @Test
    public void testAssignedMultiPKeyView() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("assignedmultipk"));
        Assert.assertEquals((long)2L, (long)fs.getPrimaryKey().getColumns().size());
        Assert.assertTrue((boolean)(fs.getPrimaryKey().getColumns().get(0) instanceof NonIncrementingPrimaryKeyColumn));
        Assert.assertTrue((boolean)(fs.getPrimaryKey().getColumns().get(1) instanceof NonIncrementingPrimaryKeyColumn));
        try (SimpleFeatureIterator i = fs.getFeatures().features();){
            int j = 1;
            while (i.hasNext()) {
                SimpleFeature f = (SimpleFeature)i.next();
                Assert.assertEquals((Object)(this.tname("assignedmultipk") + "." + j + "." + (j + 1)), (Object)f.getID());
                ++j;
            }
        }
    }

    protected void addFeature(SimpleFeatureType featureType, JDBCFeatureStore features) throws Exception {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(featureType);
        b.add((Object)"four");
        b.add((Object)new GeometryFactory().createPoint(new Coordinate(4.0, 4.0)));
        SimpleFeature f = b.buildFeature(null);
        features.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)f));
        Assert.assertTrue((boolean)((String)f.getUserData().get("fid")).matches(this.tname(featureType.getTypeName()) + ".4(\\..*)?"));
    }

    protected void assertPrimaryKeyValues(final SimpleFeatureCollection features, int count) throws Exception {
        this.assertFeatureIterator(1, count, features.features(), new JDBCTestSupport.SimpleFeatureAssertion(){

            @Override
            public int toIndex(SimpleFeature feature) {
                return Integer.parseInt(feature.getIdentifier().getID().split("\\.", 2)[1]);
            }

            @Override
            public void check(int index, SimpleFeature feature) {
                Assert.assertEquals((Object)(JDBCPrimaryKeyFinderOnlineTest.this.tname(((SimpleFeatureType)features.getSchema()).getName().getLocalPart()) + "." + index), (Object)feature.getIdentifier().getID());
            }
        });
    }
}

