/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.JDBCJNDIDataStoreFactory;
import org.geotools.jdbc.JDBCJNDITestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.SQLDialect;
import org.junit.Assert;
import org.junit.Test;

public abstract class JDBCJNDIDataSourceOnlineTest
extends JDBCTestSupport {
    @Override
    protected abstract JDBCJNDITestSetup createTestSetup();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJNDIDataSource() throws Exception {
        ((JDBCJNDITestSetup)this.setup).setupJNDIEnvironment(this.getDataStoreFactory());
        HashMap<String, String> params = new HashMap<String, String>();
        String dbtype = this.setup.createDataStoreFactory().getDatabaseID();
        params.put(JDBCDataStoreFactory.NAMESPACE.key, "http://www.geotools.org/test");
        params.put(JDBCDataStoreFactory.DBTYPE.key, dbtype);
        params.put(JDBCJNDIDataStoreFactory.JNDI_REFNAME.key, "ds");
        JDBCDataStore dataStore = null;
        try {
            dataStore = (JDBCDataStore)DataStoreFinder.getDataStore(params);
            try (Connection con = dataStore.getDataSource().getConnection();){
                Assert.assertNotNull((Object)con);
                Assert.assertFalse((boolean)con.isClosed());
            }
        }
        finally {
            if (dataStore != null) {
                dataStore.dispose();
            }
        }
    }

    @Test
    public void testExtraParams() {
        List<String> baseParams = this.getBaseParams();
        List<String> standardParams = this.getParamKeys(this.getDataStoreFactory());
        standardParams.remove(JDBCDataStoreFactory.VALIDATECONN.key);
        standardParams.remove(JDBCDataStoreFactory.MAX_OPEN_PREPARED_STATEMENTS.key);
        standardParams.removeAll(baseParams);
        List<String> baseJndiParams = this.getBaseJNDIParams();
        List<String> jndiParams = this.getParamKeys((JDBCDataStoreFactory)this.getJNDIStoreFactory());
        Assert.assertTrue((boolean)jndiParams.contains(JDBCDataStoreFactory.FETCHSIZE.key));
        Assert.assertTrue((boolean)jndiParams.contains(JDBCDataStoreFactory.BATCH_INSERT_SIZE.key));
        jndiParams.removeAll(baseJndiParams);
        Assert.assertEquals(standardParams, jndiParams);
    }

    protected abstract JDBCJNDIDataStoreFactory getJNDIStoreFactory();

    protected abstract JDBCDataStoreFactory getDataStoreFactory();

    protected List<String> getBaseParams() {
        JDBCDataStoreFactory factory = this.getBaseFactory();
        return this.getParamKeys(factory);
    }

    protected JDBCDataStoreFactory getBaseFactory() {
        JDBCDataStoreFactory factory = new JDBCDataStoreFactory(){

            public String getDescription() {
                return null;
            }

            protected String getValidationQuery() {
                return null;
            }

            protected String getDriverClassName() {
                return null;
            }

            protected String getDatabaseID() {
                return null;
            }

            protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
                return null;
            }
        };
        return factory;
    }

    protected List<String> getBaseJNDIParams() {
        JDBCJNDIDataStoreFactory factory = new JDBCJNDIDataStoreFactory(this.getBaseFactory()){};
        return this.getParamKeys((JDBCDataStoreFactory)factory);
    }

    protected List<String> getParamKeys(JDBCDataStoreFactory factory) {
        DataAccessFactory.Param[] params = factory.getParametersInfo();
        ArrayList<String> results = new ArrayList<String>();
        for (DataAccessFactory.Param p : params) {
            results.add(p.key);
        }
        return results;
    }
}

