/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import org.geotools.jdbc.NamePatternEscaping;
import org.junit.Assert;
import org.junit.Test;

public class NamePatternEscapingTest {
    @Test
    public void escapeWithBackslash() throws Exception {
        NamePatternEscaping escaping = new NamePatternEscaping("\\");
        Assert.assertNull((Object)escaping.escape(null));
        Assert.assertEquals((Object)"TABLE", (Object)escaping.escape("TABLE"));
        Assert.assertEquals((Object)"\\\\TABLE", (Object)escaping.escape("\\TABLE"));
        Assert.assertEquals((Object)"/TABLE", (Object)escaping.escape("/TABLE"));
        Assert.assertEquals((Object)"TABLE\\_NAME", (Object)escaping.escape("TABLE_NAME"));
        Assert.assertEquals((Object)"\\\\TABLE\\_\\%NAME", (Object)escaping.escape("\\TABLE_%NAME"));
        Assert.assertEquals((Object)"/TABLE\\_\\%NAME", (Object)escaping.escape("/TABLE_%NAME"));
    }

    @Test
    public void escapeWithSlash() throws Exception {
        NamePatternEscaping escaping = new NamePatternEscaping("/");
        Assert.assertNull((Object)escaping.escape(null));
        Assert.assertEquals((Object)"TABLE", (Object)escaping.escape("TABLE"));
        Assert.assertEquals((Object)"\\TABLE", (Object)escaping.escape("\\TABLE"));
        Assert.assertEquals((Object)"//TABLE", (Object)escaping.escape("/TABLE"));
        Assert.assertEquals((Object)"TABLE/_NAME", (Object)escaping.escape("TABLE_NAME"));
        Assert.assertEquals((Object)"\\TABLE/_/%NAME", (Object)escaping.escape("\\TABLE_%NAME"));
        Assert.assertEquals((Object)"//TABLE/_/%NAME", (Object)escaping.escape("/TABLE_%NAME"));
    }
}

