/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.awt.RenderingHints;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.data.FeatureLock;
import org.geotools.api.data.FeatureLockException;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureLocking;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.IllegalAttributeException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.function.FilterFunction_geometryType;
import org.geotools.filter.function.math.FilterFunction_ceil;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCDataStoreAPITestSetup;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.TestData;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;

public abstract class JDBCDataStoreAPIOnlineTest
extends JDBCTestSupport {
    private static final int LOCK_DURATION = 3600000;
    protected TestData td;

    @Override
    protected void connect() throws Exception {
        super.connect();
        if (this.td == null) {
            this.td = new TestData(((JDBCDataStoreAPITestSetup)this.setup).getInitialPrimaryKeyValue());
            this.td.forceLongitudeFirst = this.forceLongitudeFirst;
            this.td.ROAD = this.tname(this.td.ROAD);
            this.td.ROAD_ID = this.aname(this.td.ROAD_ID);
            this.td.ROAD_GEOM = this.aname(this.td.ROAD_GEOM);
            this.td.ROAD_NAME = this.aname(this.td.ROAD_NAME);
            this.td.RIVER = this.tname(this.td.RIVER);
            this.td.RIVER_ID = this.aname(this.td.RIVER_ID);
            this.td.RIVER_GEOM = this.aname(this.td.RIVER_GEOM);
            this.td.RIVER_FLOW = this.aname(this.td.RIVER_FLOW);
            this.td.RIVER_RIVER = this.aname(this.td.RIVER_RIVER);
            this.td.build();
        }
        if (this.setup.canResetSchema()) {
            this.dataStore.setDatabaseSchema(null);
        }
    }

    @Override
    protected abstract JDBCDataStoreAPITestSetup createTestSetup();

    @Test
    public void testGetFeatureTypes() {
        try {
            Object[] names = this.dataStore.getTypeNames();
            Assert.assertTrue((boolean)this.contains(names, this.tname("road")));
            Assert.assertTrue((boolean)this.contains(names, this.tname("river")));
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            Assert.fail((String)"An IOException has been thrown!");
        }
    }

    @Test
    public void testGetSchemaRoad() throws IOException {
        SimpleFeatureType expected = this.td.roadType;
        SimpleFeatureType actual = this.dataStore.getSchema(this.tname("road"));
        Assert.assertEquals((String)"name", (Object)this.aname(expected.getName()), (Object)actual.getName());
        Assert.assertEquals((String)"attributeCount", (long)expected.getAttributeCount(), (long)actual.getAttributeCount());
        for (int i = 0; i < expected.getAttributeCount(); ++i) {
            AttributeDescriptor expectedAttribute = expected.getDescriptor(i);
            AttributeDescriptor actualAttribute = actual.getDescriptor(i);
            this.assertAttributesEqual(expectedAttribute, actualAttribute);
        }
        GeometryDescriptor dg = actual.getGeometryDescriptor();
        Assert.assertTrue((boolean)dg.isNillable());
        Assert.assertEquals((long)0L, (long)dg.getMinOccurs());
    }

    @Test
    public void testGetSchemaRiver() throws IOException {
        SimpleFeatureType expected = this.td.riverType;
        SimpleFeatureType actual = this.dataStore.getSchema(this.tname("river"));
        Assert.assertEquals((String)"name", (Object)this.aname(expected.getName()), (Object)actual.getName());
        Assert.assertEquals((String)"attributeCount", (long)expected.getAttributeCount(), (long)actual.getAttributeCount());
        this.assertFeatureTypesEqual(expected, actual);
    }

    @Test
    public void testCreateSchema() throws Exception {
        String featureTypeName = this.tname("building");
        CoordinateReferenceSystem crs = this.decodeEPSG(4326);
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName(featureTypeName);
        ftb.add(this.aname("id"), Integer.class);
        ftb.add(this.aname("name"), String.class);
        ftb.add(this.aname("the_geom"), Point.class, crs);
        SimpleFeatureType newFT = ftb.buildFeatureType();
        this.dataStore.createSchema(newFT);
        SimpleFeatureType newSchema = this.dataStore.getSchema(featureTypeName);
        Assert.assertNotNull((Object)newSchema);
        Assert.assertEquals((long)3L, (long)newSchema.getAttributeCount());
    }

    @Test
    public void testGetFeatureReader() throws IOException, IllegalAttributeException {
        this.assertCovered(this.td.roadFeatures, this.reader(this.tname("road")));
        Assert.assertEquals((long)3L, (long)this.count(this.reader(this.tname("road"))));
    }

    @Test
    public void testGeometryFactoryHintsGF() throws IOException {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("road"));
        Assert.assertTrue((boolean)fs.getSupportedHints().contains(Hints.JTS_GEOMETRY_FACTORY));
        Query q = new Query(this.tname("road"));
        GeometryFactory gf = new GeometryFactory((CoordinateSequenceFactory)new LiteCoordinateSequenceFactory());
        Hints hints = new Hints((RenderingHints.Key)Hints.JTS_GEOMETRY_FACTORY, (Object)gf);
        q.setHints(hints);
        try (SimpleFeatureIterator it = fs.getFeatures(q).features();){
            it.hasNext();
            SimpleFeature f = (SimpleFeature)it.next();
            LineString ls = (LineString)f.getDefaultGeometry();
            Assert.assertTrue((boolean)(ls.getCoordinateSequence() instanceof LiteCoordinateSequence));
        }
    }

    @Test
    public void testGeometryFactoryHintsCS() throws IOException {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("road"));
        Assert.assertTrue((boolean)fs.getSupportedHints().contains(Hints.JTS_COORDINATE_SEQUENCE_FACTORY));
        Query q = new Query(this.tname("road"));
        Hints hints = new Hints((RenderingHints.Key)Hints.JTS_COORDINATE_SEQUENCE_FACTORY, (Object)new LiteCoordinateSequenceFactory());
        q.setHints(hints);
        try (SimpleFeatureIterator it = fs.getFeatures(q).features();){
            it.hasNext();
            SimpleFeature f = (SimpleFeature)it.next();
            LineString ls = (LineString)f.getDefaultGeometry();
            Assert.assertTrue((boolean)(ls.getCoordinateSequence() instanceof LiteCoordinateSequence));
        }
    }

    @Test
    public void testGetFeatureReaderLake() throws IOException, IllegalFilterException {
        try (DefaultTransaction t = new DefaultTransaction();
             FeatureReader reader = this.dataStore.getFeatureReader(new Query(this.tname("lake")), (Transaction)t);){
            Assert.assertNotNull((Object)reader);
            Assert.assertTrue((boolean)reader.hasNext());
            Assert.assertNotNull((Object)reader.next());
            Assert.assertFalse((boolean)reader.hasNext());
        }
    }

    @Test
    public void testGetFeatureReaderFilterPrePost() throws IOException, IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        FilterFunction_geometryType geomTypeExpr = new FilterFunction_geometryType();
        geomTypeExpr.setParameters(Collections.singletonList(factory.property(this.aname("geom"))));
        PropertyIsEqualTo filter = factory.equals((Expression)geomTypeExpr, (Expression)factory.literal((Object)"Polygon"));
        try (DefaultTransaction t = new DefaultTransaction();){
            try (FeatureReader reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)filter), (Transaction)t);){
                Assert.assertNotNull((Object)reader);
                Assert.assertFalse((boolean)reader.hasNext());
            }
            filter = factory.equals((Expression)geomTypeExpr, (Expression)factory.literal((Object)"LineString"));
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)filter), (Transaction)t);
            try {
                Assert.assertTrue((boolean)reader.hasNext());
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    @Test
    public void testGetFeatureReaderFilterPrePostWithNoGeometry() throws IOException, IllegalFilterException {
        try (DefaultTransaction t = new DefaultTransaction();){
            FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
            FilterFunction_geometryType geomTypeExpr = new FilterFunction_geometryType();
            geomTypeExpr.setParameters(Collections.singletonList(factory.property(this.aname("geom"))));
            PropertyIsEqualTo filter = factory.equals((Expression)geomTypeExpr, (Expression)factory.literal((Object)"Polygon"));
            Query query = new Query(this.tname("road"), (Filter)filter);
            query.setPropertyNames(Collections.singletonList(this.aname("id")));
            try (FeatureReader reader = this.dataStore.getFeatureReader(query, (Transaction)t);){
                Assert.assertNotNull((Object)reader);
            }
            filter = factory.equals((Expression)geomTypeExpr, (Expression)factory.literal((Object)"LineString"));
            query.setFilter((Filter)filter);
            reader = this.dataStore.getFeatureReader(query, (Transaction)t);
            try {
                Assert.assertTrue((boolean)reader.hasNext());
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    @Test
    public void testGetFeatureReaderFilterWithAttributesNotRequested() throws Exception {
        this.dataStore.getSchema(this.tname("river"));
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("flow")), (Expression)ff.literal(4.5));
        Query q = new Query(this.tname("river"));
        q.setPropertyNames(new String[]{this.aname("geom")});
        q.setFilter((Filter)f);
        try (DefaultTransaction t = new DefaultTransaction();
             FeatureReader reader = this.dataStore.getFeatureReader(q, (Transaction)t);){
            Assert.assertTrue((boolean)reader.hasNext());
            Assert.assertEquals((long)1L, (long)((SimpleFeatureType)reader.getFeatureType()).getAttributeCount());
            reader.next();
            Assert.assertFalse((boolean)reader.hasNext());
        }
    }

    @Test
    public void testGetFeatureReaderFilterWithAttributesNotRequested2() throws Exception {
        this.dataStore.getSchema(this.tname("river"));
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        FilterFunction_ceil ceil = new FilterFunction_ceil();
        ceil.setParameters(Collections.singletonList(ff.property(this.aname("flow"))));
        PropertyIsEqualTo f = ff.equals((Expression)ceil, (Expression)ff.literal(5));
        Query q = new Query(this.tname("river"));
        q.setPropertyNames(new String[]{this.aname("geom")});
        q.setFilter((Filter)f);
        try (DefaultTransaction t = new DefaultTransaction();
             FeatureReader reader = this.dataStore.getFeatureReader(q, (Transaction)t);){
            Assert.assertTrue((boolean)reader.hasNext());
            Assert.assertEquals((long)1L, (long)((SimpleFeatureType)reader.getFeatureType()).getAttributeCount());
            reader.next();
            Assert.assertFalse((boolean)reader.hasNext());
        }
    }

    @Test
    public void testGetFeatureInvalidFilter() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo f = ff.equals((Expression)ff.property("invalidAttribute"), (Expression)ff.literal(5));
        Query q = new Query(this.tname("river"));
        q.setPropertyNames(new String[]{this.aname("geom")});
        q.setFilter((Filter)f);
        try (FeatureReader reader = this.dataStore.getFeatureReader(q, Transaction.AUTO_COMMIT);){
            Assert.fail((String)"This query should have failed, it contains an invalid filter");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetFeatureReaderMutability() throws IOException, IllegalAttributeException {
        SimpleFeature feature;
        try (FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.reader(this.tname("road"));){
            while (reader.hasNext()) {
                feature = (SimpleFeature)reader.next();
                feature.setAttribute(this.aname("name"), null);
            }
        }
        try {
            reader = this.reader(this.tname("road"));
            try {
                while (reader.hasNext()) {
                    feature = (SimpleFeature)reader.next();
                    Assert.assertNotNull((Object)feature.getAttribute(this.aname("name")));
                }
                reader.close();
                reader.next();
                Assert.fail((String)"next should fail with an IOException");
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetFeatureReaderConcurrency() throws NoSuchElementException, IOException {
        try (FeatureReader<SimpleFeatureType, SimpleFeature> reader1 = this.reader(this.tname("road"));
             FeatureReader<SimpleFeatureType, SimpleFeature> reader2 = this.reader(this.tname("road"));
             FeatureReader<SimpleFeatureType, SimpleFeature> reader3 = this.reader(this.tname("river"));){
            while (reader1.hasNext() || reader2.hasNext() || reader3.hasNext()) {
                this.assertContains(this.td.roadFeatures, (SimpleFeature)reader1.next());
                Assert.assertTrue((boolean)reader2.hasNext());
                this.assertContains(this.td.roadFeatures, (SimpleFeature)reader2.next());
                if (!reader3.hasNext()) continue;
                this.assertContains(this.td.riverFeatures, (SimpleFeature)reader3.next());
            }
            try {
                Assert.assertFalse((boolean)reader1.hasNext());
                reader1.next();
                Assert.fail((String)"next should fail with an NoSuchElementException");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                reader2.next();
                Assert.fail((String)"next should fail with an NoSuchElementException");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                reader3.next();
                Assert.fail((String)"next should fail with an NoSuchElementException");
            }
            catch (Exception exception) {
                // empty catch block
            }
            reader1.close();
            reader2.close();
            reader3.close();
            try {
                reader1.next();
                Assert.fail((String)"next should fail with an IOException");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                reader2.next();
                Assert.fail((String)"next should fail with an IOException");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                reader3.next();
                Assert.fail((String)"next should fail with an IOException");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testGetFeatureReaderFilterAutoCommit() throws NoSuchElementException, IOException, IllegalAttributeException {
        SimpleFeatureType type = this.dataStore.getSchema(this.tname("road"));
        try (FeatureReader reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), Transaction.AUTO_COMMIT);){
            Assert.assertFalse((boolean)(reader instanceof FilteringFeatureReader));
            Assert.assertEquals((Object)type, (Object)reader.getFeatureType());
            Assert.assertEquals((long)this.td.roadFeatures.length, (long)this.count((FeatureReader<SimpleFeatureType, SimpleFeature>)reader));
        }
        reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.EXCLUDE), Transaction.AUTO_COMMIT);
        try {
            Assert.assertFalse((boolean)reader.hasNext());
            Assert.assertEquals((Object)type, (Object)reader.getFeatureType());
            Assert.assertEquals((long)0L, (long)this.count((FeatureReader<SimpleFeatureType, SimpleFeature>)reader));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), this.td.rd1Filter), Transaction.AUTO_COMMIT);
        try {
            Assert.assertEquals((Object)type, (Object)reader.getFeatureType());
            Assert.assertEquals((long)1L, (long)this.count((FeatureReader<SimpleFeatureType, SimpleFeature>)reader));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Test
    public void testGetFeatureReaderFilterTransaction() throws NoSuchElementException, IOException, IllegalAttributeException {
        SimpleFeatureType type = this.dataStore.getSchema(this.tname("road"));
        try (DefaultTransaction t = new DefaultTransaction();){
            try (FeatureReader reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.EXCLUDE), (Transaction)t);){
                Assert.assertFalse((boolean)reader.hasNext());
                Assert.assertEquals((Object)type, (Object)reader.getFeatureType());
                Assert.assertEquals((long)0L, (long)this.count((FeatureReader<SimpleFeatureType, SimpleFeature>)reader));
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), (Transaction)t);
            try {
                Assert.assertEquals((Object)type, (Object)reader.getFeatureType());
                Assert.assertEquals((long)this.td.roadFeatures.length, (long)this.count((FeatureReader<SimpleFeatureType, SimpleFeature>)reader));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), this.td.rd1Filter), (Transaction)t);
            try {
                Assert.assertEquals((Object)type, (Object)reader.getFeatureType());
                Assert.assertEquals((long)1L, (long)this.count((FeatureReader<SimpleFeatureType, SimpleFeature>)reader));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            try (FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("road"), (Filter)Filter.INCLUDE, (Transaction)t);){
                while (writer.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)writer.next();
                    if (!feature.getID().equals(this.td.roadFeatures[0].getID())) continue;
                    writer.remove();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.EXCLUDE), (Transaction)t);
            try {
                Assert.assertEquals((long)0L, (long)this.count((FeatureReader<SimpleFeatureType, SimpleFeature>)reader));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), (Transaction)t);
            try {
                Assert.assertEquals((long)(this.td.roadFeatures.length - 1), (long)this.count((FeatureReader<SimpleFeatureType, SimpleFeature>)reader));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), this.td.rd1Filter), (Transaction)t);
            try {
                Assert.assertEquals((long)0L, (long)this.count((FeatureReader<SimpleFeatureType, SimpleFeature>)reader));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            t.rollback();
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.EXCLUDE), (Transaction)t);
            try {
                Assert.assertEquals((long)0L, (long)this.count((FeatureReader<SimpleFeatureType, SimpleFeature>)reader));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), (Transaction)t);
            try {
                Assert.assertEquals((long)this.td.roadFeatures.length, (long)this.count((FeatureReader<SimpleFeatureType, SimpleFeature>)reader));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), this.td.rd1Filter), (Transaction)t);
            try {
                Assert.assertEquals((long)1L, (long)this.count((FeatureReader<SimpleFeatureType, SimpleFeature>)reader));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    @Test
    public void testGetFeatureWriterClose() throws Exception {
        try (FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("road"), (Filter)Filter.INCLUDE, Transaction.AUTO_COMMIT);){
            writer.close();
            try {
                Assert.assertFalse((boolean)writer.hasNext());
                Assert.fail((String)"Should not be able to use a closed writer");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Assert.assertNull((Object)writer.next());
                Assert.fail((String)"Should not be able to use a closed writer");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void testGetFeatureWriterRemove() throws IOException {
        try (FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.writer(this.tname("road"));){
            while (writer.hasNext()) {
                SimpleFeature feature = (SimpleFeature)writer.next();
                if (!feature.getID().equals(this.td.roadFeatures[0].getID())) continue;
                writer.remove();
            }
        }
        Assert.assertEquals((long)(this.td.roadFeatures.length - 1), (long)this.count(this.tname("road")));
    }

    @Test
    public void testGetFeatureWriterRemoveAll() throws IOException {
        try (FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.writer(this.tname("road"));){
            while (writer.hasNext()) {
                writer.next();
                writer.remove();
            }
        }
        Assert.assertEquals((long)0L, (long)this.count(this.tname("road")));
    }

    @Test
    public void testGetFeaturesWriterAdd() throws IOException {
        try (FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("road"), Transaction.AUTO_COMMIT);){
            while (writer.hasNext()) {
                writer.next();
            }
            Assert.assertFalse((boolean)writer.hasNext());
            SimpleFeature feature = (SimpleFeature)writer.next();
            feature.setAttributes(this.td.newRoad.getAttributes());
            writer.write();
            Assert.assertFalse((boolean)writer.hasNext());
            Assert.assertEquals((long)(this.td.roadFeatures.length + 1), (long)this.count(this.tname("road")));
        }
    }

    @Test
    public void testGetFeaturesWriterModify() throws IOException {
        try (FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.writer(this.tname("road"));){
            while (writer.hasNext()) {
                SimpleFeature feature = (SimpleFeature)writer.next();
                if (!feature.getID().equals(this.td.roadFeatures[0].getID())) continue;
                feature.setAttribute(this.aname("name"), (Object)"changed");
                writer.write();
            }
        }
        SimpleFeature feature = this.feature(this.tname("road"), this.td.roadFeatures[0].getID());
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)"changed", (Object)feature.getAttribute(this.aname("name")));
    }

    @Test
    public void testGetFeatureWriterTypeNameTransaction() throws NoSuchElementException, IOException {
        try (FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("road"), Transaction.AUTO_COMMIT);){
            Assert.assertEquals((long)this.td.roadFeatures.length, (long)this.count((FeatureWriter<SimpleFeatureType, SimpleFeature>)writer));
        }
    }

    @Test
    public void testGetFeatureWriterAppendTypeNameTransaction() throws Exception {
        try (FeatureWriter writer = this.dataStore.getFeatureWriterAppend(this.tname("road"), Transaction.AUTO_COMMIT);){
            Assert.assertEquals((long)0L, (long)this.count((FeatureWriter<SimpleFeatureType, SimpleFeature>)writer));
        }
    }

    @Test
    public void testGetFeatureWriterFilter() throws NoSuchElementException, IOException {
        try (FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("road"), (Filter)Filter.EXCLUDE, Transaction.AUTO_COMMIT);){
            Assert.assertEquals((long)0L, (long)this.count((FeatureWriter<SimpleFeatureType, SimpleFeature>)writer));
        }
        writer = this.dataStore.getFeatureWriter(this.tname("road"), (Filter)Filter.INCLUDE, Transaction.AUTO_COMMIT);
        try {
            Assert.assertEquals((long)this.td.roadFeatures.length, (long)this.count((FeatureWriter<SimpleFeatureType, SimpleFeature>)writer));
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        writer = this.dataStore.getFeatureWriter(this.tname("road"), this.td.rd1Filter, Transaction.AUTO_COMMIT);
        try {
            Assert.assertEquals((long)1L, (long)this.count((FeatureWriter<SimpleFeatureType, SimpleFeature>)writer));
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    @Test
    public void testGetFeatureWriterInvalidFilter() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo f = ff.equals((Expression)ff.property("invalidAttribute"), (Expression)ff.literal(5));
        try (FeatureWriter writer = this.dataStore.getFeatureWriter("river", (Filter)f, Transaction.AUTO_COMMIT);){
            Assert.fail((String)"This query should have failed, it contains an invalid filter");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testTransactionIsolation() throws Exception {
        try (DefaultTransaction t1 = new DefaultTransaction();
             DefaultTransaction t2 = new DefaultTransaction();){
            SimpleFeature[] ORIGINAL = this.td.roadFeatures;
            SimpleFeature[] REMOVE = new SimpleFeature[ORIGINAL.length - 1];
            SimpleFeature[] ADD = new SimpleFeature[ORIGINAL.length + 1];
            SimpleFeature[] FINAL = new SimpleFeature[ORIGINAL.length];
            try (FeatureWriter writer1 = this.dataStore.getFeatureWriter(this.tname("road"), this.td.rd1Filter, (Transaction)t1);
                 FeatureWriter writer2 = this.dataStore.getFeatureWriterAppend(this.tname("road"), (Transaction)t2);){
                SimpleFeature feature;
                int i;
                int index = 0;
                for (i = 0; i < ORIGINAL.length; ++i) {
                    feature = ORIGINAL[i];
                    if (feature.getID().equals(this.td.roadFeatures[0].getID())) continue;
                    REMOVE[index++] = feature;
                }
                for (i = 0; i < ORIGINAL.length; ++i) {
                    ADD[i] = ORIGINAL[i];
                }
                ADD[i] = this.td.newRoad;
                for (i = 0; i < REMOVE.length; ++i) {
                    FINAL[i] = REMOVE[i];
                }
                FINAL[i] = this.td.newRoad;
                try (FeatureReader reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), Transaction.AUTO_COMMIT);){
                    Assert.assertTrue((String)"Sanity check failed: before modification reader didn't match original content", (boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGINAL));
                }
                while (writer1.hasNext()) {
                    feature = (SimpleFeature)writer1.next();
                    Assert.assertEquals((Object)this.td.roadFeatures[0].getID(), (Object)feature.getID());
                    writer1.remove();
                }
                reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), Transaction.AUTO_COMMIT);
                try {
                    Assert.assertTrue((String)"Feature deletion managed to leak out of transaction?", (boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGINAL));
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
                reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), (Transaction)t1);
                try {
                    Assert.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, REMOVE));
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
                writer1.close();
                reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), Transaction.AUTO_COMMIT);
                try {
                    Assert.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGINAL));
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
                reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), (Transaction)t1);
                try {
                    Assert.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, REMOVE));
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
                feature = (SimpleFeature)writer2.next();
                feature.setAttributes(this.td.newRoad.getAttributes());
                writer2.write();
            }
            try (FeatureReader reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), (Transaction)t2);){
                ADD[ADD.length - 1] = this.td.newRoad = this.findFeature((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, this.aname("name"), "r4");
                FINAL[FINAL.length - 1] = this.td.newRoad;
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), Transaction.AUTO_COMMIT);
            try {
                Assert.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGINAL));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), (Transaction)t2);
            try {
                this.assertMatched(ADD, (FeatureReader<SimpleFeatureType, SimpleFeature>)reader);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), Transaction.AUTO_COMMIT);
            try {
                Assert.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGINAL));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), (Transaction)t2);
            try {
                Assert.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ADD));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            t1.commit();
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), Transaction.AUTO_COMMIT);
            try {
                Assert.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, REMOVE));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), (Transaction)t1);
            try {
                Assert.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, REMOVE));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), (Transaction)t2);
            try {
                Assert.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, FINAL));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            t2.commit();
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), Transaction.AUTO_COMMIT);
            try {
                Assert.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, FINAL));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), (Transaction)t1);
            try {
                Assert.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, FINAL));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), (Transaction)t2);
            try {
                Assert.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, FINAL));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    @Test
    public void testGetFeatureWriterConcurrency() throws Exception {
        try (DefaultTransaction t1 = new DefaultTransaction();
             FeatureWriter writer1 = this.dataStore.getFeatureWriter(this.tname("road"), this.td.rd1Filter, (Transaction)t1);){
            Assert.assertTrue((boolean)writer1.hasNext());
            SimpleFeature f1 = (SimpleFeature)writer1.next();
            f1.setAttribute("name", (Object)"r1_");
            writer1.write();
            try (DefaultTransaction t2 = new DefaultTransaction();
                 FeatureWriter writer2 = this.dataStore.getFeatureWriter(this.tname("road"), this.td.rd1Filter, (Transaction)t2);){
                Assert.assertTrue((boolean)writer2.hasNext());
                SimpleFeature f2 = (SimpleFeature)writer2.next();
                f2.setAttribute("name", (Object)"r1__");
                try {
                    writer2.write();
                    Assert.fail((String)"Feature lock should have failed");
                }
                catch (FeatureLockException e) {
                    Assert.assertEquals((Object)(this.tname("road") + ".rd1"), (Object)e.getFeatureID());
                }
                t1.rollback();
                t2.rollback();
            }
        }
    }

    @Test
    public void testGetFeatureSourceRoad() throws Exception {
        ContentFeatureSource road = this.dataStore.getFeatureSource(this.tname("road"));
        this.assertFeatureTypesEqual(this.td.roadType, (SimpleFeatureType)road.getSchema());
        Assert.assertSame((Object)this.dataStore, (Object)road.getDataStore());
        int count = road.getCount(Query.ALL);
        Assert.assertTrue((count == 3 || count == -1 ? 1 : 0) != 0);
        ReferencedEnvelope bounds = road.getBounds(Query.ALL);
        Assert.assertTrue((bounds == null || this.areReferencedEnvelopesEqual(bounds, this.td.roadBounds) ? 1 : 0) != 0);
        SimpleFeatureCollection all = road.getFeatures();
        Assert.assertEquals((long)3L, (long)all.size());
        Assert.assertTrue((boolean)this.areReferencedEnvelopesEqual(this.td.roadBounds, all.getBounds()));
        SimpleFeatureCollection expected = DataUtilities.collection((SimpleFeature[])this.td.roadFeatures);
        this.assertCovers("all", expected, all);
        Assert.assertTrue((boolean)this.areReferencedEnvelopesEqual(this.td.roadBounds, all.getBounds()));
        SimpleFeatureCollection some = road.getFeatures(this.td.rd12Filter);
        Assert.assertEquals((long)2L, (long)some.size());
        ReferencedEnvelope e = new ReferencedEnvelope(this.decodeEPSG(4326));
        e.include(this.td.roadFeatures[0].getBounds());
        e.include(this.td.roadFeatures[1].getBounds());
        Assert.assertTrue((boolean)this.areReferencedEnvelopesEqual(e, some.getBounds()));
        Assert.assertEquals((Object)some.getSchema(), (Object)road.getSchema());
        Query query = new Query(this.tname("road"), this.td.rd12Filter, new String[]{this.aname("name")});
        SimpleFeatureCollection half = road.getFeatures(query);
        Assert.assertEquals((long)2L, (long)half.size());
        Assert.assertEquals((long)1L, (long)((SimpleFeatureType)half.getSchema()).getAttributeCount());
        try (SimpleFeatureIterator reader = half.features();){
            SimpleFeatureType type = (SimpleFeatureType)half.getSchema();
            SimpleFeatureType actual = ((SimpleFeature)reader.next()).getFeatureType();
            Assert.assertEquals((Object)type.getName(), (Object)actual.getName());
            Assert.assertEquals((long)type.getAttributeCount(), (long)actual.getAttributeCount());
            for (int i = 0; i < type.getAttributeCount(); ++i) {
                Assert.assertEquals((Object)type.getDescriptor(i), (Object)actual.getDescriptor(i));
            }
            Assert.assertNull((Object)type.getGeometryDescriptor());
            Assert.assertEquals((Object)type.getGeometryDescriptor(), (Object)actual.getGeometryDescriptor());
            Assert.assertEquals((Object)type, (Object)actual);
            ReferencedEnvelope b = half.getBounds();
            ReferencedEnvelope expectedBounds = this.td.roadBounds;
            Assert.assertTrue((boolean)this.areReferencedEnvelopesEqual(expectedBounds, b));
        }
    }

    @Test
    public void testGetFeatureSourceRiver() throws NoSuchElementException, IOException, IllegalAttributeException {
        ContentFeatureSource river = this.dataStore.getFeatureSource(this.tname("river"));
        this.assertFeatureTypesEqual(this.td.riverType, (SimpleFeatureType)river.getSchema());
        Assert.assertSame((Object)this.dataStore, (Object)river.getDataStore());
        SimpleFeatureCollection all = river.getFeatures();
        Assert.assertEquals((long)2L, (long)all.size());
        Assert.assertTrue((boolean)this.areReferencedEnvelopesEqual(this.td.riverBounds, all.getBounds()));
        Assert.assertTrue((String)"rivers", (boolean)this.covers(all.features(), this.td.riverFeatures));
        SimpleFeatureCollection expected = DataUtilities.collection((SimpleFeature[])this.td.riverFeatures);
        this.assertCovers("all", expected, all);
        Assert.assertTrue((boolean)this.areReferencedEnvelopesEqual(this.td.riverBounds, all.getBounds()));
    }

    @Test
    public void testGetFeatureStoreModifyFeatures1() throws IOException {
        SimpleFeatureStore road = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.tname("road"));
        Integer changed = 5;
        road.modifyFeatures((Name)new NameImpl(this.aname("id")), (Object)changed, this.td.rd1Filter);
        SimpleFeatureCollection results = road.getFeatures(this.td.rd1Filter);
        try (SimpleFeatureIterator features = results.features();){
            Assert.assertTrue((boolean)features.hasNext());
            Assert.assertEquals((long)5L, (long)((Number)((SimpleFeature)features.next()).getAttribute(this.aname("id"))).intValue());
        }
    }

    @Test
    public void testGetFeatureStoreModifyFeatures2() throws IOException {
        SimpleFeatureStore road = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.tname("road"));
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        Id rd1Filter = factory.id(Collections.singleton(factory.featureId(this.td.roadFeatures[0].getID())));
        road.modifyFeatures(new Name[]{new NameImpl(this.aname("name"))}, new Object[]{"changed"}, (Filter)rd1Filter);
        SimpleFeatureCollection results = road.getFeatures(this.td.rd1Filter);
        try (SimpleFeatureIterator features = results.features();){
            Assert.assertTrue((boolean)features.hasNext());
            Assert.assertEquals((Object)"changed", (Object)((SimpleFeature)features.next()).getAttribute(this.aname("name")));
        }
    }

    @Test
    public void testGetFeatureStoreModifyFeatures3() throws IOException {
        SimpleFeatureStore road = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.tname("road"));
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property(this.aname("name")), (Expression)ff.literal((Object)"r1"));
        road.modifyFeatures(new Name[]{new NameImpl(this.aname("name"))}, new Object[]{"changed"}, (Filter)filter);
    }

    @Test
    public void testGetFeatureStoreRemoveFeatures() throws IOException {
        SimpleFeatureStore road = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.tname("road"));
        road.removeFeatures(this.td.rd1Filter);
        Assert.assertEquals((long)0L, (long)road.getFeatures(this.td.rd1Filter).size());
        Assert.assertEquals((long)(this.td.roadFeatures.length - 1), (long)road.getFeatures().size());
    }

    @Test
    public void testGetFeatureStoreRemoveAllFeatures() throws IOException {
        SimpleFeatureStore road = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.tname("road"));
        road.removeFeatures((Filter)Filter.INCLUDE);
        Assert.assertEquals((long)0L, (long)road.getFeatures().size());
    }

    @Test
    public void testGetFeatureStoreAddFeatures() throws IOException {
        try (FeatureReader reader = DataUtilities.reader((SimpleFeature[])new SimpleFeature[]{this.td.newRoad});){
            SimpleFeatureStore road = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.tname("road"));
            road.addFeatures((FeatureCollection)DataUtilities.collection((FeatureReader)reader));
            Assert.assertEquals((long)(this.td.roadFeatures.length + 1), (long)this.count(this.tname("road")));
        }
    }

    @Test
    public void testGetFeatureStoreSetFeatures() throws NoSuchElementException, IOException, IllegalAttributeException {
        try (FeatureReader reader = DataUtilities.reader((SimpleFeature[])new SimpleFeature[]{this.td.newRoad});){
            SimpleFeatureStore road = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.tname("road"));
            Assert.assertEquals((long)3L, (long)this.count(this.tname("road")));
            road.setFeatures(reader);
            Assert.assertEquals((long)1L, (long)this.count(this.tname("road")));
        }
    }

    boolean isLocked(String typeName, String fid) {
        InProcessLockingManager lockingManager = (InProcessLockingManager)this.dataStore.getLockingManager();
        return lockingManager.isLocked(typeName, fid);
    }

    @Test
    public void testLockFeatures() throws IOException {
        FeatureLock lock = new FeatureLock("test", 3600000L);
        SimpleFeatureLocking road = (SimpleFeatureLocking)this.dataStore.getFeatureSource(this.tname("road"));
        road.setFeatureLock(lock);
        Assert.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + ".1"));
        Assert.assertTrue((road.lockFeatures() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.isLocked(this.tname("road"), this.tname("road") + ".1"));
    }

    @Test
    public void testUnLockFeatures() throws IOException {
        FeatureLock lock = new FeatureLock("test", 3600000L);
        SimpleFeatureLocking road = (SimpleFeatureLocking)this.dataStore.getFeatureSource(this.tname("road"));
        road.setFeatureLock(lock);
        road.lockFeatures();
        try {
            road.unLockFeatures();
            Assert.fail((String)"unlock should fail due on AUTO_COMMIT");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (DefaultTransaction t = new DefaultTransaction();){
            road.setTransaction((Transaction)t);
            try {
                road.unLockFeatures();
                Assert.fail((String)"unlock should fail due lack of authorization");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            t.addAuthorization(lock.getAuthorization());
            road.unLockFeatures();
        }
    }

    @Test
    public void testLockFeatureInteraction() throws IOException {
        FeatureLock lockA = new FeatureLock("LockA", 3600000L);
        FeatureLock lockB = new FeatureLock("LockB", 3600000L);
        try (DefaultTransaction t1 = new DefaultTransaction();
             DefaultTransaction t2 = new DefaultTransaction();){
            SimpleFeatureLocking road1 = (SimpleFeatureLocking)this.dataStore.getFeatureSource(this.tname("road"));
            SimpleFeatureLocking road2 = (SimpleFeatureLocking)this.dataStore.getFeatureSource(this.tname("road"));
            road1.setTransaction((Transaction)t1);
            road2.setTransaction((Transaction)t2);
            road1.setFeatureLock(lockA);
            road2.setFeatureLock(lockB);
            Assert.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + ".0"));
            Assert.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + ".1"));
            Assert.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + ".2"));
            Assert.assertEquals((long)1L, (long)road1.lockFeatures(this.td.rd1Filter));
            Assert.assertTrue((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + this.td.initialFidValue));
            Assert.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + (this.td.initialFidValue + 1)));
            Assert.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + (this.td.initialFidValue + 2)));
            road2.lockFeatures(this.td.rd2Filter);
            Assert.assertTrue((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + this.td.initialFidValue));
            Assert.assertTrue((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + (this.td.initialFidValue + 1)));
            Assert.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + (this.td.initialFidValue + 2)));
            try {
                road1.unLockFeatures(this.td.rd1Filter);
                Assert.fail((String)"need authorization");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            t1.addAuthorization(lockA.getAuthorization());
            try {
                road1.unLockFeatures(this.td.rd2Filter);
                Assert.fail((String)"need correct authorization");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            road1.unLockFeatures(this.td.rd1Filter);
            Assert.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + this.td.initialFidValue));
            Assert.assertTrue((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + (this.td.initialFidValue + 1)));
            Assert.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + (this.td.initialFidValue + 2)));
            t2.addAuthorization(lockB.getAuthorization());
            road2.unLockFeatures(this.td.rd2Filter);
            Assert.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + this.td.initialFidValue));
            Assert.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + (this.td.initialFidValue + 1)));
            Assert.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + (this.td.initialFidValue + 2)));
        }
    }

    @Test
    public void testGetFeatureLockingExpire() throws Exception {
        FeatureLock lock = new FeatureLock("Timed", 1000L);
        SimpleFeatureLocking road = (SimpleFeatureLocking)this.dataStore.getFeatureSource(this.tname("road"));
        road.setFeatureLock(lock);
        Assert.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + this.td.initialFidValue));
        road.lockFeatures(this.td.rd1Filter);
        Assert.assertTrue((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + this.td.initialFidValue));
        long then = System.currentTimeMillis();
        do {
            Thread.sleep(1000L);
        } while (System.currentTimeMillis() - then < 1000L);
        Assert.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + this.td.initialFidValue));
    }

    int count(String typeName) throws IOException {
        return this.dataStore.getFeatureSource(typeName).getFeatures().size();
    }

    int count(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        if (reader == null) {
            return -1;
        }
        int count = 0;
        try (FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = reader;){
            while (reader.hasNext()) {
                reader.next();
                ++count;
            }
        }
        catch (NoSuchElementException e) {
            throw new DataSourceException("hasNext() lied to me at:" + count, (Throwable)e);
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("next() could not understand feature at:" + count, (Throwable)e);
        }
        return count;
    }

    void assertCovered(SimpleFeature[] features, FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try (FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = reader;){
            while (reader.hasNext()) {
                this.assertContains(features, (SimpleFeature)reader.next());
                ++count;
            }
        }
        Assert.assertEquals((long)features.length, (long)count);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void assertCovers(String msg, SimpleFeatureCollection c1, SimpleFeatureCollection c2) {
        if (c1 == c2) {
            return;
        }
        Assert.assertNotNull((String)msg, (Object)c1);
        Assert.assertNotNull((String)msg, (Object)c2);
        Assert.assertEquals((String)(msg + " size"), (long)c1.size(), (long)c2.size());
        try (SimpleFeatureIterator i = c1.features();){
            while (i.hasNext()) {
                SimpleFeature f = (SimpleFeature)i.next();
                boolean found = false;
                SimpleFeatureIterator j = c2.features();
                try {
                    while (j.hasNext() && !found) {
                        SimpleFeature g = (SimpleFeature)j.next();
                        found = f.getID().equals(g.getID());
                    }
                    j.close();
                    Assert.assertTrue((String)(msg + " " + f.getID()), (boolean)found);
                }
                finally {
                    if (j == null) continue;
                    j.close();
                }
            }
            return;
        }
    }

    void assertContains(SimpleFeature[] array, SimpleFeature expected) {
        Assert.assertNotNull((Object)array);
        Assert.assertNotEquals((long)0L, (long)array.length);
        Assert.assertNotNull((Object)expected);
        for (SimpleFeature simpleFeature : array) {
            if (!this.id(simpleFeature.getID(), simpleFeature).equals(expected.getID())) continue;
            return;
        }
        Assert.fail((String)("Contains " + expected));
    }

    String id(String raw, SimpleFeature f) {
        if (raw == null) {
            return null;
        }
        if (raw.startsWith(f.getType().getTypeName() + ".")) {
            return this.tname(f.getType().getTypeName()) + raw.substring(f.getType().getTypeName().length());
        }
        return raw;
    }

    boolean contains(Object[] array, Object expected) {
        if (array == null || array.length == 0) {
            return false;
        }
        for (Object o : array) {
            if (!o.equals(expected)) continue;
            return true;
        }
        return false;
    }

    FeatureReader<SimpleFeatureType, SimpleFeature> reader(String typeName) throws IOException {
        return this.dataStore.getFeatureReader(new Query(typeName, (Filter)Filter.INCLUDE), Transaction.AUTO_COMMIT);
    }

    FeatureWriter<SimpleFeatureType, SimpleFeature> writer(String typeName) throws IOException {
        return this.dataStore.getFeatureWriter(typeName, Transaction.AUTO_COMMIT);
    }

    protected int count(FeatureWriter<SimpleFeatureType, SimpleFeature> writer) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try (FeatureWriter<SimpleFeatureType, SimpleFeature> featureWriter = writer;){
            while (writer.hasNext()) {
                writer.next();
                ++count;
            }
        }
        return count;
    }

    protected SimpleFeature feature(String typeName, String fid) throws NoSuchElementException, IOException, IllegalAttributeException {
        try (FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.reader(typeName);){
            while (reader.hasNext()) {
                SimpleFeature f = (SimpleFeature)reader.next();
                if (!fid.equals(f.getID())) continue;
                SimpleFeature simpleFeature = f;
                return simpleFeature;
            }
        }
        return null;
    }

    boolean covers(SimpleFeatureIterator reader, SimpleFeature[] array) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try (SimpleFeatureIterator simpleFeatureIterator = reader;){
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                this.assertContains(array, feature);
                ++count;
            }
        }
        return count == array.length;
    }

    boolean covers(FeatureReader<SimpleFeatureType, SimpleFeature> reader, SimpleFeature[] array) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try (FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = reader;){
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                this.assertContains(array, feature);
                ++count;
            }
        }
        return count == array.length;
    }

    boolean coversLax(FeatureReader<SimpleFeatureType, SimpleFeature> reader, SimpleFeature[] array) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try (FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = reader;){
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                if (!this.containsLax(array, feature)) {
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        return count == array.length;
    }

    boolean containsLax(SimpleFeature[] array, SimpleFeature expected) {
        if (array == null || array.length == 0) {
            return false;
        }
        expected.getFeatureType();
        for (SimpleFeature simpleFeature : array) {
            if (!simpleFeature.getID().equals(expected.getID())) continue;
            return true;
        }
        return false;
    }

    SimpleFeature findFeature(FeatureReader<SimpleFeatureType, SimpleFeature> reader, String attributeName, Object value) throws NoSuchElementException, IOException, IllegalAttributeException {
        try (FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = reader;){
            while (reader.hasNext()) {
                SimpleFeature f = (SimpleFeature)reader.next();
                if (attributeName == null) {
                    if (!value.equals(f.getID())) continue;
                    SimpleFeature simpleFeature = f;
                    return simpleFeature;
                }
                if (!value.equals(f.getAttribute(attributeName))) continue;
                SimpleFeature simpleFeature = f;
                return simpleFeature;
            }
        }
        if (attributeName == null) {
            throw new NoSuchElementException("No match for FID=" + value);
        }
        throw new NoSuchElementException("No match for " + attributeName + "=" + value);
    }

    void assertMatched(SimpleFeature[] array, FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws Exception {
        int count = 0;
        try (FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = reader;){
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                this.assertMatch(array, feature);
                ++count;
            }
        }
        Assert.assertEquals((String)"array not matched by reader", (long)array.length, (long)count);
    }

    void assertMatch(SimpleFeature[] array, SimpleFeature feature) {
        Assert.assertNotNull((Object)array);
        Assert.assertNotEquals((long)array.length, (long)0L);
        for (SimpleFeature simpleFeature : array) {
            if (!simpleFeature.getID().equals(feature.getID())) continue;
            return;
        }
        Assert.fail((String)("array has no match for " + feature));
    }

    boolean match(SimpleFeature expected, SimpleFeature actual) {
        SimpleFeatureType type = expected.getFeatureType();
        for (int i = 0; i < type.getAttributeCount(); ++i) {
            Object av = actual.getAttribute(i);
            Object ev = expected.getAttribute(i);
            if (av == null && ev != null) {
                return false;
            }
            if (ev == null && av != null) {
                return false;
            }
            if (av.equals(ev)) continue;
            return false;
        }
        return true;
    }

    @Test
    public void testGeneralization() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("lake"));
        Assume.assumeTrue((boolean)fs.getSupportedHints().contains(Hints.GEOMETRY_GENERALIZATION));
        SimpleFeatureCollection fColl = fs.getFeatures();
        Geometry original = null;
        try (SimpleFeatureIterator iterator = fColl.features();){
            if (iterator.hasNext()) {
                original = (Geometry)((SimpleFeature)iterator.next()).getDefaultGeometry();
            }
        }
        double width = original.getEnvelope().getEnvelopeInternal().getWidth();
        Query query = new Query();
        Hints hints = new Hints((RenderingHints.Key)Hints.GEOMETRY_GENERALIZATION, (Object)(width / 2.0));
        query.setHints(hints);
        Geometry generalized = null;
        fColl = fs.getFeatures(query);
        try (SimpleFeatureIterator iterator = fColl.features();){
            if (iterator.hasNext()) {
                generalized = (Geometry)((SimpleFeature)iterator.next()).getDefaultGeometry();
            }
        }
        Assert.assertTrue((original.getNumPoints() >= generalized.getNumPoints() ? 1 : 0) != 0);
    }

    @Test
    public void testSimplification() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("road"));
        Assume.assumeTrue((boolean)fs.getSupportedHints().contains(Hints.GEOMETRY_SIMPLIFICATION));
        SimpleFeatureCollection fColl = fs.getFeatures();
        Geometry original = null;
        try (SimpleFeatureIterator iterator = fColl.features();){
            if (iterator.hasNext()) {
                original = (Geometry)((SimpleFeature)iterator.next()).getDefaultGeometry();
            }
        }
        double width = original.getEnvelope().getEnvelopeInternal().getWidth();
        Query query = new Query();
        Hints hints = new Hints((RenderingHints.Key)Hints.GEOMETRY_SIMPLIFICATION, (Object)(width / 2.0));
        query.setHints(hints);
        Geometry simplified = null;
        fColl = fs.getFeatures(query);
        try (SimpleFeatureIterator iterator = fColl.features();){
            if (iterator.hasNext()) {
                simplified = (Geometry)((SimpleFeature)iterator.next()).getDefaultGeometry();
            }
        }
        Assert.assertTrue((original.getNumPoints() >= simplified.getNumPoints() ? 1 : 0) != 0);
    }

    @Override
    protected Map<String, Object> createDataStoreFactoryParams() throws Exception {
        Map<String, Object> params = super.createDataStoreFactoryParams();
        params.put(JDBCDataStoreFactory.BATCH_INSERT_SIZE.key, 1);
        return params;
    }
}

