/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.JDBCTestSetup;
import org.geotools.jdbc.SQLDialect;
import org.geotools.referencing.CRS;
import org.geotools.test.OnlineTestSupport;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.locationtech.jts.geom.Geometry;

public abstract class JDBCTestSupport
extends OnlineTestSupport {
    static final Logger LOGGER = Logging.getLogger(JDBCTestSupport.class);
    protected JDBCTestSetup setup;
    protected JDBCDataStore dataStore;
    protected SQLDialect dialect;
    protected boolean forceLongitudeFirst = false;
    protected final double COORDINATE_EPS;

    public JDBCTestSupport() {
        this.COORDINATE_EPS = 0.0;
    }

    protected JDBCTestSupport(double coordinateEps) {
        this.COORDINATE_EPS = coordinateEps;
    }

    protected Properties createOfflineFixture() {
        return this.createTestSetup().createOfflineFixture();
    }

    protected Properties createExampleFixture() {
        return this.createTestSetup().createExampleFixture();
    }

    protected String getFixtureId() {
        return this.createTestSetup().createDataStoreFactory().getDatabaseID();
    }

    protected boolean isOnline() throws Exception {
        JDBCTestSetup setup = this.createTestSetup();
        setup.setFixture(this.getFixture());
        DataSource dataSource = setup.getDataSource();
        try {
            boolean bl;
            block13: {
                Connection cx = dataSource.getConnection();
                try {
                    bl = true;
                    if (cx == null) break block13;
                }
                catch (Throwable throwable) {
                    if (cx != null) {
                        try {
                            cx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                cx.close();
            }
            return bl;
        }
        finally {
            try {
                setup.tearDown();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error occurred tearing down the test setup", e);
            }
        }
    }

    protected void connect() throws Exception {
        if (this.setup == null) {
            this.setup = this.createTestSetup();
        }
        this.setup.setFixture(this.getFixture());
        this.setup.setUp();
        this.setup.initializeDatabase();
        this.setup.setUpData();
        Map<String, Object> params = this.createDataStoreFactoryParams();
        try {
            Map temp = (Map)((HashMap)params).clone();
            this.getFixture().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> temp.put((String)k, v)));
            this.dataStore = (JDBCDataStore)DataStoreFinder.getDataStore((Map)temp);
        }
        catch (Exception temp) {
            // empty catch block
        }
        if (this.dataStore == null) {
            JDBCDataStoreFactory factory = this.setup.createDataStoreFactory();
            this.dataStore = factory.createDataStore(params);
        }
        this.setup.setUpDataStore(this.dataStore);
        this.dialect = this.dataStore.getSQLDialect();
    }

    protected abstract JDBCTestSetup createTestSetup();

    protected Map<String, Object> createDataStoreFactoryParams() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(JDBCDataStoreFactory.NAMESPACE.key, "http://www.geotools.org/test");
        String testSchema = this.getFixture().getProperty(JDBCDataStoreFactory.SCHEMA.key, "geotools");
        params.put(JDBCDataStoreFactory.SCHEMA.key, testSchema);
        params.put(JDBCDataStoreFactory.DATASOURCE.key, this.setup.getDataSource());
        params.put(JDBCDataStoreFactory.BATCH_INSERT_SIZE.key, 100);
        return params;
    }

    protected void disconnect() throws Exception {
        this.setup.tearDown();
        this.dataStore.dispose();
    }

    protected String tname(String raw) {
        return this.setup.typeName(raw);
    }

    protected String aname(String raw) {
        return this.setup.attributeName(raw);
    }

    protected Name aname(Name raw) {
        return new NameImpl(raw.getNamespaceURI(), this.aname(raw.getLocalPart()));
    }

    protected void assertFeatureTypesEqual(SimpleFeatureType expected, SimpleFeatureType actual) {
        for (int i = 0; i < expected.getAttributeCount(); ++i) {
            AttributeDescriptor expectedAttribute = expected.getDescriptor(i);
            AttributeDescriptor actualAttribute = actual.getDescriptor(i);
            this.assertAttributesEqual(expectedAttribute, actualAttribute);
        }
        if (expected.getGeometryDescriptor() != null) {
            GeometryDescriptor dg = actual.getGeometryDescriptor();
            Assert.assertTrue((boolean)dg.isNillable());
            Assert.assertEquals((long)0L, (long)dg.getMinOccurs());
        }
    }

    protected void assertAttributesEqual(AttributeDescriptor expected, AttributeDescriptor actual) {
        Assert.assertEquals((Object)this.aname(expected.getName()), (Object)actual.getName());
        Assert.assertEquals((long)expected.getMinOccurs(), (long)actual.getMinOccurs());
        Assert.assertEquals((long)expected.getMaxOccurs(), (long)actual.getMaxOccurs());
        Assert.assertEquals((Object)expected.isNillable(), (Object)actual.isNillable());
        Assert.assertEquals((Object)expected.getDefaultValue(), (Object)actual.getDefaultValue());
        AttributeType texpected = expected.getType();
        AttributeType tactual = actual.getType();
        if (Number.class.isAssignableFrom(texpected.getBinding())) {
            Assert.assertTrue((boolean)Number.class.isAssignableFrom(tactual.getBinding()));
        } else if (Geometry.class.isAssignableFrom(texpected.getBinding())) {
            Assert.assertTrue((boolean)Geometry.class.isAssignableFrom(tactual.getBinding()));
        } else {
            Assert.assertTrue((boolean)texpected.getBinding().isAssignableFrom(tactual.getBinding()));
        }
    }

    protected void assertAttributeValuesEqual(Object expected, Object actual) {
        if (expected == null) {
            Assert.assertNull((Object)actual);
            return;
        }
        if (expected instanceof Geometry) {
            Assert.assertTrue((boolean)((Geometry)expected).equals((Geometry)actual));
            return;
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    protected CoordinateReferenceSystem decodeEPSG(int epsgCode) throws FactoryException {
        return CRS.decode((String)String.format("EPSG:%d", epsgCode), (boolean)this.forceLongitudeFirst);
    }

    protected boolean areCRSEqual(CoordinateReferenceSystem crs1, CoordinateReferenceSystem crs2) {
        if (crs1 == null && crs2 == null) {
            return true;
        }
        if (crs1 == null) {
            return false;
        }
        return crs1.equals(crs2);
    }

    protected boolean areReferencedEnvelopesEqual(ReferencedEnvelope e1, ReferencedEnvelope e2) {
        boolean equal;
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        boolean bl = equal = Math.round(e1.getMinX()) == Math.round(e2.getMinX()) && Math.round(e1.getMinY()) == Math.round(e2.getMinY()) && Math.round(e1.getMaxX()) == Math.round(e2.getMaxX()) && Math.round(e1.getMaxY()) == Math.round(e2.getMaxY());
        if (!equal) {
            return false;
        }
        return this.areCRSEqual(e1.getCoordinateReferenceSystem(), e2.getCoordinateReferenceSystem());
    }

    protected <FT extends FeatureType, F extends Feature> void assertFeatureCollection(int startIndex, int numberExpected, FeatureCollection<FT, F> collection, FeatureAssertion<F> assertion) {
        this.assertFeatureIterator(startIndex, numberExpected, collection.features(), assertion);
    }

    protected <F extends Feature> void assertFeatureIterator(int startIndex, int numberExpected, FeatureIterator<F> iter, FeatureAssertion<F> assertion) {
        try (FeatureIterator<F> featureIterator = iter;){
            boolean[] loadedFeatures = new boolean[numberExpected];
            for (int j = startIndex; j < numberExpected + startIndex; ++j) {
                Feature feature = iter.next();
                Assert.assertNotNull((Object)feature);
                int i = assertion.toIndex(feature);
                Assert.assertTrue((loadedFeatures.length > i - startIndex ? 1 : 0) != 0);
                Assert.assertTrue((i > startIndex - 1 ? 1 : 0) != 0);
                Assert.assertFalse((boolean)loadedFeatures[i - startIndex]);
                loadedFeatures[i - startIndex] = true;
                assertion.check(i, feature);
            }
            Assert.assertFalse((boolean)iter.hasNext());
            for (int i = 0; i < numberExpected; ++i) {
                Assert.assertTrue((String)("feature " + i + " is missing"), (boolean)loadedFeatures[i]);
            }
        }
    }

    protected <F extends Feature> void assertFeatureIterator(int startIndex, int numberExpected, final Iterator<F> iterator, FeatureAssertion<F> assertion) {
        try (FeatureIterator adapter = new FeatureIterator<F>(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public F next() {
                return (Feature)iterator.next();
            }

            public void close() {
            }
        };){
            this.assertFeatureIterator(startIndex, numberExpected, adapter, assertion);
        }
    }

    protected <FT extends FeatureType, F extends Feature> void assertFeatureReader(int startIndex, int numberExpected, final FeatureReader<FT, F> reader, FeatureAssertion<F> assertion) throws IOException {
        try (FeatureIterator iter = new FeatureIterator<F>(){

            public boolean hasNext() {
                try {
                    return reader.hasNext();
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }

            public F next() throws NoSuchElementException {
                try {
                    return reader.next();
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }

            public void close() {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
        };){
            this.assertFeatureIterator(startIndex, numberExpected, iter, assertion);
        }
    }

    public static interface SimpleFeatureAssertion
    extends FeatureAssertion<SimpleFeature> {
    }

    public static interface FeatureAssertion<F extends Feature> {
        public int toIndex(F var1);

        public void check(int var1, F var2);
    }
}

