/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DataUtilities;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.WKTReader2;
import org.geotools.jdbc.JDBCGeometryTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public abstract class JDBCGeometryOnlineTest
extends JDBCTestSupport {
    @Override
    protected abstract JDBCGeometryTestSetup createTestSetup();

    @Test
    public void testPoint() throws Exception {
        Assert.assertEquals(Point.class, (Object)this.checkGeometryType(Point.class));
    }

    @Test
    public void testLineString() throws Exception {
        Assert.assertEquals(LineString.class, (Object)this.checkGeometryType(LineString.class));
    }

    @Test
    public void testLinearRing() throws Exception {
        Assert.assertEquals(LinearRing.class, (Object)this.checkGeometryType(LinearRing.class));
    }

    @Test
    public void testPolygon() throws Exception {
        Assert.assertEquals(Polygon.class, (Object)this.checkGeometryType(Polygon.class));
    }

    @Test
    public void testMultiPoint() throws Exception {
        Assert.assertEquals(MultiPoint.class, (Object)this.checkGeometryType(MultiPoint.class));
    }

    @Test
    public void testMultiLineString() throws Exception {
        Assert.assertEquals(MultiLineString.class, (Object)this.checkGeometryType(MultiLineString.class));
    }

    @Test
    public void testMultiPolygon() throws Exception {
        Assert.assertEquals(MultiPolygon.class, (Object)this.checkGeometryType(MultiPolygon.class));
    }

    @Test
    public void testMultiSurfaceLinearized() throws Exception {
        String featureTypeName = this.tname("tMultiPolygon");
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName("tMultiPolygon");
        ftb.add(this.aname("id"), Integer.class);
        ftb.add(this.aname("name"), String.class);
        ftb.add(this.aname("geom"), MultiPolygon.class, CRS.decode((String)"EPSG:4326"));
        SimpleFeatureType ft = ftb.buildFeatureType();
        this.dataStore.createSchema(ft);
        SimpleFeatureType newSchema = this.dataStore.getSchema(featureTypeName);
        Assert.assertNotNull((Object)newSchema);
        newSchema.getGeometryDescriptor().getType().getBinding();
        SimpleFeatureBuilder sfb = new SimpleFeatureBuilder(ft);
        WKTReader2 reader = new WKTReader2();
        sfb.set(this.aname("name"), (Object)"the name");
        sfb.set(this.aname("geom"), (Object)reader.read("MultiSurface (((1 0, 2 0, 2 1, 1 1, 1 0)))"));
        ContentFeatureStore store = (ContentFeatureStore)this.dataStore.getFeatureSource(featureTypeName);
        store.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)sfb.buildFeature("1")));
    }

    @Test
    public void testGeometry() throws Exception {
        Assert.assertEquals(Geometry.class, (Object)this.checkGeometryType(Geometry.class));
    }

    @Test
    public void testGeometryCollection() throws Exception {
        Assert.assertEquals(GeometryCollection.class, (Object)this.checkGeometryType(GeometryCollection.class));
    }

    protected Class checkGeometryType(Class geomClass) throws Exception {
        String featureTypeName = this.tname("t" + geomClass.getSimpleName());
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName(featureTypeName);
        ftb.add(this.aname("id"), Integer.class);
        ftb.add(this.aname("name"), String.class);
        ftb.add(this.aname("geom"), geomClass, crs);
        SimpleFeatureType newFT = ftb.buildFeatureType();
        this.dataStore.createSchema(newFT);
        SimpleFeatureType newSchema = this.dataStore.getSchema(featureTypeName);
        Assert.assertNotNull((Object)newSchema);
        Assert.assertEquals((long)3L, (long)newSchema.getAttributeCount());
        return newSchema.getGeometryDescriptor().getType().getBinding();
    }
}

