/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.Query;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCGeographyTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.VirtualTable;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;

public abstract class JDBCGeographyOnlineTest
extends JDBCTestSupport {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    GeometryFactory gf = new GeometryFactory();

    @Override
    protected abstract JDBCGeographyTestSetup createTestSetup();

    protected boolean isGeographySupportAvailable() throws Exception {
        boolean available = ((JDBCGeographyTestSetup)this.setup).isGeographySupportAvailable();
        if (!available) {
            System.out.println("Skipping geography tests as geography column support is not available");
        }
        return available;
    }

    @Test
    public void testSchema() throws Exception {
        Assume.assumeTrue((boolean)this.isGeographySupportAvailable());
        SimpleFeatureType ft = this.dataStore.getFeatureSource(this.tname("geopoint")).getSchema();
        Assert.assertNotNull((Object)ft);
        Assert.assertTrue((boolean)(ft.getDescriptor(this.aname("geo")) instanceof GeometryDescriptor));
        Assert.assertEquals(Point.class, (Object)ft.getDescriptor("geo").getType().getBinding());
        int epsg = CRS.lookupEpsgCode((CoordinateReferenceSystem)((GeometryDescriptor)ft.getDescriptor(this.aname("geo"))).getCoordinateReferenceSystem(), (boolean)false);
        Assert.assertEquals((long)4326L, (long)epsg);
    }

    @Test
    public void testReader() throws Exception {
        Assume.assumeTrue((boolean)this.isGeographySupportAvailable());
        Query q = new Query(this.tname("geopoint"));
        try (FeatureReader r = this.dataStore.getFeatureReader(q, Transaction.AUTO_COMMIT);){
            Assert.assertTrue((boolean)r.hasNext());
            while (r.hasNext()) {
                SimpleFeature f = (SimpleFeature)r.next();
                Assert.assertTrue((boolean)(f.getAttribute(this.aname("geo")) instanceof Point));
            }
        }
    }

    @Test
    public void testBBoxLargerThanWorld() throws Exception {
        Assume.assumeTrue((boolean)this.isGeographySupportAvailable());
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        BBOX bbox = ff.bbox("", -200.0, -200.0, 200.0, 200.0, "EPSG:4326");
        Query q = new Query(this.tname("geopoint"));
        q.setFilter((Filter)bbox);
        try (FeatureReader r = this.dataStore.getFeatureReader(q, Transaction.AUTO_COMMIT);){
            Assert.assertTrue((boolean)r.hasNext());
            while (r.hasNext()) {
                SimpleFeature f = (SimpleFeature)r.next();
                Assert.assertTrue((boolean)(f.getAttribute(this.aname("geo")) instanceof Point));
            }
        }
    }

    @Test
    public void testOutsideWorld() throws Exception {
        Assume.assumeTrue((boolean)this.isGeographySupportAvailable());
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        BBOX bbox = ff.bbox("", -300.0, -40.0, -200.0, 40.0, "EPSG:4326");
        Query q = new Query(this.tname("geopoint"));
        q.setFilter((Filter)bbox);
        try (FeatureReader r = this.dataStore.getFeatureReader(q, Transaction.AUTO_COMMIT);){
            Assert.assertFalse((boolean)r.hasNext());
        }
    }

    @Test
    public void testLargerThanHalfWorld() throws Exception {
        Assume.assumeTrue((boolean)this.isGeographySupportAvailable());
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        BBOX bbox = ff.bbox("", -140.0, -50.0, 140.0, 50.0, "EPSG:4326");
        Query q = new Query(this.tname("geopoint"));
        q.setFilter((Filter)bbox);
        try (FeatureReader r = this.dataStore.getFeatureReader(q, Transaction.AUTO_COMMIT);){
            Assert.assertTrue((boolean)r.hasNext());
            while (r.hasNext()) {
                SimpleFeature f = (SimpleFeature)r.next();
                Assert.assertTrue((boolean)(f.getAttribute(this.aname("geo")) instanceof Point));
            }
        }
    }

    @Test
    public void testUpdate() throws Exception {
        SimpleFeature f;
        Assume.assumeTrue((boolean)this.isGeographySupportAvailable());
        Point p = this.gf.createPoint(new Coordinate(1.0, 1.0));
        try (FeatureWriter fw = this.dataStore.getFeatureWriter(this.tname("geopoint"), Transaction.AUTO_COMMIT);){
            Assert.assertTrue((boolean)fw.hasNext());
            while (fw.hasNext()) {
                f = (SimpleFeature)fw.next();
                f.setDefaultGeometry((Object)p);
                fw.write();
            }
        }
        try (FeatureReader fr = this.dataStore.getFeatureReader(new Query(this.tname("geopoint")), Transaction.AUTO_COMMIT);){
            while (fr.hasNext()) {
                f = (SimpleFeature)fr.next();
                Assert.assertEquals((Object)p, (Object)f.getDefaultGeometry());
            }
        }
    }

    @Test
    public void testAppend() throws Exception {
        Assume.assumeTrue((boolean)this.isGeographySupportAvailable());
        Point point = this.gf.createPoint(new Coordinate(10.0, 10.0));
        try (FeatureWriter fw = this.dataStore.getFeatureWriterAppend(this.tname("geopoint"), Transaction.AUTO_COMMIT);){
            Assert.assertFalse((boolean)fw.hasNext());
            SimpleFeature f = (SimpleFeature)fw.next();
            f.setAttribute("name", (Object)"append");
            f.setDefaultGeometry((Object)point);
            fw.write();
        }
        PropertyIsEqualTo filter = this.ff.equals((Expression)this.ff.property("name"), (Expression)this.ff.literal((Object)"append"));
        Query q = new Query(this.tname("geopoint"), (Filter)filter);
        try (FeatureReader fr = this.dataStore.getFeatureReader(q, Transaction.AUTO_COMMIT);){
            Assert.assertTrue((boolean)fr.hasNext());
            SimpleFeature f = (SimpleFeature)fr.next();
            Assert.assertEquals((Object)point, (Object)f.getDefaultGeometry());
        }
    }

    @Test
    public void testBounds() throws Exception {
        Assume.assumeTrue((boolean)this.isGeographySupportAvailable());
        ReferencedEnvelope env = this.dataStore.getFeatureSource(this.tname("geopoint")).getBounds();
        ReferencedEnvelope expected = new ReferencedEnvelope(-110.0, 0.0, 29.0, 49.0, this.decodeEPSG(4326));
        Assert.assertEquals((Object)expected, (Object)env);
    }

    @Test
    public void testBboxFilter() throws Exception {
        Assume.assumeTrue((boolean)this.isGeographySupportAvailable());
        BBOX bbox = this.ff.bbox(this.aname("geo"), -120.0, 25.0, -100.0, 40.0, "EPSG:4326");
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("geopoint")).getFeatures((Filter)bbox);
        Assert.assertEquals((long)2L, (long)features.size());
    }

    @Test
    public void testDistanceMeters() throws Exception {
        Assume.assumeTrue((boolean)this.isGeographySupportAvailable());
        DWithin filter = this.ff.dwithin((Expression)this.ff.property(this.aname("geo")), (Expression)this.ff.literal((Object)this.gf.createPoint(new Coordinate(1.0, 49.0))), 74000.0, "metre");
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("geopoint")).getFeatures((Filter)filter);
        Assert.assertEquals((long)1L, (long)features.size());
    }

    @Test
    public void testDistanceGreatCircle() throws Exception {
        Assume.assumeTrue((boolean)this.isGeographySupportAvailable());
        try (FeatureWriter fw = this.dataStore.getFeatureWriterAppend(this.tname("geopoint"), Transaction.AUTO_COMMIT);){
            SimpleFeature f = (SimpleFeature)fw.next();
            Point point = this.gf.createPoint(new Coordinate(-21.96, 64.15));
            f.setAttribute("name", (Object)"Reykjavik");
            f.setDefaultGeometry((Object)point);
            fw.write();
        }
        LineString line = this.gf.createLineString(new Coordinate[]{new Coordinate(-122.33, 47.606), new Coordinate(0.0, 51.5)});
        DWithin filter = this.ff.dwithin((Expression)this.ff.property(this.aname("geo")), (Expression)this.ff.literal((Object)line), 130000.0, "metre");
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("geopoint")).getFeatures((Filter)filter);
        Assert.assertEquals((long)1L, (long)features.size());
        try (FeatureIterator fi = features.features();){
            Assert.assertTrue((boolean)fi.hasNext());
            SimpleFeature feature = (SimpleFeature)fi.next();
            Assert.assertEquals((Object)"Reykjavik", (Object)feature.getAttribute("name"));
        }
    }

    @Test
    public void testVirtualTable() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("select * from ");
        this.dialect.encodeTableName(this.tname("geopoint"), sb);
        VirtualTable vt = new VirtualTable("geopoint_vt", sb.toString());
        this.dataStore.createVirtualTable(vt);
        SimpleFeatureType featureType = this.dataStore.getSchema("geopoint_vt");
        Assert.assertNotNull((Object)featureType);
        Assert.assertNotNull((Object)featureType.getGeometryDescriptor());
    }
}

