/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.HashMap;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.JDBCUDTTestSetup;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public abstract class JDBCUDTOnlineTest
extends JDBCTestSupport {
    @Override
    protected abstract JDBCUDTTestSetup createTestSetup();

    public void testSchema() throws Exception {
        SimpleFeatureType type = this.dataStore.getSchema(this.tname("udt"));
        JDBCUDTOnlineTest.assertNotNull((Object)type);
        JDBCUDTOnlineTest.assertNotNull((Object)type.getDescriptor(this.aname("ut")));
        JDBCUDTOnlineTest.assertEquals(String.class, (Object)type.getDescriptor(this.aname("ut")).getType().getBinding());
    }

    public void testRead() throws Exception {
        SimpleFeatureType type = this.dataStore.getSchema(this.tname("udt"));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("udt")).getFeatures();
        try (SimpleFeatureIterator fi = features.features();){
            JDBCUDTOnlineTest.assertTrue((boolean)fi.hasNext());
            JDBCUDTOnlineTest.assertEquals((Object)"12ab", (Object)((SimpleFeature)fi.next()).getAttribute(this.aname("ut")));
            JDBCUDTOnlineTest.assertFalse((boolean)fi.hasNext());
        }
    }

    public void testWrite() throws Exception {
        int count = this.dataStore.getFeatureSource(this.tname("udt")).getCount(Query.ALL);
        try (FeatureWriter w = this.dataStore.getFeatureWriterAppend(this.tname("udt"), Transaction.AUTO_COMMIT);){
            w.hasNext();
            SimpleFeature f = (SimpleFeature)w.next();
            f.setAttribute(this.aname("ut"), (Object)"abcd");
            try {
                w.write();
                JDBCUDTOnlineTest.fail((String)"Write should have failed with UDT constraint failure");
            }
            catch (Exception exception) {
                // empty catch block
            }
            f.setAttribute(this.aname("ut"), (Object)"34cd");
            w.write();
        }
        JDBCUDTOnlineTest.assertEquals((int)(count + 1), (int)this.dataStore.getFeatureSource(this.tname("udt")).getCount(Query.ALL));
    }

    @Override
    protected HashMap createDataStoreFactoryParams() throws Exception {
        HashMap params = super.createDataStoreFactoryParams();
        params.put(JDBCDataStoreFactory.BATCH_INSERT_SIZE.key, 1);
        return params;
    }
}

