/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.Arrays;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.JDBCThreeValuedLogicTestSetup;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Not;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.expression.Expression;

public abstract class JDBCThreeValuedLogicOnlineTest
extends JDBCTestSupport {
    protected static final String ABC = "abc";
    protected static final String NAME = "name";
    protected static final String A = "a";
    protected static final String B = "b";
    protected static final String C = "c";
    protected FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    @Override
    protected abstract JDBCThreeValuedLogicTestSetup createTestSetup();

    public void testSimpleNegation() throws Exception {
        Not filter = this.ff.not((Filter)this.ff.equal((Expression)this.ff.property(this.aname(A)), (Expression)this.ff.literal(10), false));
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname(ABC));
        int count = fs.getCount(new Query(this.tname(ABC), (Filter)filter));
        JDBCThreeValuedLogicOnlineTest.assertEquals((int)2, (int)count);
    }

    public void testBetweenNegation() throws Exception {
        Not filter = this.ff.not((Filter)this.ff.between((Expression)this.ff.property(this.aname(B)), (Expression)this.ff.property(this.aname(A)), (Expression)this.ff.property(this.aname(C))));
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname(ABC));
        Query q = new Query(this.tname(ABC), (Filter)filter);
        int count = fs.getCount(q);
        JDBCThreeValuedLogicOnlineTest.assertEquals((int)1, (int)count);
        SimpleFeature f = (SimpleFeature)DataUtilities.first((FeatureCollection)fs.getFeatures(q));
        JDBCThreeValuedLogicOnlineTest.assertEquals((Object)"n_n_n", (Object)f.getAttribute(this.aname(NAME)));
    }

    public void testNegateOr() throws Exception {
        PropertyIsGreaterThan fa = this.ff.greater((Expression)this.ff.property(this.aname(A)), (Expression)this.ff.literal(3));
        PropertyIsEqualTo fb = this.ff.equal((Expression)this.ff.property(this.aname(B)), (Expression)this.ff.literal(5), false);
        PropertyIsLessThan fc = this.ff.less((Expression)this.ff.property(this.aname(C)), (Expression)this.ff.literal(0));
        Not filter = this.ff.not((Filter)this.ff.and(Arrays.asList(fa, fb, fc)));
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname(ABC));
        Query q = new Query(this.tname(ABC), (Filter)filter);
        int count = fs.getCount(q);
        JDBCThreeValuedLogicOnlineTest.assertEquals((int)2, (int)count);
    }

    public void test() throws Exception {
        Not filter = this.ff.not((Filter)this.ff.between((Expression)this.ff.property(this.aname(B)), (Expression)this.ff.property(this.aname(A)), (Expression)this.ff.property(this.aname(C))));
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname(ABC));
        Query q = new Query(this.tname(ABC), (Filter)filter);
        int count = fs.getCount(q);
        JDBCThreeValuedLogicOnlineTest.assertEquals((int)1, (int)count);
        SimpleFeature f = (SimpleFeature)DataUtilities.first((FeatureCollection)fs.getFeatures(q));
        JDBCThreeValuedLogicOnlineTest.assertEquals((Object)"n_n_n", (Object)f.getAttribute(this.aname(NAME)));
    }
}

