/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.FeatureReader;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.JDBCTestSetup;
import org.geotools.jdbc.SQLDialect;
import org.geotools.test.OnlineTestCase;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class JDBCTestSupport
extends OnlineTestCase {
    static final Logger LOGGER = Logging.getLogger(JDBCTestSupport.class);
    protected JDBCTestSetup setup;
    protected JDBCDataStore dataStore;
    protected SQLDialect dialect;

    protected Properties createOfflineFixture() {
        return this.createTestSetup().createOfflineFixture();
    }

    protected Properties createExampleFixture() {
        return this.createTestSetup().createExampleFixture();
    }

    protected String getFixtureId() {
        return this.createTestSetup().createDataStoreFactory().getDatabaseID();
    }

    protected boolean isOnline() throws Exception {
        JDBCTestSetup setup = this.createTestSetup();
        setup.setFixture(this.fixture);
        try {
            DataSource dataSource = setup.getDataSource();
            Connection cx = dataSource.getConnection();
            cx.close();
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            try {
                setup.tearDown();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error occurred tearing down the test setup", e);
            }
        }
    }

    protected void connect() throws Exception {
        if (this.setup == null) {
            this.setup = this.createTestSetup();
        }
        this.setup.setFixture(this.fixture);
        this.setup.setUp();
        this.setup.initializeDatabase();
        this.setup.setUpData();
        HashMap params = this.createDataStoreFactoryParams();
        try {
            HashMap temp = (HashMap)params.clone();
            temp.putAll(this.fixture);
            this.dataStore = (JDBCDataStore)DataStoreFinder.getDataStore((Map)temp);
        }
        catch (Exception temp) {
            // empty catch block
        }
        if (this.dataStore == null) {
            JDBCDataStoreFactory factory = this.setup.createDataStoreFactory();
            this.dataStore = factory.createDataStore((Map)params);
        }
        this.setup.setUpDataStore(this.dataStore);
        this.dialect = this.dataStore.getSQLDialect();
    }

    protected abstract JDBCTestSetup createTestSetup();

    protected HashMap createDataStoreFactoryParams() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(JDBCDataStoreFactory.NAMESPACE.key, "http://www.geotools.org/test");
        params.put(JDBCDataStoreFactory.SCHEMA.key, "geotools");
        params.put(JDBCDataStoreFactory.DATASOURCE.key, this.setup.getDataSource());
        params.put(JDBCDataStoreFactory.BATCH_INSERT_SIZE.key, 100);
        return params;
    }

    protected void disconnect() throws Exception {
        this.setup.tearDown();
        this.dataStore.dispose();
    }

    protected String tname(String raw) {
        return this.setup.typeName(raw);
    }

    protected String aname(String raw) {
        return this.setup.attributeName(raw);
    }

    protected Name aname(Name raw) {
        return new NameImpl(raw.getNamespaceURI(), this.aname(raw.getLocalPart()));
    }

    protected void assertFeatureTypesEqual(SimpleFeatureType expected, SimpleFeatureType actual) {
        for (int i = 0; i < expected.getAttributeCount(); ++i) {
            AttributeDescriptor expectedAttribute = expected.getDescriptor(i);
            AttributeDescriptor actualAttribute = actual.getDescriptor(i);
            this.assertAttributesEqual(expectedAttribute, actualAttribute);
        }
        if (expected.getGeometryDescriptor() != null) {
            GeometryDescriptor dg = actual.getGeometryDescriptor();
            JDBCTestSupport.assertTrue((boolean)dg.isNillable());
            JDBCTestSupport.assertEquals((int)0, (int)dg.getMinOccurs());
        }
    }

    protected void assertAttributesEqual(AttributeDescriptor expected, AttributeDescriptor actual) {
        JDBCTestSupport.assertEquals((Object)this.aname(expected.getName()), (Object)actual.getName());
        JDBCTestSupport.assertEquals((int)expected.getMinOccurs(), (int)actual.getMinOccurs());
        JDBCTestSupport.assertEquals((int)expected.getMaxOccurs(), (int)actual.getMaxOccurs());
        JDBCTestSupport.assertEquals((boolean)expected.isNillable(), (boolean)actual.isNillable());
        JDBCTestSupport.assertEquals((Object)expected.getDefaultValue(), (Object)actual.getDefaultValue());
        AttributeType texpected = expected.getType();
        AttributeType tactual = actual.getType();
        if (Number.class.isAssignableFrom(texpected.getBinding())) {
            JDBCTestSupport.assertTrue((boolean)Number.class.isAssignableFrom(tactual.getBinding()));
        } else if (Geometry.class.isAssignableFrom(texpected.getBinding())) {
            JDBCTestSupport.assertTrue((boolean)Geometry.class.isAssignableFrom(tactual.getBinding()));
        } else {
            JDBCTestSupport.assertTrue((boolean)texpected.getBinding().isAssignableFrom(tactual.getBinding()));
        }
    }

    protected void assertAttributeValuesEqual(Object expected, Object actual) {
        if (expected == null) {
            JDBCTestSupport.assertNull((Object)actual);
            return;
        }
        if (expected instanceof Geometry) {
            JDBCTestSupport.assertTrue((boolean)((Geometry)expected).equals((Geometry)actual));
            return;
        }
        JDBCTestSupport.assertEquals((Object)expected, (Object)actual);
    }

    protected boolean areCRSEqual(CoordinateReferenceSystem crs1, CoordinateReferenceSystem crs2) {
        if (crs1 == null && crs2 == null) {
            return true;
        }
        if (crs1 == null) {
            return false;
        }
        return crs1.equals(crs2);
    }

    protected boolean areReferencedEnvelopesEqual(ReferencedEnvelope e1, ReferencedEnvelope e2) {
        boolean equal;
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        boolean bl = equal = Math.round(e1.getMinX()) == Math.round(e2.getMinX()) && Math.round(e1.getMinY()) == Math.round(e2.getMinY()) && Math.round(e1.getMaxX()) == Math.round(e2.getMaxX()) && Math.round(e1.getMaxY()) == Math.round(e2.getMaxY());
        if (!equal) {
            return false;
        }
        return this.areCRSEqual(e1.getCoordinateReferenceSystem(), e2.getCoordinateReferenceSystem());
    }

    protected <FT extends FeatureType, F extends Feature> void assertFeatureCollection(int startIndex, int numberExpected, FeatureCollection<FT, F> collection, FeatureAssertion assertion) {
        this.assertFeatureIterator(startIndex, numberExpected, collection.features(), assertion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <F extends Feature> void assertFeatureIterator(int startIndex, int numberExpected, FeatureIterator<F> iter, FeatureAssertion assertion) {
        try {
            boolean[] loadedFeatures = new boolean[numberExpected];
            for (int j = startIndex; j < numberExpected + startIndex; ++j) {
                Feature feature = iter.next();
                JDBCTestSupport.assertNotNull((Object)feature);
                int i = assertion.toIndex(feature);
                JDBCTestSupport.assertTrue((loadedFeatures.length > i - startIndex ? 1 : 0) != 0);
                JDBCTestSupport.assertTrue((i > startIndex - 1 ? 1 : 0) != 0);
                JDBCTestSupport.assertFalse((boolean)loadedFeatures[i - startIndex]);
                loadedFeatures[i - startIndex] = true;
                assertion.check(i, feature);
            }
            JDBCTestSupport.assertFalse((boolean)iter.hasNext());
            for (int i = 0; i < numberExpected; ++i) {
                JDBCTestSupport.assertTrue((String)("feature " + i + " is missing"), (boolean)loadedFeatures[i]);
            }
        }
        finally {
            iter.close();
        }
    }

    protected <F extends Feature> void assertFeatureIterator(int startIndex, int numberExpected, final Iterator<F> iterator, FeatureAssertion assertion) {
        FeatureIterator adapter = new FeatureIterator<F>(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public F next() {
                return (Feature)iterator.next();
            }

            public void close() {
            }
        };
        this.assertFeatureIterator(startIndex, numberExpected, adapter, assertion);
    }

    protected <FT extends FeatureType, F extends Feature> void assertFeatureReader(int startIndex, int numberExpected, final FeatureReader<FT, F> reader, FeatureAssertion assertion) throws IOException {
        FeatureIterator iter = new FeatureIterator<F>(){

            public boolean hasNext() {
                try {
                    return reader.hasNext();
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }

            public F next() throws NoSuchElementException {
                try {
                    return reader.next();
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }

            public void close() {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
        };
        this.assertFeatureIterator(startIndex, numberExpected, iter, assertion);
    }

    public static interface SimpleFeatureAssertion
    extends FeatureAssertion<SimpleFeature> {
    }

    public static interface FeatureAssertion<F extends Feature> {
        public int toIndex(F var1);

        public void check(int var1, F var2);
    }
}

