/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCSkipColumnTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public abstract class JDBCSkipColumnOnlineTest
extends JDBCTestSupport {
    protected static final String SKIPCOLUMN = "skipcolumn";
    protected static final String ID = "id";
    protected static final String NAME = "name";
    protected static final String GEOM = "geom";
    protected SimpleFeatureType schema;

    @Override
    protected abstract JDBCSkipColumnTestSetup createTestSetup();

    @Override
    protected void connect() throws Exception {
        super.connect();
        this.schema = DataUtilities.createType((String)(this.dataStore.getNamespaceURI() + "." + SKIPCOLUMN), (String)"id:0,geom:Point,name:String");
    }

    public void testSkippedColumn() throws Exception {
        SimpleFeatureType ft = this.dataStore.getSchema(this.tname(SKIPCOLUMN));
        this.assertFeatureTypesEqual(this.schema, ft);
    }

    public void testReadFeatures() throws Exception {
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname(SKIPCOLUMN)).getFeatures();
        JDBCSkipColumnOnlineTest.assertEquals((int)1, (int)fc.size());
        try (SimpleFeatureIterator fr = fc.features();){
            JDBCSkipColumnOnlineTest.assertTrue((boolean)fr.hasNext());
            SimpleFeature f = (SimpleFeature)fr.next();
            JDBCSkipColumnOnlineTest.assertFalse((boolean)fr.hasNext());
        }
    }

    public void testGetBounds() throws Exception {
        ReferencedEnvelope env = this.dataStore.getFeatureSource(this.tname(SKIPCOLUMN)).getBounds();
        JDBCSkipColumnOnlineTest.assertEquals((Object)0.0, (Object)env.getMinX());
        JDBCSkipColumnOnlineTest.assertEquals((Object)0.0, (Object)env.getMinY());
        JDBCSkipColumnOnlineTest.assertEquals((Object)0.0, (Object)env.getMaxX());
        JDBCSkipColumnOnlineTest.assertEquals((Object)0.0, (Object)env.getMaxY());
    }
}

