/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.Collections;
import junit.framework.TestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.jdbc.AutoGeneratedPrimaryKeyColumn;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JDBCPrimaryKeyTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.NonIncrementingPrimaryKeyColumn;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.jdbc.SequencedPrimaryKeyColumn;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;

public abstract class JDBCPrimaryKeyOnlineTest
extends JDBCTestSupport {
    @Override
    protected abstract JDBCPrimaryKeyTestSetup createTestSetup();

    @Override
    protected void connect() throws Exception {
        super.connect();
        if (this.setup.canResetSchema()) {
            this.dataStore.setDatabaseSchema(null);
        }
    }

    public void testAutoGeneratedPrimaryKey() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("auto"));
        JDBCPrimaryKeyOnlineTest.assertEquals((int)1, (int)fs.getPrimaryKey().getColumns().size());
        JDBCPrimaryKeyOnlineTest.assertTrue((boolean)(fs.getPrimaryKey().getColumns().get(0) instanceof AutoGeneratedPrimaryKeyColumn));
        JDBCPrimaryKeyOnlineTest.assertNull((Object)fs.getSchema().getDescriptor(((PrimaryKeyColumn)fs.getPrimaryKey().getColumns().get(0)).getName()));
        ContentFeatureCollection features = fs.getFeatures();
        this.assertPrimaryKeyValues((FeatureCollection)features, 3);
        this.addFeature(fs.getSchema(), fs);
        this.assertPrimaryKeyValues((FeatureCollection)features, 4);
    }

    public void testSequencedPrimaryKey() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("seq"));
        JDBCPrimaryKeyOnlineTest.assertEquals((int)1, (int)fs.getPrimaryKey().getColumns().size());
        JDBCPrimaryKeyOnlineTest.assertTrue((boolean)(fs.getPrimaryKey().getColumns().get(0) instanceof SequencedPrimaryKeyColumn));
        ContentFeatureCollection features = fs.getFeatures();
        this.assertPrimaryKeyValues((FeatureCollection)features, 3);
        this.addFeature(fs.getSchema(), fs);
        this.assertPrimaryKeyValues((FeatureCollection)features, 4);
    }

    public void testNonIncrementingPrimaryKey() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("noninc"));
        JDBCPrimaryKeyOnlineTest.assertEquals((int)1, (int)fs.getPrimaryKey().getColumns().size());
        JDBCPrimaryKeyOnlineTest.assertTrue((boolean)(fs.getPrimaryKey().getColumns().get(0) instanceof NonIncrementingPrimaryKeyColumn));
        ContentFeatureCollection features = fs.getFeatures();
        this.assertPrimaryKeyValues((FeatureCollection)features, 3);
        this.addFeature(fs.getSchema(), fs);
        this.assertPrimaryKeyValues((FeatureCollection)features, 4);
    }

    protected void addFeature(SimpleFeatureType featureType, JDBCFeatureStore features) throws Exception {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(featureType);
        b.add((Object)"four");
        b.add((Object)new GeometryFactory().createPoint(new Coordinate(4.0, 4.0)));
        SimpleFeature f = b.buildFeature(null);
        features.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)f));
        JDBCPrimaryKeyOnlineTest.assertTrue((boolean)((String)f.getUserData().get("fid")).matches(this.tname(featureType.getTypeName()) + ".4(\\..*)?"));
    }

    protected void assertPrimaryKeyValues(final FeatureCollection features, int count) throws Exception {
        this.assertFeatureIterator(1, count, features.features(), (JDBCTestSupport.FeatureAssertion)new JDBCTestSupport.SimpleFeatureAssertion(){

            @Override
            public int toIndex(SimpleFeature feature) {
                return Integer.parseInt(feature.getID().split("\\.", 2)[1]);
            }

            @Override
            public void check(int index, SimpleFeature feature) {
                TestCase.assertEquals((String)(JDBCPrimaryKeyOnlineTest.this.tname(features.getSchema().getName().getLocalPart()) + "." + index), (String)feature.getID());
            }
        });
    }

    public void testMultiColumnPrimaryKey() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("multi"));
        JDBCPrimaryKeyOnlineTest.assertEquals((int)2, (int)fs.getPrimaryKey().getColumns().size());
        ContentFeatureCollection features = fs.getFeatures();
        this.assertMultiPrimaryKeyValues((FeatureCollection)features, 3);
        this.addFeature(fs.getSchema(), fs);
        this.assertMultiPrimaryKeyValues((FeatureCollection)features, 4);
        FilterFactory ff = this.dataStore.getFilterFactory();
        Id id = ff.id(Collections.singleton(ff.featureId(this.tname("multi") + ".1.x")));
        features = fs.getFeatures((Filter)id);
        JDBCPrimaryKeyOnlineTest.assertEquals((int)1, (int)features.size());
    }

    void assertMultiPrimaryKeyValues(FeatureCollection features, int count) throws Exception {
        this.assertFeatureIterator(1, count, features.features(), (JDBCTestSupport.FeatureAssertion)new JDBCTestSupport.SimpleFeatureAssertion(){
            String[] xyz = new String[]{"x", "y", "z"};

            @Override
            public int toIndex(SimpleFeature feature) {
                return Integer.parseInt(feature.getID().split("\\.")[1]);
            }

            @Override
            public void check(int index, SimpleFeature feature) {
                if (index < 4) {
                    TestCase.assertEquals((String)(JDBCPrimaryKeyOnlineTest.this.tname("multi") + "." + index + "." + this.xyz[index - 1]), (String)feature.getID());
                } else {
                    TestCase.assertTrue((boolean)feature.getID().startsWith(JDBCPrimaryKeyOnlineTest.this.tname("multi") + ".4."));
                }
            }
        });
    }

    public void testNullPrimaryKey() throws Exception {
        JDBCFeatureSource fs = (JDBCFeatureSource)this.dataStore.getFeatureSource(this.tname("nokey"));
        JDBCPrimaryKeyOnlineTest.assertFalse((boolean)(fs instanceof FeatureStore));
    }

    public void testUniqueIndex() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("uniq"));
        JDBCPrimaryKeyOnlineTest.assertEquals((int)1, (int)fs.getPrimaryKey().getColumns().size());
        JDBCPrimaryKeyOnlineTest.assertTrue((boolean)(fs.getPrimaryKey().getColumns().get(0) instanceof NonIncrementingPrimaryKeyColumn));
        JDBCPrimaryKeyOnlineTest.assertNull((Object)fs.getSchema().getDescriptor(((PrimaryKeyColumn)fs.getPrimaryKey().getColumns().get(0)).getName()));
        ContentFeatureCollection features = fs.getFeatures();
        this.assertPrimaryKeyValues((FeatureCollection)features, 3);
        this.addFeature(fs.getSchema(), fs);
        this.assertPrimaryKeyValues((FeatureCollection)features, 4);
    }

    public void testExposePrimaryKeyColumns() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("noninc"));
        JDBCPrimaryKeyOnlineTest.assertEquals((int)2, (int)fs.getSchema().getAttributeCount());
        fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("noninc"));
        fs.setExposePrimaryKeyColumns(true);
        JDBCPrimaryKeyOnlineTest.assertEquals((int)3, (int)fs.getSchema().getAttributeCount());
    }

    public void testUpdateWithExposePrimaryKeyColumns() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("nonfirst"));
        fs.setExposePrimaryKeyColumns(true);
        String key = null;
        for (AttributeDescriptor ad : fs.getSchema().getAttributeDescriptors()) {
            if (!Number.class.isAssignableFrom(ad.getType().getBinding())) continue;
            key = ad.getLocalName();
            break;
        }
        JDBCPrimaryKeyOnlineTest.assertNotNull(key);
        Object keyValue = null;
        try (FeatureReader r = fs.getReader();){
            JDBCPrimaryKeyOnlineTest.assertTrue((boolean)r.hasNext());
            SimpleFeature f = (SimpleFeature)r.next();
            keyValue = f.getAttribute(key);
        }
        JDBCPrimaryKeyOnlineTest.assertNotNull((Object)keyValue);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        PropertyIsEqualTo filter = ff.equal((Expression)ff.property(key), (Expression)ff.literal(keyValue), false);
        JDBCPrimaryKeyOnlineTest.assertEquals((int)1, (int)fs.getCount(new Query(this.tname("nonfirst"), (Filter)filter)));
        try {
            fs.modifyFeatures(key, (Object)10, (Filter)filter);
            JDBCPrimaryKeyOnlineTest.fail((String)"expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        fs.modifyFeatures(new String[]{this.aname("name"), key, this.aname("geom")}, new Object[]{"foo", 10, null}, (Filter)filter);
        try (FeatureReader r = fs.getReader((Filter)ff.equal((Expression)ff.property(key), (Expression)ff.literal(keyValue), true));){
            JDBCPrimaryKeyOnlineTest.assertTrue((boolean)r.hasNext());
            SimpleFeature f = (SimpleFeature)r.next();
            JDBCPrimaryKeyOnlineTest.assertEquals((Object)"foo", (Object)f.getAttribute(this.aname("name")));
        }
    }
}

