/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.ArrayList;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.NativeFilter;
import org.opengis.filter.spatial.BBOX;

public abstract class JDBCNativeFilterOnlineTest
extends JDBCTestSupport {
    protected final FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2(null);

    public void testNativeFilterExecution() throws Exception {
        BBOX boundingBoxFilter = this.filterFactory.bbox(this.tname("location"), -5.0, -5.0, 5.0, 5.0, DefaultGeographicCRS.WGS84.toString());
        And filter = this.filterFactory.and((Filter)boundingBoxFilter, (Filter)this.getNativeFilter());
        ContentFeatureSource featureSource = this.dataStore.getFeatureSource(this.tname("gt_jdbc_test_measurements"));
        Assert.assertThat((Object)featureSource, (Matcher)CoreMatchers.notNullValue());
        SimpleFeatureIterator iterator = featureSource.getFeatures((Filter)filter).features();
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        while (iterator.hasNext()) {
            features.add((SimpleFeature)iterator.next());
        }
        iterator.close();
        Assert.assertThat((Object)features.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((SimpleFeature)features.get(0)).getAttribute(this.tname("code")), (Matcher)CoreMatchers.is((Object)"#2"));
    }

    protected abstract NativeFilter getNativeFilter();
}

