/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.jdbc.JDBCTestSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;

public abstract class JDBCMeasuredGeometriesOnlineTest
extends JDBCTestSupport {
    public void testRetrievingPointM() {
        List<SimpleFeature> features = this.getFeatures("points_m", Query.ALL);
        this.checkPointCoordinates(this.findOne(features, "description", "point_m_a"), 3, 1, -2.0, 1.0, 0.5);
        this.checkPointCoordinates(this.findOne(features, "description", "point_m_b"), 3, 1, 3.0, 1.0, -1.0);
        this.checkPointCoordinates(this.findOne(features, "description", "point_m_c"), 3, 1, 3.0, 5.0, 2.0);
        this.checkPointCoordinates(this.findOne(features, "description", "point_m_d"), 3, 1, -2.0, 5.0, -3.5);
    }

    public void testRetrievingPointZM() {
        List<SimpleFeature> features = this.getFeatures("points_zm", Query.ALL);
        this.checkPointCoordinates(this.findOne(features, "description", "point_zm_a"), 4, 1, -2.0, 1.0, 10.0, 0.5);
        this.checkPointCoordinates(this.findOne(features, "description", "point_zm_b"), 4, 1, 3.0, 1.0, 15.0, -1.0);
        this.checkPointCoordinates(this.findOne(features, "description", "point_zm_c"), 4, 1, 3.0, 5.0, 20.0, 2.0);
        this.checkPointCoordinates(this.findOne(features, "description", "point_zm_d"), 4, 1, -2.0, 5.0, 25.0, -3.5);
    }

    public void testRetrievingLineM() {
        List<SimpleFeature> features = this.getFeatures("lines_m", Query.ALL);
        double[] ordinates = new double[]{-2.0, 1.0, 0.5, 3.0, 1.0, -1.0, 3.0, 5.0, 2.0, -2.0, 5.0, 3.5};
        this.checkLineCoordinates(this.findOne(features, "description", "line_m_a"), 3, 1, ordinates);
    }

    public void testRetrievingLineZM() {
        List<SimpleFeature> features = this.getFeatures("lines_zm", Query.ALL);
        double[] ordinates = new double[]{-2.0, 1.0, 10.0, 0.5, 3.0, 1.0, 15.0, -1.0, 3.0, 5.0, 20.0, 2.0, -2.0, 5.0, 25.0, 3.5};
        this.checkLineCoordinates(this.findOne(features, "description", "line_zm_a"), 4, 1, ordinates);
    }

    private void checkLineCoordinates(SimpleFeature feature, int dimension, int measures, double ... ordinates) {
        Object candidate = feature.getDefaultGeometry();
        Assert.assertThat((Object)candidate, (Matcher)CoreMatchers.instanceOf(LineString.class));
        LineString line = (LineString)candidate;
        CoordinateSequence coordinateSequence = line.getCoordinateSequence();
        Assert.assertThat((Object)coordinateSequence.getDimension(), (Matcher)CoreMatchers.is((Object)dimension));
        Assert.assertThat((Object)coordinateSequence.getMeasures(), (Matcher)CoreMatchers.is((Object)measures));
        List<Double> candidatesOrdinates = this.getOrdinates(coordinateSequence);
        Assert.assertThat((Object)candidatesOrdinates.size(), (Matcher)CoreMatchers.is((Object)ordinates.length));
        for (int i = 0; i < ordinates.length; ++i) {
            Assert.assertThat((Object)candidatesOrdinates.get(i), (Matcher)CoreMatchers.is((Object)ordinates[i]));
        }
    }

    private void checkPointCoordinates(SimpleFeature feature, int dimension, int measures, double ... ordinates) {
        Object candidate = feature.getDefaultGeometry();
        Assert.assertThat((Object)candidate, (Matcher)CoreMatchers.instanceOf(Point.class));
        Point point = (Point)candidate;
        CoordinateSequence coordinateSequence = point.getCoordinateSequence();
        Assert.assertThat((Object)coordinateSequence.getDimension(), (Matcher)CoreMatchers.is((Object)dimension));
        Assert.assertThat((Object)coordinateSequence.getMeasures(), (Matcher)CoreMatchers.is((Object)measures));
        List<Double> candidatesOrdinates = this.getOrdinates(coordinateSequence);
        Assert.assertThat((Object)candidatesOrdinates.size(), (Matcher)CoreMatchers.is((Object)ordinates.length));
        for (int i = 0; i < ordinates.length; ++i) {
            Assert.assertThat((Object)candidatesOrdinates.get(i), (Matcher)CoreMatchers.is((Object)ordinates[i]));
        }
    }

    private List<Double> getOrdinates(CoordinateSequence coordinateSequence) {
        ArrayList<Double> ordinates = new ArrayList<Double>();
        for (Coordinate coordinate : coordinateSequence.toCoordinateArray()) {
            for (int i = 0; i < coordinateSequence.getDimension(); ++i) {
                ordinates.add(coordinate.getOrdinate(i));
            }
        }
        return ordinates;
    }

    private List<SimpleFeature> getFeatures(String tableName, Query query) {
        try {
            ContentFeatureSource featureSource = this.dataStore.getFeatureSource(this.tname(tableName));
            ContentFeatureCollection collection = featureSource.getFeatures(query);
            return this.getFeatures((SimpleFeatureCollection)collection);
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("Error reading features from table '%s' using query '%s'.", tableName, query.toString()), exception);
        }
    }

    private List<SimpleFeature> getFeatures(SimpleFeatureCollection collection) {
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        try (SimpleFeatureIterator iterator = collection.features();){
            while (iterator.hasNext()) {
                features.add((SimpleFeature)iterator.next());
            }
        }
        return features;
    }

    private SimpleFeature findOne(List<SimpleFeature> features, Object ... attributesValues) {
        List<SimpleFeature> found = this.find(features, attributesValues);
        Assert.assertThat((Object)found.size(), (Matcher)CoreMatchers.is((Object)1));
        return found.get(0);
    }

    private List<SimpleFeature> find(List<SimpleFeature> features, Object ... attributesValues) {
        ArrayList<SimpleFeature> found = new ArrayList<SimpleFeature>();
        for (SimpleFeature feature : features) {
            boolean matches = true;
            for (int i = 0; i < attributesValues.length; i += 2) {
                String attribute = (String)attributesValues[i];
                Object value = feature.getAttribute(attribute);
                matches = Objects.equals(value, attributesValues[i + 1]);
            }
            if (!matches) continue;
            found.add(feature);
        }
        return found;
    }
}

