/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureStore;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.jdbc.JDBCLobTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;

public abstract class JDBCLobOnlineTest
extends JDBCTestSupport {
    protected static final String TESTLOB = "testlob";
    protected static final String ID = "id";
    protected static final String BLOB_FIELD = "blob_field";
    protected static final String CLOB_FIELD = "clob_field";
    protected static final String RAW_FIELD = "raw_field";
    protected FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    protected SimpleFeatureType lobSchema;

    @Override
    protected abstract JDBCLobTestSetup createTestSetup();

    @Override
    protected void connect() throws Exception {
        super.connect();
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(TESTLOB);
        tb.add(this.aname(BLOB_FIELD), byte[].class);
        tb.add(this.aname(CLOB_FIELD), String.class);
        tb.add(this.aname(RAW_FIELD), byte[].class);
        this.lobSchema = tb.buildFeatureType();
    }

    public void testSchema() throws Exception {
        SimpleFeatureType ft = this.dataStore.getSchema(this.tname(TESTLOB));
        this.assertFeatureTypesEqual(this.lobSchema, ft);
    }

    public void testRead() throws Exception {
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname(TESTLOB)).getFeatures();
        try (FeatureIterator fi = fc.features();){
            JDBCLobOnlineTest.assertTrue((boolean)fi.hasNext());
            SimpleFeature f = (SimpleFeature)fi.next();
            JDBCLobOnlineTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3, 4, 5}, (byte[])f.getAttribute(this.aname(BLOB_FIELD))));
            JDBCLobOnlineTest.assertTrue((boolean)Arrays.equals(new byte[]{6, 7, 8, 9, 10}, (byte[])f.getAttribute(this.aname(RAW_FIELD))));
            JDBCLobOnlineTest.assertEquals((Object)"small clob", (Object)f.getAttribute(this.aname(CLOB_FIELD)));
        }
    }

    public void testWrite() throws Exception {
        FeatureStore fs = (FeatureStore)this.dataStore.getFeatureSource(this.tname(TESTLOB));
        SimpleFeature sf = SimpleFeatureBuilder.build((SimpleFeatureType)this.lobSchema, (Object[])new Object[]{new byte[]{6, 7, 8}, "newclob", new byte[]{11, 12, 13}}, null);
        List fids = fs.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)sf));
        Id filter = this.ff.id(new HashSet(fids));
        try (FeatureIterator fi = fs.getFeatures((Filter)filter).features();){
            JDBCLobOnlineTest.assertTrue((boolean)fi.hasNext());
            SimpleFeature f = (SimpleFeature)fi.next();
            JDBCLobOnlineTest.assertTrue((boolean)Arrays.equals(new byte[]{6, 7, 8}, (byte[])f.getAttribute(this.aname(BLOB_FIELD))));
            JDBCLobOnlineTest.assertTrue((boolean)Arrays.equals(new byte[]{11, 12, 13}, (byte[])f.getAttribute(this.aname(RAW_FIELD))));
            JDBCLobOnlineTest.assertEquals((Object)"newclob", (Object)f.getAttribute(this.aname(CLOB_FIELD)));
        }
    }

    public void testCreateSchema() throws IOException {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.init(this.lobSchema);
        tb.setName(this.tname("testLobCreate"));
        SimpleFeatureType ft = tb.buildFeatureType();
        if (Arrays.asList(this.dataStore.getTypeNames()).contains(ft.getTypeName())) {
            this.dataStore.removeSchema(ft.getTypeName());
        }
        this.dataStore.createSchema(ft);
        SimpleFeatureType ft2 = this.dataStore.getSchema(ft.getTypeName());
        this.assertFeatureTypesEqual(ft, ft2);
    }
}

