/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.Aggregate;
import org.geotools.feature.visitor.GroupByVisitor;
import org.geotools.feature.visitor.GroupByVisitorBuilder;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.expression.InternalVolatileFunction;
import org.geotools.filter.function.DateDifferenceFunction;
import org.geotools.filter.function.math.FilterFunction_floor;
import org.geotools.jdbc.JDBCTestSupport;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.PropertyName;

public abstract class JDBCGroupByVisitorOnlineTest
extends JDBCTestSupport {
    public void testSimpleGroupByWithMax() throws Exception {
        List<Object[]> value = this.genericGroupByTestTest(Aggregate.MAX, "building_type");
        JDBCGroupByVisitorOnlineTest.assertTrue((value.size() == 3 ? 1 : 0) != 0);
        this.checkValueContains(value, "HOUSE", "6.0");
        this.checkValueContains(value, "FABRIC", "500.0");
        this.checkValueContains(value, "SCHOOL", "60.0");
    }

    public void testUnkonwnFunction() throws Exception {
        InternalVolatileFunction aggregateFunction = new InternalVolatileFunction(){

            public Object evaluate(Object object) {
                return ((SimpleFeature)object).getAttribute(JDBCGroupByVisitorOnlineTest.this.aname("building_type")) + "_foo";
            }
        };
        List<Object[]> value = this.genericGroupByTestTest(Query.ALL, Aggregate.MAX, false, new Expression[]{aggregateFunction});
        JDBCGroupByVisitorOnlineTest.assertNotNull(value);
        JDBCGroupByVisitorOnlineTest.assertTrue((value.size() == 3 ? 1 : 0) != 0);
        this.checkValueContains(value, "HOUSE_foo", "6.0");
        this.checkValueContains(value, "FABRIC_foo", "500.0");
        this.checkValueContains(value, "SCHOOL_foo", "60.0");
    }

    public void testAggregateOnMathExpression() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName pn = ff.property("energy_consumption");
        Multiply expression = ff.multiply((Expression)pn, (Expression)ff.literal(10));
        List<Object[]> value = this.genericGroupByTestTest(Query.ALL, Aggregate.COUNT, new Expression[]{expression});
        JDBCGroupByVisitorOnlineTest.assertNotNull(value);
        JDBCGroupByVisitorOnlineTest.assertTrue((value.size() == 9 ? 1 : 0) != 0);
        this.checkValueContains(value, "40.0", "1");
        this.checkValueContains(value, "200.0", "2");
        this.checkValueContains(value, "600.0", "1");
        this.checkValueContains(value, "5000.0", "1");
        this.checkValueContains(value, "60.0", "1");
        this.checkValueContains(value, "100.0", "2");
        this.checkValueContains(value, "300.0", "2");
        this.checkValueContains(value, "500.0", "1");
        this.checkValueContains(value, "1500.0", "1");
    }

    public void testComputeOnMathExpression() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName pn = ff.property(this.aname("energy_consumption"));
        Multiply computeAttribute = ff.multiply((Expression)pn, (Expression)ff.literal(10));
        PropertyName groupAttribute = ff.property(this.aname("building_type"));
        List<Object[]> value = this.genericGroupByTestTest(Query.ALL, Aggregate.MAX, (Expression)computeAttribute, true, new Expression[]{groupAttribute});
        JDBCGroupByVisitorOnlineTest.assertNotNull(value);
        JDBCGroupByVisitorOnlineTest.assertTrue((value.size() == 3 ? 1 : 0) != 0);
        this.checkValueContains(value, "HOUSE", "60.0");
        this.checkValueContains(value, "FABRIC", "5000.0");
        this.checkValueContains(value, "SCHOOL", "600.0");
    }

    public void testComputeOnMathExpressionWithLimit() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName pn = ff.property(this.aname("energy_consumption"));
        Multiply computeAttribute = ff.multiply((Expression)pn, (Expression)ff.literal(10));
        PropertyName groupAttribute = ff.property(this.aname("building_type"));
        List<Object[]> value = this.genericGroupByTestTest(this.queryWithLimits(3, 2), Aggregate.MAX, (Expression)computeAttribute, true, new Expression[]{groupAttribute});
        JDBCGroupByVisitorOnlineTest.assertNotNull(value);
        JDBCGroupByVisitorOnlineTest.assertTrue((value.size() >= 1 && value.size() <= 2 ? 1 : 0) != 0);
    }

    public void testNumericHistogram() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName pn = ff.property(this.aname("energy_consumption"));
        Function expression = ff.function("floor", new Expression[]{ff.divide((Expression)pn, (Expression)ff.literal(100))});
        boolean expectOptimized = this.dataStore.getFilterCapabilities().supports(FilterFunction_floor.class);
        List<Object[]> value = this.genericGroupByTestTest(Query.ALL, Aggregate.COUNT, expectOptimized, new Expression[]{expression});
        JDBCGroupByVisitorOnlineTest.assertNotNull(value);
        JDBCGroupByVisitorOnlineTest.assertEquals((int)value.size(), (int)3);
        this.checkValueContains(value, "0", "10");
        this.checkValueContains(value, "1", "1");
        this.checkValueContains(value, "5", "1");
    }

    public void testTimestampHistogram() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName pn = ff.property(this.aname("last_update"));
        Date baseDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse("2016-06-03 00:00:00");
        Function difference = ff.function("dateDifference", new Expression[]{pn, ff.literal((Object)baseDate)});
        int dayInMs = 86400000;
        Function expression = ff.function("floor", new Expression[]{ff.divide((Expression)difference, (Expression)ff.literal(dayInMs))});
        FilterCapabilities capabilities = this.dataStore.getFilterCapabilities();
        boolean expectOptimized = capabilities.supports(FilterFunction_floor.class) && capabilities.supports(DateDifferenceFunction.class);
        List<Object[]> value = this.genericGroupByTestTest(Query.ALL, Aggregate.COUNT, expectOptimized, new Expression[]{expression});
        JDBCGroupByVisitorOnlineTest.assertNotNull(value);
        JDBCGroupByVisitorOnlineTest.assertEquals((int)5, (int)value.size());
        this.checkValueContains(value, "0", "3");
        this.checkValueContains(value, "2", "1");
        this.checkValueContains(value, "3", "2");
        this.checkValueContains(value, "4", "3");
        this.checkValueContains(value, "12", "3");
    }

    public void testMultipleGroupByWithMax() throws Exception {
        List<Object[]> value = this.genericGroupByTestTest(Aggregate.MAX, "building_type", "energy_type");
        JDBCGroupByVisitorOnlineTest.assertTrue((value.size() == 11 ? 1 : 0) != 0);
        this.checkValueContains(value, "SCHOOL", "WIND", "20.0");
        this.checkValueContains(value, "SCHOOL", "FUEL", "60.0");
        this.checkValueContains(value, "HOUSE", "NUCLEAR", "4.0");
        this.checkValueContains(value, "SCHOOL", "SOLAR", "30.0");
        this.checkValueContains(value, "SCHOOL", "FLOWING_WATER", "50.0");
        this.checkValueContains(value, "SCHOOL", "NUCLEAR", "10.0");
        this.checkValueContains(value, "HOUSE", "FUEL", "6.0");
        this.checkValueContains(value, "FABRIC", "NUCLEAR", "150.0");
        this.checkValueContains(value, "FABRIC", "SOLAR", "30.0");
        this.checkValueContains(value, "FABRIC", "FLOWING_WATER", "500.0");
        this.checkValueContains(value, "FABRIC", "WIND", "20.0");
    }

    public void testMultipleGroupByWithMaxWithFilter() throws Exception {
        List<Object[]> value = this.genericGroupByTestTest(this.energyConsumptionGreaterThan(50.0), Aggregate.MAX, "building_type", "energy_type");
        JDBCGroupByVisitorOnlineTest.assertTrue((value.size() == 3 ? 1 : 0) != 0);
        this.checkValueContains(value, "SCHOOL", "FUEL", "60.0");
        this.checkValueContains(value, "FABRIC", "NUCLEAR", "150.0");
        this.checkValueContains(value, "FABRIC", "FLOWING_WATER", "500.0");
    }

    public void testMultipleGroupByWithMaxWithLimitOffset() throws Exception {
        if (!this.dataStore.getSQLDialect().isLimitOffsetSupported()) {
            return;
        }
        List<Object[]> value = this.genericGroupByTestTest(this.queryWithLimits(0, 3), Aggregate.MAX, "building_type", "energy_type");
        JDBCGroupByVisitorOnlineTest.assertFalse((boolean)value.isEmpty());
        JDBCGroupByVisitorOnlineTest.assertTrue((value.size() <= 3 ? 1 : 0) != 0);
    }

    public void testSimpleGroupByWithMin() throws Exception {
        List<Object[]> value = this.genericGroupByTestTest(Aggregate.MIN, "building_type");
        this.checkValueContains(value, "HOUSE", "4.0");
        this.checkValueContains(value, "FABRIC", "20.0");
        this.checkValueContains(value, "SCHOOL", "10.0");
    }

    public void testMultipleGroupByWithMin() throws Exception {
        List<Object[]> value = this.genericGroupByTestTest(Aggregate.MIN, "building_type", "energy_type");
        this.checkValueContains(value, "SCHOOL", "WIND", "20.0");
        this.checkValueContains(value, "SCHOOL", "FUEL", "60.0");
        this.checkValueContains(value, "HOUSE", "NUCLEAR", "4.0");
        this.checkValueContains(value, "SCHOOL", "SOLAR", "30.0");
        this.checkValueContains(value, "SCHOOL", "FLOWING_WATER", "50.0");
        this.checkValueContains(value, "SCHOOL", "NUCLEAR", "10.0");
        this.checkValueContains(value, "HOUSE", "FUEL", "6.0");
        this.checkValueContains(value, "FABRIC", "NUCLEAR", "150.0");
        this.checkValueContains(value, "FABRIC", "SOLAR", "30.0");
        this.checkValueContains(value, "FABRIC", "FLOWING_WATER", "500.0");
        this.checkValueContains(value, "FABRIC", "WIND", "20.0");
    }

    public void testMultipleGroupByWithMinWithFilter() throws Exception {
        List<Object[]> value = this.genericGroupByTestTest(this.energyConsumptionGreaterThan(50.0), Aggregate.MIN, "building_type", "energy_type");
        JDBCGroupByVisitorOnlineTest.assertTrue((value.size() == 3 ? 1 : 0) != 0);
        this.checkValueContains(value, "SCHOOL", "FUEL", "60.0");
        this.checkValueContains(value, "FABRIC", "NUCLEAR", "150.0");
        this.checkValueContains(value, "FABRIC", "FLOWING_WATER", "500.0");
    }

    public void testMultipleGroupByWithMinWithLimitOffset() throws Exception {
        if (!this.dataStore.getSQLDialect().isLimitOffsetSupported()) {
            return;
        }
        List<Object[]> value = this.genericGroupByTestTest(this.queryWithLimits(0, 3), Aggregate.MIN, "building_type", "energy_type");
        JDBCGroupByVisitorOnlineTest.assertFalse((boolean)value.isEmpty());
        JDBCGroupByVisitorOnlineTest.assertTrue((value.size() <= 3 ? 1 : 0) != 0);
    }

    public void testSimpleGroupByWithCount() throws Exception {
        List<Object[]> value = this.genericGroupByTestTest(Aggregate.COUNT, "building_type");
        this.checkValueContains(value, "HOUSE", "2");
        this.checkValueContains(value, "FABRIC", "4");
        this.checkValueContains(value, "SCHOOL", "6");
    }

    public void testMultipleGroupByWithCount() throws Exception {
        List<Object[]> value = this.genericGroupByTestTest(Aggregate.COUNT, "building_type", "energy_type");
        this.checkValueContains(value, "SCHOOL", "WIND", "1");
        this.checkValueContains(value, "SCHOOL", "FUEL", "1");
        this.checkValueContains(value, "HOUSE", "NUCLEAR", "1");
        this.checkValueContains(value, "SCHOOL", "SOLAR", "1");
        this.checkValueContains(value, "SCHOOL", "FLOWING_WATER", "1");
        this.checkValueContains(value, "SCHOOL", "NUCLEAR", "2");
        this.checkValueContains(value, "HOUSE", "FUEL", "1");
        this.checkValueContains(value, "FABRIC", "NUCLEAR", "1");
        this.checkValueContains(value, "FABRIC", "SOLAR", "1");
        this.checkValueContains(value, "FABRIC", "FLOWING_WATER", "1");
        this.checkValueContains(value, "FABRIC", "WIND", "1");
    }

    public void testMultipleGroupByWithCountWithFilter() throws Exception {
        List<Object[]> value = this.genericGroupByTestTest(this.energyConsumptionGreaterThan(50.0), Aggregate.COUNT, "building_type", "energy_type");
        JDBCGroupByVisitorOnlineTest.assertTrue((value.size() == 3 ? 1 : 0) != 0);
        this.checkValueContains(value, "SCHOOL", "FUEL", "1");
        this.checkValueContains(value, "FABRIC", "NUCLEAR", "1");
        this.checkValueContains(value, "FABRIC", "FLOWING_WATER", "1");
    }

    public void testMultipleGroupByWithCountWithLimitOffset() throws Exception {
        if (!this.dataStore.getSQLDialect().isLimitOffsetSupported()) {
            return;
        }
        List<Object[]> value = this.genericGroupByTestTest(this.queryWithLimits(0, 3), Aggregate.COUNT, "building_type", "energy_type");
        JDBCGroupByVisitorOnlineTest.assertFalse((boolean)value.isEmpty());
        JDBCGroupByVisitorOnlineTest.assertTrue((value.size() <= 3 ? 1 : 0) != 0);
    }

    public void testSimpleGroupByWithSum() throws Exception {
        List<Object[]> value = this.genericGroupByTestTest(Aggregate.SUM, "building_type");
        this.checkValueContains(value, "HOUSE", "10.0");
        this.checkValueContains(value, "FABRIC", "700.0");
        this.checkValueContains(value, "SCHOOL", "180.0");
    }

    public void testMultipleGroupByWithSum() throws Exception {
        List<Object[]> value = this.genericGroupByTestTest(Aggregate.SUM, "building_type", "energy_type");
        this.checkValueContains(value, "FABRIC", "FLOWING_WATER", "500.0");
        this.checkValueContains(value, "FABRIC", "NUCLEAR", "150.0");
        this.checkValueContains(value, "FABRIC", "SOLAR", "30.0");
        this.checkValueContains(value, "FABRIC", "WIND", "20.0");
        this.checkValueContains(value, "HOUSE", "FUEL", "6.0");
        this.checkValueContains(value, "HOUSE", "NUCLEAR", "4.0");
        this.checkValueContains(value, "SCHOOL", "FLOWING_WATER", "50.0");
        this.checkValueContains(value, "SCHOOL", "FUEL", "60.0");
        this.checkValueContains(value, "SCHOOL", "NUCLEAR", "20.0");
        this.checkValueContains(value, "SCHOOL", "SOLAR", "30.0");
        this.checkValueContains(value, "SCHOOL", "WIND", "20.0");
    }

    public void testMultipleGroupByWithSumWithFilter() throws Exception {
        List<Object[]> value = this.genericGroupByTestTest(this.energyConsumptionGreaterThan(50.0), Aggregate.SUM, "building_type", "energy_type");
        JDBCGroupByVisitorOnlineTest.assertTrue((value.size() == 3 ? 1 : 0) != 0);
        this.checkValueContains(value, "SCHOOL", "FUEL", "60.0");
        this.checkValueContains(value, "FABRIC", "NUCLEAR", "150.0");
        this.checkValueContains(value, "FABRIC", "FLOWING_WATER", "500.0");
    }

    public void testWithMinWithLimitOffset() throws Exception {
        if (!this.dataStore.getSQLDialect().isLimitOffsetSupported()) {
            return;
        }
        List<Object[]> value = this.genericGroupByTestTest(this.queryWithLimits(0, 3), Aggregate.SUM, "building_type", "energy_type");
        JDBCGroupByVisitorOnlineTest.assertFalse((boolean)value.isEmpty());
        JDBCGroupByVisitorOnlineTest.assertTrue((value.size() <= 3 ? 1 : 0) != 0);
    }

    private Query queryWithLimits(int lower, int upper) {
        Query query = new Query(this.tname("buildings"));
        query.setStartIndex(Integer.valueOf(lower));
        query.setMaxFeatures(upper);
        return query;
    }

    private Query energyConsumptionGreaterThan(double value) {
        FilterFactory filterFactory = this.dataStore.getFilterFactory();
        PropertyIsGreaterThan filter = filterFactory.greater((Expression)filterFactory.property(this.aname("energy_consumption")), (Expression)filterFactory.literal(value));
        return new Query(this.tname("buildings"), (Filter)filter);
    }

    protected List<Object[]> genericGroupByTestTest(Aggregate aggregateVisitor, String ... groupByAttributes) throws IOException {
        return this.genericGroupByTestTest(Query.ALL, aggregateVisitor, groupByAttributes);
    }

    private List<Object[]> genericGroupByTestTest(Query query, Aggregate aggregateVisitor, String ... groupByAttributes) throws IOException {
        Expression[] expressions = new Expression[groupByAttributes != null ? groupByAttributes.length : 0];
        if (groupByAttributes != null) {
            int i = 0;
            for (String attribute : groupByAttributes) {
                PropertyName property = this.dataStore.getFilterFactory().property(this.aname(attribute));
                expressions[i++] = property;
            }
        }
        return this.genericGroupByTestTest(query, aggregateVisitor, expressions);
    }

    private List<Object[]> genericGroupByTestTest(Query query, Aggregate aggregateVisitor, Expression ... groupByAttributes) throws IOException {
        return this.genericGroupByTestTest(query, aggregateVisitor, true, groupByAttributes);
    }

    protected List<Object[]> genericGroupByTestTest(Query query, Aggregate aggregateVisitor, boolean expectOptimized, Expression ... groupByAttributes) throws IOException {
        PropertyName aggregateAttribute = CommonFactoryFinder.getFilterFactory().property(this.aname("energy_consumption"));
        return this.genericGroupByTestTest(query, aggregateVisitor, (Expression)aggregateAttribute, expectOptimized, groupByAttributes);
    }

    private List<Object[]> genericGroupByTestTest(Query query, Aggregate aggregateVisitor, Expression aggregateAttribute, boolean expectOptimized, Expression ... groupByAttributes) throws IOException {
        ContentFeatureSource featureSource = this.dataStore.getFeatureSource(this.tname("buildings_group_by_tests"));
        GroupByVisitorBuilder visitorBuilder = new GroupByVisitorBuilder().withAggregateAttribute(aggregateAttribute).withAggregateVisitor(aggregateVisitor);
        for (Expression groupByAttribute : groupByAttributes) {
            visitorBuilder.withGroupByAttribute(groupByAttribute);
        }
        GroupByVisitor visitor = visitorBuilder.build();
        featureSource.accepts(query, (FeatureVisitor)visitor, null);
        JDBCGroupByVisitorOnlineTest.assertEquals((boolean)expectOptimized, (boolean)visitor.wasOptimized());
        JDBCGroupByVisitorOnlineTest.assertEquals((!expectOptimized ? 1 : 0) != 0, (boolean)visitor.wasVisited());
        List value = visitor.getResult().toList();
        JDBCGroupByVisitorOnlineTest.assertNotNull((Object)value);
        return value;
    }

    protected void checkValueContains(List<Object[]> value, String ... expectedResult) {
        JDBCGroupByVisitorOnlineTest.assertTrue((boolean)value.stream().anyMatch(result -> {
            if (((Object[])result).length != expectedResult.length) {
                return false;
            }
            for (int i = 0; i < ((Object[])result).length; ++i) {
                if (result[i] instanceof Number) {
                    double e;
                    double r = ((Number)result[i]).doubleValue();
                    return r == (e = Double.parseDouble(expectedResult[i]));
                }
                if (result[i].toString().equals(expectedResult[i])) continue;
                return false;
            }
            return true;
        }));
    }
}

