/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.jdbc.JDBCGeometryTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class JDBCGeometryOnlineTest
extends JDBCTestSupport {
    @Override
    protected abstract JDBCGeometryTestSetup createTestSetup();

    public void testPoint() throws Exception {
        JDBCGeometryOnlineTest.assertEquals(Point.class, (Object)this.checkGeometryType(Point.class));
    }

    public void testLineString() throws Exception {
        JDBCGeometryOnlineTest.assertEquals(LineString.class, (Object)this.checkGeometryType(LineString.class));
    }

    public void testLinearRing() throws Exception {
        JDBCGeometryOnlineTest.assertEquals(LinearRing.class, (Object)this.checkGeometryType(LinearRing.class));
    }

    public void testPolygon() throws Exception {
        JDBCGeometryOnlineTest.assertEquals(Polygon.class, (Object)this.checkGeometryType(Polygon.class));
    }

    public void testMultiPoint() throws Exception {
        JDBCGeometryOnlineTest.assertEquals(MultiPoint.class, (Object)this.checkGeometryType(MultiPoint.class));
    }

    public void testMultiLineString() throws Exception {
        JDBCGeometryOnlineTest.assertEquals(MultiLineString.class, (Object)this.checkGeometryType(MultiLineString.class));
    }

    public void testMultiPolygon() throws Exception {
        JDBCGeometryOnlineTest.assertEquals(MultiPolygon.class, (Object)this.checkGeometryType(MultiPolygon.class));
    }

    public void testGeometry() throws Exception {
        JDBCGeometryOnlineTest.assertEquals(Geometry.class, (Object)this.checkGeometryType(Geometry.class));
    }

    public void testGeometryCollection() throws Exception {
        JDBCGeometryOnlineTest.assertEquals(GeometryCollection.class, (Object)this.checkGeometryType(GeometryCollection.class));
    }

    protected Class checkGeometryType(Class geomClass) throws Exception {
        String featureTypeName = this.tname("t" + geomClass.getSimpleName());
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName(featureTypeName);
        ftb.add(this.aname("id"), Integer.class);
        ftb.add(this.aname("name"), String.class);
        ftb.add(this.aname("geom"), geomClass, crs);
        SimpleFeatureType newFT = ftb.buildFeatureType();
        this.dataStore.createSchema(newFT);
        SimpleFeatureType newSchema = this.dataStore.getSchema(featureTypeName);
        JDBCGeometryOnlineTest.assertNotNull((Object)newSchema);
        JDBCGeometryOnlineTest.assertEquals((int)3, (int)newSchema.getAttributeCount());
        return newSchema.getGeometryDescriptor().getType().getBinding();
    }
}

