/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCGeographyTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.VirtualTable;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.DWithin;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class JDBCGeographyOnlineTest
extends JDBCTestSupport {
    FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    GeometryFactory gf = new GeometryFactory();

    @Override
    protected abstract JDBCGeographyTestSetup createTestSetup();

    protected boolean isGeographySupportAvailable() throws Exception {
        boolean available = ((JDBCGeographyTestSetup)this.setup).isGeographySupportAvailable();
        if (!available) {
            System.out.println("Skipping geography tests as geography column support is not available");
        }
        return available;
    }

    public void testSchema() throws Exception {
        if (!this.isGeographySupportAvailable()) {
            return;
        }
        SimpleFeatureType ft = this.dataStore.getFeatureSource(this.tname("geopoint")).getSchema();
        JDBCGeographyOnlineTest.assertNotNull((Object)ft);
        JDBCGeographyOnlineTest.assertTrue((boolean)(ft.getDescriptor(this.aname("geo")) instanceof GeometryDescriptor));
        JDBCGeographyOnlineTest.assertEquals(Point.class, (Object)ft.getDescriptor("geo").getType().getBinding());
        int epsg = CRS.lookupEpsgCode((CoordinateReferenceSystem)((GeometryDescriptor)ft.getDescriptor(this.aname("geo"))).getCoordinateReferenceSystem(), (boolean)false);
        JDBCGeographyOnlineTest.assertEquals((int)4326, (int)epsg);
    }

    public void testReader() throws Exception {
        if (!this.isGeographySupportAvailable()) {
            return;
        }
        Query q = new Query(this.tname("geopoint"));
        try (FeatureReader r = this.dataStore.getFeatureReader(q, Transaction.AUTO_COMMIT);){
            JDBCGeographyOnlineTest.assertTrue((boolean)r.hasNext());
            while (r.hasNext()) {
                SimpleFeature f = (SimpleFeature)r.next();
                JDBCGeographyOnlineTest.assertTrue((boolean)(f.getAttribute(this.aname("geo")) instanceof Point));
            }
        }
    }

    public void testBBoxLargerThanWorld() throws Exception {
        if (!this.isGeographySupportAvailable()) {
            return;
        }
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        BBOX bbox = ff.bbox("", -200.0, -200.0, 200.0, 200.0, "EPSG:4326");
        Query q = new Query(this.tname("geopoint"));
        q.setFilter((Filter)bbox);
        try (FeatureReader r = this.dataStore.getFeatureReader(q, Transaction.AUTO_COMMIT);){
            JDBCGeographyOnlineTest.assertTrue((boolean)r.hasNext());
            while (r.hasNext()) {
                SimpleFeature f = (SimpleFeature)r.next();
                JDBCGeographyOnlineTest.assertTrue((boolean)(f.getAttribute(this.aname("geo")) instanceof Point));
            }
        }
    }

    public void testOutsideWorld() throws Exception {
        if (!this.isGeographySupportAvailable()) {
            return;
        }
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        BBOX bbox = ff.bbox("", -300.0, -40.0, -200.0, 40.0, "EPSG:4326");
        Query q = new Query(this.tname("geopoint"));
        q.setFilter((Filter)bbox);
        try (FeatureReader r = this.dataStore.getFeatureReader(q, Transaction.AUTO_COMMIT);){
            JDBCGeographyOnlineTest.assertFalse((boolean)r.hasNext());
        }
    }

    public void testLargerThanHalfWorld() throws Exception {
        if (!this.isGeographySupportAvailable()) {
            return;
        }
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        BBOX bbox = ff.bbox("", -140.0, -50.0, 140.0, 50.0, "EPSG:4326");
        Query q = new Query(this.tname("geopoint"));
        q.setFilter((Filter)bbox);
        try (FeatureReader r = this.dataStore.getFeatureReader(q, Transaction.AUTO_COMMIT);){
            JDBCGeographyOnlineTest.assertTrue((boolean)r.hasNext());
            while (r.hasNext()) {
                SimpleFeature f = (SimpleFeature)r.next();
                JDBCGeographyOnlineTest.assertTrue((boolean)(f.getAttribute(this.aname("geo")) instanceof Point));
            }
        }
    }

    public void testUpdate() throws Exception {
        SimpleFeature f;
        if (!this.isGeographySupportAvailable()) {
            return;
        }
        Point p = this.gf.createPoint(new Coordinate(1.0, 1.0));
        try (FeatureWriter fw = this.dataStore.getFeatureWriter(this.tname("geopoint"), Transaction.AUTO_COMMIT);){
            JDBCGeographyOnlineTest.assertTrue((boolean)fw.hasNext());
            while (fw.hasNext()) {
                f = (SimpleFeature)fw.next();
                f.setDefaultGeometry((Object)p);
                fw.write();
            }
        }
        try (FeatureReader fr = this.dataStore.getFeatureReader(new Query(this.tname("geopoint")), Transaction.AUTO_COMMIT);){
            while (fr.hasNext()) {
                f = (SimpleFeature)fr.next();
                JDBCGeographyOnlineTest.assertEquals((Object)p, (Object)f.getDefaultGeometry());
            }
        }
    }

    public void testAppend() throws Exception {
        if (!this.isGeographySupportAvailable()) {
            return;
        }
        Point point = this.gf.createPoint(new Coordinate(10.0, 10.0));
        try (FeatureWriter fw = this.dataStore.getFeatureWriterAppend(this.tname("geopoint"), Transaction.AUTO_COMMIT);){
            JDBCGeographyOnlineTest.assertFalse((boolean)fw.hasNext());
            SimpleFeature f = (SimpleFeature)fw.next();
            f.setAttribute("name", (Object)"append");
            f.setDefaultGeometry((Object)point);
            fw.write();
        }
        PropertyIsEqualTo filter = this.ff.equals((Expression)this.ff.property("name"), (Expression)this.ff.literal((Object)"append"));
        Query q = new Query(this.tname("geopoint"), (Filter)filter);
        try (FeatureReader fr = this.dataStore.getFeatureReader(q, Transaction.AUTO_COMMIT);){
            JDBCGeographyOnlineTest.assertTrue((boolean)fr.hasNext());
            SimpleFeature f = (SimpleFeature)fr.next();
            JDBCGeographyOnlineTest.assertEquals((Object)point, (Object)f.getDefaultGeometry());
        }
    }

    public void testBounds() throws Exception {
        if (!this.isGeographySupportAvailable()) {
            return;
        }
        ReferencedEnvelope env = this.dataStore.getFeatureSource(this.tname("geopoint")).getBounds();
        ReferencedEnvelope expected = new ReferencedEnvelope(-110.0, 0.0, 29.0, 49.0, CRS.decode((String)"EPSG:4326"));
        JDBCGeographyOnlineTest.assertEquals((Object)expected, (Object)env);
    }

    public void testBboxFilter() throws Exception {
        if (!this.isGeographySupportAvailable()) {
            return;
        }
        BBOX bbox = this.ff.bbox(this.aname("geo"), -120.0, 25.0, -100.0, 40.0, "EPSG:4326");
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("geopoint")).getFeatures((Filter)bbox);
        JDBCGeographyOnlineTest.assertEquals((int)2, (int)features.size());
    }

    public void testDistanceMeters() throws Exception {
        if (!this.isGeographySupportAvailable()) {
            return;
        }
        DWithin filter = this.ff.dwithin((Expression)this.ff.property(this.aname("geo")), (Expression)this.ff.literal((Object)this.gf.createPoint(new Coordinate(1.0, 49.0))), 74000.0, "metre");
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("geopoint")).getFeatures((Filter)filter);
        JDBCGeographyOnlineTest.assertEquals((int)1, (int)features.size());
    }

    public void testDistanceGreatCircle() throws Exception {
        if (!this.isGeographySupportAvailable()) {
            return;
        }
        try (FeatureWriter fw = this.dataStore.getFeatureWriterAppend(this.tname("geopoint"), Transaction.AUTO_COMMIT);){
            SimpleFeature f = (SimpleFeature)fw.next();
            Point point = this.gf.createPoint(new Coordinate(-21.96, 64.15));
            f.setAttribute("name", (Object)"Reykjavik");
            f.setDefaultGeometry((Object)point);
            fw.write();
        }
        LineString line = this.gf.createLineString(new Coordinate[]{new Coordinate(-122.33, 47.606), new Coordinate(0.0, 51.5)});
        DWithin filter = this.ff.dwithin((Expression)this.ff.property(this.aname("geo")), (Expression)this.ff.literal((Object)line), 130000.0, "metre");
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("geopoint")).getFeatures((Filter)filter);
        JDBCGeographyOnlineTest.assertEquals((int)1, (int)features.size());
        try (FeatureIterator fi = features.features();){
            JDBCGeographyOnlineTest.assertTrue((boolean)fi.hasNext());
            SimpleFeature feature = (SimpleFeature)fi.next();
            JDBCGeographyOnlineTest.assertEquals((Object)"Reykjavik", (Object)feature.getAttribute("name"));
        }
    }

    public void testVirtualTable() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("select * from ");
        this.dialect.encodeTableName(this.tname("geopoint"), sb);
        VirtualTable vt = new VirtualTable("geopoint_vt", sb.toString());
        this.dataStore.createVirtualTable(vt);
        SimpleFeatureType featureType = this.dataStore.getSchema("geopoint_vt");
        JDBCGeographyOnlineTest.assertNotNull((Object)featureType);
        JDBCGeographyOnlineTest.assertNotNull((Object)featureType.getGeometryDescriptor());
    }
}

