/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.spatial.BBOX3D;
import org.opengis.geometry.BoundingBox3D;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class JDBCGeneric3DOnlineTest
extends JDBCTestSupport {
    protected static final String ID = "id";
    protected static final String GEOM = "geom";
    protected static final String NAME = "name";
    protected static final FilterFactory FF = CommonFactoryFinder.getFilterFactory(null);
    protected SimpleFeatureType poly3DType;
    protected SimpleFeatureType line3DType;
    protected CoordinateReferenceSystem crs;

    protected abstract String getLine3d();

    protected abstract String getPoint3d();

    protected abstract String getPoly3d();

    @Override
    protected void connect() throws Exception {
        super.connect();
        this.line3DType = DataUtilities.createType((String)(this.dataStore.getNamespaceURI() + "." + this.tname(this.getLine3d())), (String)(this.aname(ID) + ":0," + this.aname(GEOM) + ":LineString:srid=" + this.getEpsgCode() + "," + this.aname(NAME) + ":String"));
        this.line3DType.getGeometryDescriptor().getUserData().put(Hints.COORDINATE_DIMENSION, 3);
        this.poly3DType = DataUtilities.createType((String)(this.dataStore.getNamespaceURI() + "." + this.tname(this.getPoly3d())), (String)(this.aname(ID) + ":0," + this.aname(GEOM) + ":Polygon:srid=" + this.getEpsgCode() + "," + this.aname(NAME) + ":String"));
        this.poly3DType.getGeometryDescriptor().getUserData().put(Hints.COORDINATE_DIMENSION, 3);
        this.crs = CRS.decode((String)("EPSG:" + this.getEpsgCode()));
    }

    protected Integer getNativeSRID() {
        return this.getEpsgCode();
    }

    protected abstract int getEpsgCode();

    public void testSchema() throws Exception {
        SimpleFeatureType schema = this.dataStore.getSchema(this.tname(this.getLine3d()));
        CoordinateReferenceSystem crs = schema.getGeometryDescriptor().getCoordinateReferenceSystem();
        JDBCGeneric3DOnlineTest.assertEquals((Object)this.getEpsgCode(), (Object)CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false));
        JDBCGeneric3DOnlineTest.assertEquals((Object)this.getNativeSRID(), schema.getGeometryDescriptor().getUserData().get("nativeSRID"));
        JDBCGeneric3DOnlineTest.assertEquals((Object)3, schema.getGeometryDescriptor().getUserData().get(Hints.COORDINATE_DIMENSION));
    }

    public void testReadPoint() throws Exception {
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname(this.getPoint3d())).getFeatures();
        try (SimpleFeatureIterator fr = fc.features();){
            JDBCGeneric3DOnlineTest.assertTrue((boolean)fr.hasNext());
            Point p = (Point)((SimpleFeature)fr.next()).getDefaultGeometry();
            JDBCGeneric3DOnlineTest.assertTrue((boolean)new Coordinate(1.0, 1.0, 1.0).equals((Object)p.getCoordinate()));
        }
    }

    public void testReadLine() throws Exception {
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname(this.getLine3d())).getFeatures();
        try (SimpleFeatureIterator fr = fc.features();){
            JDBCGeneric3DOnlineTest.assertTrue((boolean)fr.hasNext());
            LineString ls = (LineString)((SimpleFeature)fr.next()).getDefaultGeometry();
            JDBCGeneric3DOnlineTest.assertEquals((int)4, (int)ls.getCoordinates().length);
            JDBCGeneric3DOnlineTest.assertTrue((boolean)new Coordinate(1.0, 1.0, 0.0).equals3D(ls.getCoordinateN(0)));
            JDBCGeneric3DOnlineTest.assertTrue((boolean)new Coordinate(2.0, 2.0, 0.0).equals3D(ls.getCoordinateN(1)));
            JDBCGeneric3DOnlineTest.assertTrue((boolean)new Coordinate(4.0, 2.0, 1.0).equals3D(ls.getCoordinateN(2)));
            JDBCGeneric3DOnlineTest.assertTrue((boolean)new Coordinate(5.0, 1.0, 1.0).equals3D(ls.getCoordinateN(3)));
        }
    }

    public void testBBOX3DReadLine() throws Exception {
        BBOX3D bbox3d = FF.bbox("", (BoundingBox3D)new ReferencedEnvelope3D(2.0, 3.0, 1.0, 2.0, 0.0, 1.0, this.crs));
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname(this.getLine3d())).getFeatures((Filter)bbox3d);
        try (SimpleFeatureIterator fr = fc.features();){
            JDBCGeneric3DOnlineTest.assertTrue((boolean)fr.hasNext());
            LineString ls = (LineString)((SimpleFeature)fr.next()).getDefaultGeometry();
            JDBCGeneric3DOnlineTest.assertEquals((int)4, (int)ls.getCoordinates().length);
            JDBCGeneric3DOnlineTest.assertTrue((boolean)new Coordinate(1.0, 1.0, 0.0).equals3D(ls.getCoordinateN(0)));
            JDBCGeneric3DOnlineTest.assertTrue((boolean)new Coordinate(2.0, 2.0, 0.0).equals3D(ls.getCoordinateN(1)));
            JDBCGeneric3DOnlineTest.assertTrue((boolean)new Coordinate(4.0, 2.0, 1.0).equals3D(ls.getCoordinateN(2)));
            JDBCGeneric3DOnlineTest.assertTrue((boolean)new Coordinate(5.0, 1.0, 1.0).equals3D(ls.getCoordinateN(3)));
        }
    }

    public void testBBOX3DOutsideLine() throws Exception {
        BBOX3D bbox3d = FF.bbox("", (BoundingBox3D)new ReferencedEnvelope3D(2.0, 3.0, 1.0, 2.0, 100.0, 101.0, this.crs));
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname(this.getLine3d())).getFeatures((Filter)bbox3d);
        JDBCGeneric3DOnlineTest.assertEquals((int)0, (int)fc.size());
    }

    public void testWriteLine() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        LineString ls = gf.createLineString(new Coordinate[]{new Coordinate(0.0, 0.0, 0.0), new Coordinate(1.0, 1.0, 1.0)});
        SimpleFeature newFeature = SimpleFeatureBuilder.build((SimpleFeatureType)this.line3DType, (Object[])new Object[]{2, ls, "l3"}, null);
        SimpleFeatureStore fs = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.tname(this.getLine3d()), Transaction.AUTO_COMMIT);
        List fids = fs.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)newFeature));
        try (SimpleFeatureIterator fi = fs.getFeatures((Filter)FF.id(new HashSet(fids))).features();){
            JDBCGeneric3DOnlineTest.assertTrue((boolean)fi.hasNext());
            SimpleFeature f = (SimpleFeature)fi.next();
            JDBCGeneric3DOnlineTest.assertTrue((boolean)ls.equalsExact((Geometry)f.getDefaultGeometry()));
        }
    }

    public void testCreateSchemaAndInsertPolyTriangle() throws Exception {
        LiteCoordinateSequenceFactory csf = new LiteCoordinateSequenceFactory();
        GeometryFactory gf = new GeometryFactory((CoordinateSequenceFactory)csf);
        LinearRing shell = gf.createLinearRing(csf.create(new double[]{0.0, 0.0, 99.0, 1.0, 0.0, 33.0, 1.0, 1.0, 66.0, 0.0, 0.0, 99.0}, 3));
        Polygon poly = gf.createPolygon(shell, null);
        this.checkCreateSchemaAndInsert((Geometry)poly);
    }

    public void testCreateSchemaAndInsertPolyRectangle() throws Exception {
        LiteCoordinateSequenceFactory csf = new LiteCoordinateSequenceFactory();
        GeometryFactory gf = new GeometryFactory((CoordinateSequenceFactory)csf);
        LinearRing shell = gf.createLinearRing(csf.create(new double[]{0.0, 0.0, 99.0, 1.0, 0.0, 33.0, 1.0, 1.0, 66.0, 0.0, 1.0, 33.0, 0.0, 0.0, 99.0}, 3));
        Polygon poly = gf.createPolygon(shell, null);
        this.checkCreateSchemaAndInsert((Geometry)poly);
    }

    public void testCreateSchemaAndInsertPolyRectangleWithHole() throws Exception {
        LiteCoordinateSequenceFactory csf = new LiteCoordinateSequenceFactory();
        GeometryFactory gf = new GeometryFactory((CoordinateSequenceFactory)csf);
        LinearRing shell = gf.createLinearRing(csf.create(new double[]{0.0, 0.0, 99.0, 10.0, 0.0, 33.0, 10.0, 10.0, 66.0, 0.0, 10.0, 66.0, 0.0, 0.0, 99.0}, 3));
        LinearRing hole = gf.createLinearRing(csf.create(new double[]{2.0, 2.0, 99.0, 3.0, 2.0, 44.0, 3.0, 3.0, 99.0, 2.0, 3.0, 99.0, 2.0, 2.0, 99.0}, 3));
        Polygon poly = gf.createPolygon(shell, new LinearRing[]{hole});
        this.checkCreateSchemaAndInsert((Geometry)poly);
    }

    public void testCreateSchemaAndInsertPolyWithHoleCW() throws Exception {
        LiteCoordinateSequenceFactory csf = new LiteCoordinateSequenceFactory();
        GeometryFactory gf = new GeometryFactory((CoordinateSequenceFactory)csf);
        LinearRing shell = gf.createLinearRing(csf.create(new double[]{1.0, 1.0, 99.0, 10.0, 1.0, 33.0, 10.0, 10.0, 66.0, 1.0, 10.0, 66.0, 1.0, 1.0, 99.0}, 3));
        LinearRing hole = gf.createLinearRing(csf.create(new double[]{2.0, 2.0, 99.0, 8.0, 2.0, 44.0, 8.0, 8.0, 99.0, 2.0, 8.0, 99.0, 2.0, 2.0, 99.0}, 3));
        Polygon poly = gf.createPolygon(shell, new LinearRing[]{hole});
        this.checkCreateSchemaAndInsert((Geometry)poly);
    }

    private void checkCreateSchemaAndInsert(Geometry poly) throws Exception {
        this.dataStore.createSchema(this.poly3DType);
        SimpleFeatureType actualSchema = this.dataStore.getSchema(this.tname(this.getPoly3d()));
        this.assertFeatureTypesEqual(this.poly3DType, actualSchema);
        JDBCGeneric3DOnlineTest.assertEquals((Object)this.getNativeSRID(), actualSchema.getGeometryDescriptor().getUserData().get("nativeSRID"));
        try (FeatureWriter fw = this.dataStore.getFeatureWriterAppend(this.tname(this.getPoly3d()), Transaction.AUTO_COMMIT);){
            SimpleFeature f = (SimpleFeature)fw.next();
            f.setAttribute(this.aname(ID), (Object)0);
            f.setAttribute(this.aname(GEOM), (Object)poly);
            f.setAttribute(this.aname(NAME), (Object)"3dpolygon!");
            fw.write();
        }
        Hints hints = new Hints();
        hints.put((Object)Hints.JTS_COORDINATE_SEQUENCE_FACTORY, (Object)new LiteCoordinateSequenceFactory());
        Query query = new Query(this.tname(this.getPoly3d()));
        query.setHints(hints);
        try (FeatureReader fr = this.dataStore.getFeatureReader(query, Transaction.AUTO_COMMIT);){
            JDBCGeneric3DOnlineTest.assertTrue((boolean)fr.hasNext());
            SimpleFeature f = (SimpleFeature)fr.next();
            Geometry fgeom = (Geometry)f.getDefaultGeometry();
            JDBCGeneric3DOnlineTest.assertTrue((String)"2D topology does not match", (boolean)poly.equalsTopo(fgeom));
            JDBCGeneric3DOnlineTest.assertTrue((String)"Z values do not match", (boolean)JDBCGeneric3DOnlineTest.hasMatchingZValues(poly, fgeom));
        }
    }

    private static boolean hasMatchingZValues(Geometry g1, Geometry g2) {
        Coordinate[] pt1 = g1.getCoordinates();
        HashMap<Coordinate, Double> coordZMap = new HashMap<Coordinate, Double>();
        for (int i = 0; i < pt1.length; ++i) {
            coordZMap.put(pt1[i], pt1[i].getZ());
        }
        Coordinate[] pt2 = g2.getCoordinates();
        for (int i2 = 0; i2 < pt2.length; ++i2) {
            boolean isEqualZ;
            Coordinate p2 = pt2[i2];
            double z = (Double)coordZMap.get(p2);
            boolean bl = isEqualZ = p2.getZ() == z || Double.isNaN(p2.getZ()) && Double.isNaN(z);
            if (isEqualZ) continue;
            return false;
        }
        return true;
    }

    public void testBounds() throws Exception {
        ReferencedEnvelope env = this.dataStore.getFeatureSource(this.tname(this.getLine3d())).getBounds();
        Envelope expected = new Envelope(1.0, 5.0, 0.0, 4.0);
        JDBCGeneric3DOnlineTest.assertEquals((Object)expected, (Object)env);
        JDBCGeneric3DOnlineTest.assertEquals((Object)CRS.getHorizontalCRS((CoordinateReferenceSystem)this.crs), (Object)env.getCoordinateReferenceSystem());
    }

    public void testRendererBehaviour() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname(this.getLine3d()));
        JDBCGeneric3DOnlineTest.assertTrue((boolean)fs.getSupportedHints().contains(Hints.JTS_COORDINATE_SEQUENCE_FACTORY));
        Query q = new Query(this.tname(this.getLine3d()));
        Hints hints = new Hints((RenderingHints.Key)Hints.JTS_COORDINATE_SEQUENCE_FACTORY, (Object)new LiteCoordinateSequenceFactory());
        q.setHints(hints);
        ContentFeatureCollection fc = fs.getFeatures(q);
        FeatureType fcSchema = fc.getSchema();
        JDBCGeneric3DOnlineTest.assertEquals((Object)this.crs, (Object)fcSchema.getCoordinateReferenceSystem());
        JDBCGeneric3DOnlineTest.assertEquals((Object)this.crs, (Object)fcSchema.getGeometryDescriptor().getCoordinateReferenceSystem());
        LineString expected = new GeometryFactory().createLineString(new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0), new Coordinate(4.0, 2.0), new Coordinate(5.0, 1.0)});
        try (FeatureReader fr = this.dataStore.getFeatureReader(q, Transaction.AUTO_COMMIT);){
            JDBCGeneric3DOnlineTest.assertEquals((Object)this.crs, (Object)((SimpleFeatureType)fr.getFeatureType()).getCoordinateReferenceSystem());
            JDBCGeneric3DOnlineTest.assertEquals((Object)this.crs, (Object)((SimpleFeatureType)fr.getFeatureType()).getGeometryDescriptor().getCoordinateReferenceSystem());
            JDBCGeneric3DOnlineTest.assertTrue((boolean)fr.hasNext());
            SimpleFeature f = (SimpleFeature)fr.next();
            JDBCGeneric3DOnlineTest.assertTrue((boolean)expected.equalsExact((Geometry)f.getDefaultGeometry()));
        }
    }
}

